/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.morphology;

import java.util.List;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.morphology.Closing;
import net.imglib2.algorithm.morphology.MorphologyUtils;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class BlackTopHat {
    public static <T extends RealType<T>> Img<T> blackTopHat(Img<T> source, List<? extends Shape> strels, int numThreads) {
        Img<T> closed = Closing.close(source, strels, numThreads);
        MorphologyUtils.subAAB(closed, source, numThreads);
        return closed;
    }

    public static <T extends Type<T> & Comparable<T>> Img<T> blackTopHat(Img<T> source, List<? extends Shape> strels, T minVal, T maxVal, int numThreads) {
        Img<T> closed = Closing.close(source, strels, minVal, maxVal, numThreads);
        MorphologyUtils.subAAB(closed, source, numThreads);
        return closed;
    }

    public static <T extends RealType<T>> Img<T> blackTopHat(Img<T> source, Shape strel, int numThreads) {
        Img<T> closed = Closing.close(source, strel, numThreads);
        MorphologyUtils.subAAB(closed, source, numThreads);
        return closed;
    }

    public static <T extends Type<T> & Comparable<T>> Img<T> blackTopHat(Img<T> source, Shape strel, T minVal, T maxVal, int numThreads) {
        Img<T> closed = Closing.close(source, strel, minVal, maxVal, numThreads);
        MorphologyUtils.subAAB(closed, source, numThreads);
        return closed;
    }

    public static <T extends RealType<T>> void blackTopHat(RandomAccessible<T> source, IterableInterval<T> target, List<? extends Shape> strels, int numThreads) {
        Closing.close(source, target, strels, numThreads);
        MorphologyUtils.subAAB2(target, source, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void blackTopHat(RandomAccessible<T> source, IterableInterval<T> target, List<? extends Shape> strels, T minVal, T maxVal, int numThreads) {
        Closing.close(source, target, strels, minVal, maxVal, numThreads);
        MorphologyUtils.subAAB2(target, source, numThreads);
    }

    public static <T extends RealType<T>> void blackTopHat(RandomAccessible<T> source, IterableInterval<T> target, Shape strel, int numThreads) {
        Closing.close(source, target, strel, numThreads);
        MorphologyUtils.subAAB2(target, source, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void blackTopHat(RandomAccessible<T> source, IterableInterval<T> target, Shape strel, T minVal, T maxVal, int numThreads) {
        Closing.close(source, target, strel, minVal, maxVal, numThreads);
        MorphologyUtils.subAAB2(target, source, numThreads);
    }

    public static <T extends RealType<T>> void blackTopHatInPlace(RandomAccessible<T> source, Interval interval, List<? extends Shape> strels, int numThreads) {
        RealType minVal = (RealType)MorphologyUtils.createVariable(source, interval);
        ImgFactory<RealType> factory = Util.getSuitableImgFactory(interval, minVal);
        Img<RealType> img = factory.create(interval);
        long[] min = new long[interval.numDimensions()];
        interval.min(min);
        IntervalView<RealType> translated = Views.translate(img, min);
        Closing.close(source, translated, strels, numThreads);
        MorphologyUtils.subABA(source, translated, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void blackTopHatInPlace(RandomAccessible<T> source, Interval interval, List<? extends Shape> strels, T minVal, T maxVal, int numThreads) {
        ImgFactory<T> factory = Util.getSuitableImgFactory(interval, minVal);
        Img<T> img = factory.create(interval);
        long[] min = new long[interval.numDimensions()];
        interval.min(min);
        IntervalView<T> translated = Views.translate(img, min);
        Closing.close(source, translated, strels, minVal, maxVal, numThreads);
        MorphologyUtils.subABA(source, translated, numThreads);
    }

    public static <T extends RealType<T>> void blackTopHatInPlace(RandomAccessible<T> source, Interval interval, Shape strel, int numThreads) {
        RealType minVal = (RealType)MorphologyUtils.createVariable(source, interval);
        ImgFactory<RealType> factory = Util.getSuitableImgFactory(interval, minVal);
        Img<RealType> img = factory.create(interval);
        long[] min = new long[interval.numDimensions()];
        interval.min(min);
        IntervalView<RealType> translated = Views.translate(img, min);
        Closing.close(source, translated, strel, numThreads);
        MorphologyUtils.subABA(source, translated, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void blackTopHatInPlace(RandomAccessible<T> source, Interval interval, Shape strel, T minVal, T maxVal, int numThreads) {
        ImgFactory<T> factory = Util.getSuitableImgFactory(interval, minVal);
        Img<T> img = factory.create(interval);
        long[] min = new long[interval.numDimensions()];
        interval.min(min);
        IntervalView<T> translated = Views.translate(img, min);
        Closing.close(source, translated, strel, minVal, maxVal, numThreads);
        MorphologyUtils.subABA(source, translated, numThreads);
    }

    private BlackTopHat() {
    }
}

