/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.morphology.distance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.algorithm.morphology.distance.Distance;
import net.imglib2.algorithm.morphology.distance.EuclidianDistanceAnisotropic;
import net.imglib2.algorithm.morphology.distance.EuclidianDistanceIsotropic;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.type.BooleanType;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.util.ValuePair;
import net.imglib2.view.Views;
import net.imglib2.view.composite.RealComposite;

public class DistanceTransform {
    public static <T extends RealType<T>> void transform(RandomAccessibleInterval<T> source, DISTANCE_TYPE distanceType, double ... weights) {
        DistanceTransform.transform(source, source, distanceType, weights);
    }

    public static <T extends RealType<T>> void transform(RandomAccessibleInterval<T> source, DISTANCE_TYPE distanceType, ExecutorService es, int nTasks, double ... weights) throws InterruptedException, ExecutionException {
        DistanceTransform.transform(source, source, distanceType, es, nTasks, weights);
    }

    public static <T extends RealType<T>, U extends RealType<U>> void transform(RandomAccessible<T> source, RandomAccessibleInterval<U> target, DISTANCE_TYPE distanceType, double ... weights) {
        DistanceTransform.transform(source, target, target, distanceType, weights);
    }

    public static <T extends RealType<T>, U extends RealType<U>> void transform(RandomAccessible<T> source, RandomAccessibleInterval<U> target, DISTANCE_TYPE distanceType, ExecutorService es, int nTasks, double ... weights) throws InterruptedException, ExecutionException {
        DistanceTransform.transform(source, target, target, distanceType, es, nTasks, weights);
    }

    public static <T extends RealType<T>, U extends RealType<U>, V extends RealType<V>> void transform(RandomAccessible<T> source, RandomAccessibleInterval<U> tmp, RandomAccessibleInterval<V> target, DISTANCE_TYPE distanceType, double ... weights) {
        boolean isIsotropic = weights.length <= 1;
        double[] w = weights.length == source.numDimensions() ? weights : DoubleStream.generate(() -> weights.length == 0 ? 1.0 : weights[0]).limit(source.numDimensions()).toArray();
        switch (distanceType) {
            case EUCLIDIAN: {
                DistanceTransform.transform(source, tmp, target, isIsotropic ? new EuclidianDistanceIsotropic(w[0]) : new EuclidianDistanceAnisotropic(w));
                break;
            }
            case L1: {
                DistanceTransform.transformL1(source, tmp, target, w);
                break;
            }
        }
    }

    public static <T extends RealType<T>, U extends RealType<U>, V extends RealType<V>> void transform(RandomAccessible<T> source, RandomAccessibleInterval<U> tmp, RandomAccessibleInterval<V> target, DISTANCE_TYPE distanceType, ExecutorService es, int nTasks, double ... weights) throws InterruptedException, ExecutionException {
        boolean isIsotropic = weights.length <= 1;
        double[] w = weights.length == source.numDimensions() ? weights : DoubleStream.generate(() -> weights.length == 0 ? 1.0 : weights[0]).limit(source.numDimensions()).toArray();
        switch (distanceType) {
            case EUCLIDIAN: {
                DistanceTransform.transform(source, tmp, target, isIsotropic ? new EuclidianDistanceIsotropic(w[0]) : new EuclidianDistanceAnisotropic(w), es, nTasks);
                break;
            }
            case L1: {
                DistanceTransform.transformL1(source, tmp, target, es, nTasks, w);
                break;
            }
        }
    }

    public static <T extends RealType<T>> void transform(RandomAccessibleInterval<T> source, Distance d) {
        DistanceTransform.transform(source, source, d);
    }

    public static <T extends RealType<T>> void transform(RandomAccessibleInterval<T> source, Distance d, ExecutorService es, int nTasks) throws InterruptedException, ExecutionException {
        DistanceTransform.transform(source, source, d, es, nTasks);
    }

    public static <T extends RealType<T>, U extends RealType<U>> void transform(RandomAccessible<T> source, RandomAccessibleInterval<U> target, Distance d) {
        DistanceTransform.transform(source, target, target, d);
    }

    public static <T extends RealType<T>, U extends RealType<U>> void transform(RandomAccessible<T> source, RandomAccessibleInterval<U> target, Distance d, ExecutorService es, int nTasks) throws InterruptedException, ExecutionException {
        DistanceTransform.transform(source, target, target, d, es, nTasks);
    }

    public static <T extends RealType<T>, U extends RealType<U>, V extends RealType<V>> void transform(RandomAccessible<T> source, RandomAccessibleInterval<U> tmp, RandomAccessibleInterval<V> target, Distance d) {
        assert (source.numDimensions() == target.numDimensions()) : "Dimension mismatch";
        int nDim = source.numDimensions();
        int lastDim = nDim - 1;
        if (nDim == 1) {
            DistanceTransform.transformAlongDimension(Views.addDimension(source), Views.addDimension(target, 0L, 0L), d, 0);
        } else {
            DistanceTransform.transformAlongDimension(source, tmp, d, 0);
        }
        for (int dim = 1; dim < nDim; ++dim) {
            if (dim == lastDim) {
                DistanceTransform.transformAlongDimension(tmp, target, d, dim);
                continue;
            }
            DistanceTransform.transformAlongDimension(tmp, tmp, d, dim);
        }
    }

    public static <T extends RealType<T>, U extends RealType<U>, V extends RealType<V>> void transform(RandomAccessible<T> source, RandomAccessibleInterval<U> tmp, RandomAccessibleInterval<V> target, Distance d, ExecutorService es, int nTasks) throws InterruptedException, ExecutionException {
        assert (source.numDimensions() == target.numDimensions()) : "Dimension mismatch";
        int nDim = source.numDimensions();
        int lastDim = nDim - 1;
        if (nDim == 1) {
            DistanceTransform.transformAlongDimensionParallel(Views.addDimension(source), Views.addDimension(target, 0L, 0L), d, 0, es, nTasks);
        } else {
            DistanceTransform.transformAlongDimensionParallel(source, tmp, d, 0, es, nTasks);
        }
        for (int dim = 1; dim < nDim; ++dim) {
            if (dim == lastDim) {
                DistanceTransform.transformAlongDimensionParallel(tmp, target, d, dim, es, nTasks);
                continue;
            }
            DistanceTransform.transformAlongDimensionParallel(tmp, tmp, d, dim, es, nTasks);
        }
    }

    public static <B extends BooleanType<B>, U extends RealType<U>> void binaryTransform(RandomAccessible<B> source, RandomAccessibleInterval<U> target, DISTANCE_TYPE distanceType, double ... weights) {
        DistanceTransform.binaryTransform(source, target, target, distanceType, weights);
    }

    public static <B extends BooleanType<B>, U extends RealType<U>> void binaryTransform(RandomAccessible<B> source, RandomAccessibleInterval<U> target, DISTANCE_TYPE distanceType, ExecutorService es, int nTasks, double ... weights) throws InterruptedException, ExecutionException {
        DistanceTransform.binaryTransform(source, target, target, distanceType, es, nTasks, weights);
    }

    public static <B extends BooleanType<B>, U extends RealType<U>, V extends RealType<V>> void binaryTransform(RandomAccessible<B> source, RandomAccessibleInterval<U> tmp, RandomAccessibleInterval<V> target, DISTANCE_TYPE distanceType, double ... weights) {
        RealType maxVal = (RealType)((RealType)tmp.getType()).createVariable();
        maxVal.setReal(maxVal.getMaxValue());
        BinaryMaskToCost converter = new BinaryMaskToCost(maxVal);
        RandomAccessible<RealType> converted = Converters.convert(source, converter, maxVal.createVariable());
        DistanceTransform.transform(converted, tmp, target, distanceType, weights);
    }

    public static <B extends BooleanType<B>, U extends RealType<U>, V extends RealType<V>> void binaryTransform(RandomAccessible<B> source, RandomAccessibleInterval<U> tmp, RandomAccessibleInterval<V> target, DISTANCE_TYPE distanceType, ExecutorService es, int nTasks, double ... weights) throws InterruptedException, ExecutionException {
        RealType maxVal = (RealType)((RealType)tmp.getType()).createVariable();
        maxVal.setReal(maxVal.getMaxValue());
        BinaryMaskToCost converter = new BinaryMaskToCost(maxVal);
        RandomAccessible<RealType> converted = Converters.convert(source, converter, maxVal.createVariable());
        DistanceTransform.transform(converted, tmp, target, distanceType, es, nTasks, weights);
    }

    public static <B extends BooleanType<B>> void binaryTransform(RandomAccessibleInterval<B> source, Distance d, ExecutorService es, int nTasks) throws InterruptedException, ExecutionException {
        DistanceTransform.binaryTransform(source, source, d, es, nTasks);
    }

    public static <B extends BooleanType<B>, U extends RealType<U>> void binaryTransform(RandomAccessible<B> source, RandomAccessibleInterval<U> target, Distance d) {
        DistanceTransform.binaryTransform(source, target, target, d);
    }

    public static <B extends BooleanType<B>, U extends RealType<U>> void binaryTransform(RandomAccessible<B> source, RandomAccessibleInterval<U> target, Distance d, ExecutorService es, int nTasks) throws InterruptedException, ExecutionException {
        DistanceTransform.binaryTransform(source, target, target, d, es, nTasks);
    }

    public static <B extends BooleanType<B>, U extends RealType<U>, V extends RealType<V>> void binaryTransform(RandomAccessible<B> source, RandomAccessibleInterval<U> tmp, RandomAccessibleInterval<V> target, Distance d) {
        RealType maxVal = (RealType)((RealType)tmp.getType()).createVariable();
        maxVal.setReal(maxVal.getMaxValue());
        BinaryMaskToCost converter = new BinaryMaskToCost(maxVal);
        RandomAccessible<RealType> converted = Converters.convert(source, converter, maxVal.createVariable());
        DistanceTransform.transform(converted, tmp, target, d);
    }

    public static <B extends BooleanType<B>, U extends RealType<U>, V extends RealType<V>> void binaryTransform(RandomAccessible<B> source, RandomAccessibleInterval<U> tmp, RandomAccessibleInterval<V> target, Distance d, ExecutorService es, int nTasks) throws InterruptedException, ExecutionException {
        RealType maxVal = (RealType)((RealType)tmp.getType()).createVariable();
        maxVal.setReal(maxVal.getMaxValue());
        BinaryMaskToCost converter = new BinaryMaskToCost(maxVal);
        RandomAccessible<RealType> converted = Converters.convert(source, converter, maxVal.createVariable());
        DistanceTransform.transform(converted, tmp, target, d, es, nTasks);
    }

    private static <T extends RealType<T>, U extends RealType<U>, V extends RealType<V>> void transformL1(RandomAccessible<T> source, RandomAccessibleInterval<U> tmp, RandomAccessibleInterval<V> target, double ... weights) {
        assert (source.numDimensions() == target.numDimensions()) : "Dimension mismatch";
        int nDim = source.numDimensions();
        int lastDim = nDim - 1;
        if (nDim == 1) {
            DistanceTransform.transformL1AlongDimension(Views.addDimension(source), Views.addDimension(target, 0L, 0L), 0, weights[0]);
        } else {
            DistanceTransform.transformL1AlongDimension(source, tmp, 0, weights[0]);
        }
        for (int dim = 1; dim < nDim; ++dim) {
            if (dim == lastDim) {
                DistanceTransform.transformL1AlongDimension(tmp, target, dim, weights[dim]);
                continue;
            }
            DistanceTransform.transformL1AlongDimension(tmp, tmp, dim, weights[dim]);
        }
    }

    private static <T extends RealType<T>, U extends RealType<U>, V extends RealType<V>> void transformL1(RandomAccessible<T> source, RandomAccessibleInterval<U> tmp, RandomAccessibleInterval<V> target, ExecutorService es, int nTasks, double ... weights) throws InterruptedException, ExecutionException {
        assert (source.numDimensions() == target.numDimensions()) : "Dimension mismatch";
        int nDim = source.numDimensions();
        int lastDim = nDim - 1;
        if (nDim == 1) {
            DistanceTransform.transformL1AlongDimensionParallel(Views.addDimension(source), Views.addDimension(target, 0L, 0L), 0, weights[0], es, nTasks);
        } else {
            DistanceTransform.transformL1AlongDimensionParallel(source, tmp, 0, weights[0], es, nTasks);
        }
        for (int dim = 1; dim < nDim; ++dim) {
            if (dim == lastDim) {
                DistanceTransform.transformL1AlongDimensionParallel(tmp, target, dim, weights[dim], es, nTasks);
                continue;
            }
            DistanceTransform.transformL1AlongDimensionParallel(tmp, tmp, dim, weights[dim], es, nTasks);
        }
    }

    private static <T extends RealType<T>, U extends RealType<U>> void transformAlongDimension(RandomAccessible<T> source, RandomAccessibleInterval<U> target, Distance d, int dim) {
        int lastDim = target.numDimensions() - 1;
        long size = target.dimension(dim);
        RealComposite tmp = (RealComposite)Views.collapseReal(DistanceTransform.createAppropriateOneDimensionalImage(size, new DoubleType())).randomAccess().get();
        RealCursor s = Views.flatIterable(Views.collapseReal(dim == lastDim ? Views.interval(source, target) : Views.permute(Views.interval(source, target), dim, lastDim))).cursor();
        RealCursor t = Views.flatIterable(Views.collapseReal(dim == lastDim ? target : Views.permute(target, dim, lastDim))).cursor();
        RealComposite lowerBoundDistanceIndex = (RealComposite)Views.collapseReal(DistanceTransform.createAppropriateOneDimensionalImage(size, new LongType())).randomAccess().get();
        RealComposite envelopeIntersectLocation = (RealComposite)Views.collapseReal(DistanceTransform.createAppropriateOneDimensionalImage(size + 1L, new DoubleType())).randomAccess().get();
        while (s.hasNext()) {
            RealComposite sourceComp = (RealComposite)s.next();
            RealComposite targetComp = (RealComposite)t.next();
            for (long i = 0L; i < size; ++i) {
                ((DoubleType)tmp.get(i)).set(((RealType)sourceComp.get(i)).getRealDouble());
            }
            DistanceTransform.transformSingleColumn(tmp, targetComp, lowerBoundDistanceIndex, envelopeIntersectLocation, d, dim, size);
        }
    }

    private static <T extends RealType<T>, U extends RealType<U>> void transformAlongDimensionParallel(RandomAccessible<T> source, RandomAccessibleInterval<U> target, Distance d, int dim, ExecutorService es, int nTasks) throws InterruptedException, ExecutionException {
        int largestDim = DistanceTransform.getLargestDimension(Views.hyperSlice(target, dim, target.min(dim)));
        if (largestDim >= dim) {
            ++largestDim;
        }
        long size = target.dimension(dim);
        long stepPerChunk = Math.max(size / (long)nTasks, 1L);
        long[] min = Intervals.minAsLongArray(target);
        long[] max = Intervals.maxAsLongArray(target);
        long largestDimMin = target.min(largestDim);
        long largestDimMax = target.max(largestDim);
        ArrayList<Callable<T>> tasks = new ArrayList<Callable<T>>();
        long m = largestDimMin;
        long M = largestDimMin + stepPerChunk - 1L;
        while (m <= largestDimMax) {
            min[largestDim] = m;
            max[largestDim] = Math.min(M, largestDimMax);
            FinalInterval fi = new FinalInterval(min, max);
            tasks.add(() -> {
                DistanceTransform.transformAlongDimension(source, Views.interval(target, fi), d, dim);
                return null;
            });
            m += stepPerChunk;
            M += stepPerChunk;
        }
        DistanceTransform.invokeAllAndWait(es, tasks);
    }

    private static <T extends RealType<T>, U extends RealType<U>> void transformSingleColumn(RealComposite<T> source, RealComposite<U> target, RealComposite<LongType> lowerBoundDistanceIndex, RealComposite<DoubleType> envelopeIntersectLocation, Distance d, int dim, long size) {
        long envelopeIndexAtK;
        long position;
        long k = 0L;
        ((LongType)lowerBoundDistanceIndex.get(0L)).set(0L);
        ((DoubleType)envelopeIntersectLocation.get(0L)).set(Double.NEGATIVE_INFINITY);
        ((DoubleType)envelopeIntersectLocation.get(1L)).set(Double.POSITIVE_INFINITY);
        for (position = 1L; position < size; ++position) {
            envelopeIndexAtK = ((LongType)lowerBoundDistanceIndex.get(k)).get();
            double sourceAtPosition = ((RealType)source.get(position)).getRealDouble();
            double s = d.intersect(envelopeIndexAtK, ((RealType)source.get(envelopeIndexAtK)).getRealDouble(), position, sourceAtPosition, dim);
            double envelopeValueAtK = ((DoubleType)envelopeIntersectLocation.get(k)).get();
            while (s <= envelopeValueAtK) {
                envelopeIndexAtK = ((LongType)lowerBoundDistanceIndex.get(--k)).get();
                s = d.intersect(envelopeIndexAtK, ((RealType)source.get(envelopeIndexAtK)).getRealDouble(), position, sourceAtPosition, dim);
                envelopeValueAtK = ((DoubleType)envelopeIntersectLocation.get(k)).get();
            }
            ((LongType)lowerBoundDistanceIndex.get(++k)).set(position);
            ((DoubleType)envelopeIntersectLocation.get(k)).set(s);
            ((DoubleType)envelopeIntersectLocation.get(k + 1L)).set(Double.POSITIVE_INFINITY);
        }
        k = 0L;
        for (position = 0L; position < size; ++position) {
            while (((DoubleType)envelopeIntersectLocation.get(k + 1L)).get() < (double)position) {
                ++k;
            }
            envelopeIndexAtK = ((LongType)lowerBoundDistanceIndex.get(k)).get();
            ((RealType)target.get(position)).setReal(d.evaluate(position, envelopeIndexAtK, ((RealType)source.get(envelopeIndexAtK)).getRealDouble(), dim));
        }
    }

    private static <T extends RealType<T>, U extends RealType<U>> void transformL1AlongDimension(RandomAccessible<T> source, RandomAccessibleInterval<U> target, int dim, double weight) {
        int lastDim = target.numDimensions() - 1;
        long size = target.dimension(dim);
        RealComposite tmp = (RealComposite)Views.collapseReal(DistanceTransform.createAppropriateOneDimensionalImage(size, new DoubleType())).randomAccess().get();
        RealCursor s = Views.flatIterable(Views.collapseReal(dim == lastDim ? Views.interval(source, target) : Views.permute(Views.interval(source, target), dim, lastDim))).cursor();
        RealCursor t = Views.flatIterable(Views.collapseReal(dim == lastDim ? target : Views.permute(target, dim, lastDim))).cursor();
        while (s.hasNext()) {
            RealComposite sourceComp = (RealComposite)s.next();
            RealComposite targetComp = (RealComposite)t.next();
            for (long i = 0L; i < size; ++i) {
                ((DoubleType)tmp.get(i)).set(((RealType)sourceComp.get(i)).getRealDouble());
            }
            DistanceTransform.transformL1SingleColumn(tmp, targetComp, weight, size);
        }
    }

    private static <T extends RealType<T>, U extends RealType<U>> void transformL1AlongDimensionParallel(RandomAccessible<T> source, RandomAccessibleInterval<U> target, int dim, double weight, ExecutorService es, int nTasks) throws InterruptedException, ExecutionException {
        int largestDim = DistanceTransform.getLargestDimension(Views.hyperSlice(target, dim, target.min(dim)));
        if (largestDim >= dim) {
            ++largestDim;
        }
        long size = target.dimension(dim);
        long stepPerChunk = Math.max(size / (long)nTasks, 1L);
        long[] min = Intervals.minAsLongArray(target);
        long[] max = Intervals.maxAsLongArray(target);
        long largestDimMin = target.min(largestDim);
        long largestDimMax = target.max(largestDim);
        ArrayList<Callable<T>> tasks = new ArrayList<Callable<T>>();
        long m = largestDimMin;
        long M = largestDimMin + stepPerChunk - 1L;
        while (m <= largestDimMax) {
            min[largestDim] = m;
            max[largestDim] = Math.min(M, largestDimMax);
            FinalInterval fi = new FinalInterval(min, max);
            tasks.add(() -> {
                DistanceTransform.transformL1AlongDimension(source, Views.interval(target, fi), dim, weight);
                return null;
            });
            m += stepPerChunk;
            M += stepPerChunk;
        }
        DistanceTransform.invokeAllAndWait(es, tasks);
    }

    private static <T extends RealType<T>, U extends RealType<U>> void transformL1SingleColumn(RealComposite<T> source, RealComposite<U> target, double weight, long size) {
        double other;
        long i;
        ((RealType)target.get(0L)).setReal(((RealType)source.get(0L)).getRealDouble());
        for (i = 1L; i < size; ++i) {
            other = ((RealType)target.get(i - 1L)).getRealDouble();
            ((RealType)target.get(i)).setReal(Math.min(((RealType)source.get(i)).getRealDouble(), other + weight));
        }
        for (i = size - 2L; i > -1L; --i) {
            other = ((RealType)target.get(i + 1L)).getRealDouble();
            RealType t = (RealType)target.get(i);
            t.setReal(Math.min(t.getRealDouble(), other + weight));
        }
    }

    private static <T> void invokeAllAndWait(ExecutorService es, Collection<Callable<T>> tasks) throws InterruptedException, ExecutionException {
        List<Future<T>> futures = es.invokeAll(tasks);
        for (Future<T> f : futures) {
            f.get();
        }
    }

    private static <T extends NativeType<T> & RealType<T>> Img<T> createAppropriateOneDimensionalImage(long size, T t) {
        long[] dim = new long[]{1L, size};
        return size > Integer.MAX_VALUE ? new CellImgFactory<T>(t, Integer.MAX_VALUE).create(dim) : new ArrayImgFactory<T>(t).create(dim);
    }

    public static <L extends IntegerType<L>> RandomAccessibleInterval<DoubleType> voronoiDistanceTransform(RandomAccessibleInterval<L> labels, double ... weights) {
        return DistanceTransform.voronoiDistanceTransform(labels, 0L, weights);
    }

    public static <L extends IntegerType<L>> RandomAccessibleInterval<DoubleType> voronoiDistanceTransform(RandomAccessibleInterval<L> labels, long backgroundLabel, double ... weights) {
        RandomAccessibleInterval<DoubleType> distance = DistanceTransform.makeDistances(backgroundLabel, labels, new DoubleType());
        DistanceTransform.voronoiDistanceTransform(labels, distance, weights);
        return distance;
    }

    public static <L extends IntegerType<L>> RandomAccessibleInterval<DoubleType> voronoiDistanceTransform(RandomAccessibleInterval<L> labels, long backgroundLabel, ExecutorService es, int nTasks, double ... weights) throws InterruptedException, ExecutionException {
        RandomAccessibleInterval<DoubleType> distance = DistanceTransform.makeDistances(backgroundLabel, labels, new DoubleType());
        DistanceTransform.labelTransform(labels, distance, es, nTasks, weights);
        return distance;
    }

    public static <L extends IntegerType<L>, T extends RealType<T>> void voronoiDistanceTransform(RandomAccessibleInterval<L> labels, RandomAccessibleInterval<T> distance, double ... weights) {
        Distance distanceFun = DistanceTransform.createEuclideanDistance(labels.numDimensions(), weights);
        DistanceTransform.transformPropagateLabels(distance, distance, distance, labels, labels, distanceFun);
    }

    public static <L extends IntegerType<L>, T extends RealType<T>> void labelTransform(RandomAccessibleInterval<L> labels, RandomAccessibleInterval<T> distance, ExecutorService es, int nTasks, double ... weights) throws InterruptedException, ExecutionException {
        Distance distanceFun = DistanceTransform.createEuclideanDistance(labels.numDimensions(), weights);
        DistanceTransform.transformPropagateLabels(distance, distance, distance, labels, labels, distanceFun, es, nTasks);
    }

    public static <T extends RealType<T>, L extends IntegerType<L>> void transformPropagateLabels(RandomAccessibleInterval<T> distance, RandomAccessibleInterval<L> labels) {
        DistanceTransform.transformPropagateLabels(distance, distance, labels, labels, new EuclidianDistanceIsotropic(1.0));
    }

    public static <T extends RealType<T>, U extends RealType<U>, L extends IntegerType<L>, M extends IntegerType<M>> void transformPropagateLabels(RandomAccessible<T> distance, RandomAccessibleInterval<U> targetDistance, RandomAccessible<L> labels, RandomAccessibleInterval<M> labelsResult, Distance d) {
        DistanceTransform.transformPropagateLabels(distance, targetDistance, targetDistance, labels, labelsResult, d);
    }

    public static <T extends RealType<T>, U extends RealType<U>, V extends RealType<V>, L extends IntegerType<L>, M extends IntegerType<M>> void transformPropagateLabels(RandomAccessible<T> distance, RandomAccessibleInterval<U> tmpDistance, RandomAccessibleInterval<V> targetDistance, RandomAccessible<L> labels, RandomAccessibleInterval<M> labelsResult, Distance d) {
        assert (distance.numDimensions() == targetDistance.numDimensions()) : "Dimension mismatch";
        int nDim = distance.numDimensions();
        int lastDim = nDim - 1;
        if (nDim == 1) {
            DistanceTransform.transformAlongDimensionPropagateLabels(Views.addDimension(distance), Views.addDimension(targetDistance, 0L, 0L), Views.addDimension(labels), Views.addDimension(labelsResult), d, 0);
        } else {
            DistanceTransform.transformAlongDimensionPropagateLabels(distance, tmpDistance, labels, labelsResult, d, 0);
        }
        for (int dim = 1; dim < nDim; ++dim) {
            if (dim == lastDim) {
                DistanceTransform.transformAlongDimensionPropagateLabels(tmpDistance, targetDistance, labels, labelsResult, d, dim);
                continue;
            }
            DistanceTransform.transformAlongDimensionPropagateLabels(tmpDistance, tmpDistance, labels, labelsResult, d, dim);
        }
    }

    public static <T extends RealType<T>, U extends RealType<U>, V extends RealType<V>, L extends IntegerType<L>, M extends IntegerType<M>> void transformPropagateLabels(RandomAccessible<T> distance, RandomAccessibleInterval<U> tmpDistance, RandomAccessibleInterval<V> targetDistance, RandomAccessible<L> labels, RandomAccessibleInterval<M> labelsResult, Distance d, ExecutorService es, int nTasks) throws InterruptedException, ExecutionException {
        assert (distance.numDimensions() == targetDistance.numDimensions()) : "Dimension mismatch";
        int nDim = distance.numDimensions();
        int lastDim = nDim - 1;
        if (nDim == 1) {
            DistanceTransform.transformAlongDimensionPropagateLabels(Views.addDimension(distance), Views.addDimension(targetDistance, 0L, 0L), Views.addDimension(labels), Views.addDimension(labelsResult), d, 0);
        } else {
            DistanceTransform.transformAlongDimensionPropagateLabelsParallel(distance, tmpDistance, labels, labelsResult, d, 0, es, nTasks);
        }
        for (int dim = 1; dim < nDim; ++dim) {
            if (dim == lastDim) {
                DistanceTransform.transformAlongDimensionPropagateLabelsParallel(tmpDistance, targetDistance, labels, labelsResult, d, dim, es, nTasks);
                continue;
            }
            DistanceTransform.transformAlongDimensionPropagateLabelsParallel(tmpDistance, tmpDistance, labels, labelsResult, d, dim, es, nTasks);
        }
    }

    private static <T extends RealType<T>, U extends RealType<U>, L extends IntegerType<L>, M extends IntegerType<M>> void transformAlongDimensionPropagateLabels(RandomAccessible<T> source, RandomAccessibleInterval<U> target, RandomAccessible<L> labelSource, RandomAccessible<M> labelTarget, Distance d, int dim) {
        int lastDim = target.numDimensions() - 1;
        long size = target.dimension(dim);
        Img<DoubleType> tmpImg = DistanceTransform.createAppropriateOneDimensionalImage(size, new DoubleType());
        RealComposite tmp = (RealComposite)Views.collapseReal(tmpImg).randomAccess().get();
        Img tmpLabelImg = Util.getSuitableImgFactory(tmpImg, labelSource.getType()).create(tmpImg);
        RealComposite tmpLabel = (RealComposite)Views.collapseReal(tmpLabelImg).randomAccess().get();
        RealCursor s = Views.flatIterable(Views.collapseReal(dim == lastDim ? Views.interval(source, target) : Views.permute(Views.interval(source, target), dim, lastDim))).cursor();
        RealCursor t = Views.flatIterable(Views.collapseReal(dim == lastDim ? target : Views.permute(target, dim, lastDim))).cursor();
        RealCursor ls = Views.flatIterable(Views.collapseReal(dim == lastDim ? Views.interval(labelSource, target) : Views.permute(Views.interval(labelSource, target), dim, lastDim))).cursor();
        RealCursor lt = Views.flatIterable(Views.collapseReal(dim == lastDim ? Views.interval(labelTarget, target) : Views.permute(Views.interval(labelTarget, target), dim, lastDim))).cursor();
        RealComposite lowerBoundDistanceIndex = (RealComposite)Views.collapseReal(DistanceTransform.createAppropriateOneDimensionalImage(size, new LongType())).randomAccess().get();
        RealComposite envelopeIntersectLocation = (RealComposite)Views.collapseReal(DistanceTransform.createAppropriateOneDimensionalImage(size + 1L, new DoubleType())).randomAccess().get();
        while (s.hasNext()) {
            RealComposite sourceComp = (RealComposite)s.next();
            RealComposite targetComp = (RealComposite)t.next();
            RealComposite labelComp = (RealComposite)ls.next();
            RealComposite labelTargetComp = (RealComposite)lt.next();
            for (long i = 0L; i < size; ++i) {
                ((DoubleType)tmp.get(i)).set(((RealType)sourceComp.get(i)).getRealDouble());
                ((IntegerType)tmpLabel.get(i)).setInteger(((IntegerType)labelComp.get(i)).getIntegerLong());
            }
            DistanceTransform.transformSingleColumnPropagateLabels(tmp, targetComp, tmpLabel, labelTargetComp, lowerBoundDistanceIndex, envelopeIntersectLocation, d, dim, size);
        }
    }

    private static <T extends RealType<T>, U extends RealType<U>, L extends IntegerType<L>, M extends IntegerType<M>> void transformSingleColumnPropagateLabels(RealComposite<T> source, RealComposite<U> target, RealComposite<L> labelsSource, RealComposite<M> labelsResult, RealComposite<LongType> lowerBoundDistanceIndex, RealComposite<DoubleType> envelopeIntersectLocation, Distance d, int dim, long size) {
        long envelopeIndexAtK;
        long position;
        long k = 0L;
        ((LongType)lowerBoundDistanceIndex.get(0L)).set(0L);
        ((DoubleType)envelopeIntersectLocation.get(0L)).set(Double.NEGATIVE_INFINITY);
        ((DoubleType)envelopeIntersectLocation.get(1L)).set(Double.POSITIVE_INFINITY);
        for (position = 1L; position < size; ++position) {
            envelopeIndexAtK = ((LongType)lowerBoundDistanceIndex.get(k)).get();
            double sourceAtPosition = ((RealType)source.get(position)).getRealDouble();
            double s = d.intersect(envelopeIndexAtK, ((RealType)source.get(envelopeIndexAtK)).getRealDouble(), position, sourceAtPosition, dim);
            double envelopeValueAtK = ((DoubleType)envelopeIntersectLocation.get(k)).get();
            while (s <= envelopeValueAtK) {
                envelopeIndexAtK = ((LongType)lowerBoundDistanceIndex.get(--k)).get();
                s = d.intersect(envelopeIndexAtK, ((RealType)source.get(envelopeIndexAtK)).getRealDouble(), position, sourceAtPosition, dim);
                envelopeValueAtK = ((DoubleType)envelopeIntersectLocation.get(k)).get();
            }
            ((LongType)lowerBoundDistanceIndex.get(++k)).set(position);
            ((DoubleType)envelopeIntersectLocation.get(k)).set(s);
            ((DoubleType)envelopeIntersectLocation.get(k + 1L)).set(Double.POSITIVE_INFINITY);
        }
        k = 0L;
        for (position = 0L; position < size; ++position) {
            while (((DoubleType)envelopeIntersectLocation.get(k + 1L)).get() < (double)position) {
                ++k;
            }
            envelopeIndexAtK = ((LongType)lowerBoundDistanceIndex.get(k)).get();
            ((RealType)target.get(position)).setReal(d.evaluate(position, envelopeIndexAtK, ((RealType)source.get(envelopeIndexAtK)).getRealDouble(), dim));
            ((IntegerType)labelsResult.get(position)).setInteger(((IntegerType)labelsSource.get(envelopeIndexAtK)).getIntegerLong());
        }
    }

    private static <T extends RealType<T>, U extends RealType<U>, L extends IntegerType<L>, M extends IntegerType<M>> void transformAlongDimensionPropagateLabelsParallel(RandomAccessible<T> source, RandomAccessibleInterval<U> target, RandomAccessible<L> labelSource, RandomAccessible<M> labelTarget, Distance d, int dim, ExecutorService es, int nTasks) throws InterruptedException, ExecutionException {
        int largestDim = DistanceTransform.getLargestDimension(Views.hyperSlice(target, dim, target.min(dim)));
        if (largestDim >= dim) {
            ++largestDim;
        }
        long size = target.dimension(dim);
        long stepPerChunk = Math.max(size / (long)nTasks, 1L);
        long[] min = Intervals.minAsLongArray(target);
        long[] max = Intervals.maxAsLongArray(target);
        long largestDimMin = target.min(largestDim);
        long largestDimMax = target.max(largestDim);
        ArrayList<Callable<T>> tasks = new ArrayList<Callable<T>>();
        long m = largestDimMin;
        long M = largestDimMin + stepPerChunk - 1L;
        while (m <= largestDimMax) {
            min[largestDim] = m;
            max[largestDim] = Math.min(M, largestDimMax);
            FinalInterval fi = new FinalInterval(min, max);
            tasks.add(() -> {
                DistanceTransform.transformAlongDimensionPropagateLabels(source, Views.interval(target, fi), labelSource, Views.interval(labelTarget, fi), d, dim);
                return null;
            });
            m += stepPerChunk;
            M += stepPerChunk;
        }
        DistanceTransform.invokeAllAndWait(es, tasks);
    }

    private static Distance createEuclideanDistance(int numDimensions, double ... weights) {
        boolean isIsotropic = weights.length <= 1;
        double[] w = weights.length == numDimensions ? weights : DoubleStream.generate(() -> weights.length == 0 ? 1.0 : weights[0]).limit(numDimensions).toArray();
        return isIsotropic ? new EuclidianDistanceIsotropic(w[0]) : new EuclidianDistanceAnisotropic(w);
    }

    public static int getLargestDimension(Interval interval) {
        return (Integer)IntStream.range(0, interval.numDimensions()).mapToObj(i -> new ValuePair<Integer, Long>(i, interval.dimension(i))).max((p1, p2) -> Long.compare((Long)p1.getB(), (Long)p2.getB())).get().getA();
    }

    private static <L extends IntegerType<L>, T extends RealType<T>> RandomAccessibleInterval<T> makeDistances(long label, RandomAccessibleInterval<L> labels, T type) {
        RealType maxVal = (RealType)type.copy();
        maxVal.setReal(maxVal.getMaxValue());
        Img<T> distances = Util.getSuitableImgFactory(labels, type).create(labels);
        Views.pair(labels, distances).view().interval(labels).forEach(pair -> {
            if (((IntegerType)pair.getA()).getIntegerLong() == label) {
                ((RealType)pair.getB()).set(maxVal);
            }
        });
        return distances;
    }

    private static class BinaryMaskToCost<B extends BooleanType<B>, R extends RealType<R>>
    implements Converter<B, R> {
        private final R maxValForR;
        private final R zero;

        public BinaryMaskToCost(R maxValForR) {
            this.maxValForR = maxValForR;
            this.zero = (RealType)maxValForR.createVariable();
            this.zero.setZero();
        }

        @Override
        public void convert(B input, R output) {
            output.set(input.get() ? this.zero : this.maxValForR);
        }
    }

    public static enum DISTANCE_TYPE {
        EUCLIDIAN,
        L1;

    }
}

