/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action.edit;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.jhotdraw.app.action.edit.AbstractSelectionAction;
import org.jhotdraw.gui.EditableComponent;
import org.jhotdraw.util.ResourceBundleUtil;

public class ClearSelectionAction
extends AbstractSelectionAction {
    public static final String ID = "edit.clearSelection";

    public ClearSelectionAction() {
        this((JComponent)null);
    }

    public ClearSelectionAction(@Nullable JComponent target) {
        super(target);
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JComponent c = this.target;
        if (c == null && KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() instanceof JComponent) {
            c = (JComponent)KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        }
        if (c != null && c.isEnabled()) {
            if (c instanceof EditableComponent) {
                ((EditableComponent)((Object)c)).clearSelection();
            } else if (c instanceof JTextComponent) {
                JTextComponent tc = (JTextComponent)c;
                tc.select(tc.getSelectionStart(), tc.getSelectionStart());
            } else {
                c.getToolkit().beep();
            }
        }
    }

    @Override
    protected void updateEnabled() {
        if (this.target != null) {
            this.setEnabled(this.target.isEnabled());
        }
    }
}

