/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;
import org.jhotdraw.gui.plaf.palette.PaletteLabelUI;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;

public class PaletteFontChooserPreviewPanel
extends JPanel {
    private JLabel previewLabel;

    public PaletteFontChooserPreviewPanel() {
        this.initComponents();
        this.previewLabel.setUI((LabelUI)PaletteLabelUI.createUI(this.previewLabel));
        this.previewLabel.setBackground(Color.WHITE);
        this.previewLabel.setForeground(Color.BLACK);
        this.previewLabel.setOpaque(true);
        this.setPreferredSize(new Dimension(100, 50));
        this.setMinimumSize(new Dimension(100, 50));
    }

    public void setSelectedFont(Font newValue) {
        if (newValue == null) {
            this.previewLabel.setText((String)PaletteLookAndFeel.getInstance().get("FontChooser.nothingSelected"));
            this.previewLabel.setFont(this.getFont());
        } else {
            this.previewLabel.setText(this.beautifyName(newValue.getFontName()));
            this.previewLabel.setFont(newValue.deriveFont(24.0f));
        }
    }

    private String beautifyName(String name) {
        StringBuilder buf = new StringBuilder();
        char prev = name.charAt(0);
        buf.append(prev);
        for (int i = 1; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (prev != ' ' && prev != '-' && Character.isUpperCase(ch) && !Character.isUpperCase(prev) || Character.isDigit(ch) && !Character.isDigit(prev)) {
                buf.append(' ');
            }
            buf.append(ch);
            prev = ch;
        }
        name = buf.toString();
        return name;
    }

    private void initComponents() {
        this.previewLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.previewLabel.setHorizontalAlignment(0);
        this.add((Component)this.previewLabel, "Center");
    }
}

