/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import org.jhotdraw.gui.plaf.palette.BackdropBorder;
import org.jhotdraw.gui.plaf.palette.PaletteButtonBorder;
import org.jhotdraw.gui.plaf.palette.PaletteTextComponentBorder;

public class PaletteLookAndFeel
extends BasicLookAndFeel {
    private static PaletteLookAndFeel instance;
    private UIDefaults cachedDefaults;

    public static PaletteLookAndFeel getInstance() {
        if (instance == null) {
            instance = new PaletteLookAndFeel();
        }
        return instance;
    }

    @Override
    public String getName() {
        return "Palette Look and Feel";
    }

    @Override
    public String getID() {
        return "Palette";
    }

    @Override
    public String getDescription() {
        return "A look and feel for palette components";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public UIDefaults getCachedDefaults() {
        if (this.cachedDefaults == null) {
            this.cachedDefaults = this.getDefaults();
        }
        return this.cachedDefaults;
    }

    public Object get(Object key) {
        UIDefaults defaults = this.getCachedDefaults();
        Object value = defaults.get(key);
        if (!(value instanceof UIDefaults.ActiveValue) && !(value instanceof UIDefaults.LazyValue)) {
            return value;
        }
        return value;
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public Border getBorder(String key) {
        return (Border)this.get(key);
    }

    public Color getColor(String key) {
        return (Color)this.get(key);
    }

    public Font getFont(String key) {
        return (Font)this.get(key);
    }

    public Icon getIcon(String key) {
        return (Icon)this.get(key);
    }

    public int getInt(String key) {
        return (Integer)this.get(key);
    }

    public Insets getInsets(String key) {
        return (Insets)this.get(key);
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public static void installColorsAndFont(JComponent c, String defaultBgName, String defaultFgName, String defaultFontName) {
        Font f = c.getFont();
        if (f == null || f instanceof UIResource) {
            c.setFont(PaletteLookAndFeel.getInstance().getFont(defaultFontName));
        }
        PaletteLookAndFeel.installColors(c, defaultBgName, defaultFgName);
    }

    public static void installBorder(JComponent c, String defaultBorderName) {
        Border b = c.getBorder();
        if (b == null || b instanceof UIResource) {
            c.setBorder(PaletteLookAndFeel.getInstance().getBorder(defaultBorderName));
        }
    }

    public static void installColors(JComponent c, String defaultBgName, String defaultFgName) {
        Color fg;
        PaletteLookAndFeel plaf = PaletteLookAndFeel.getInstance();
        Color bg = c.getBackground();
        if (bg == null || bg instanceof UIResource) {
            c.setBackground(plaf.getColor(defaultBgName));
        }
        if ((fg = c.getForeground()) == null || fg instanceof UIResource) {
            c.setForeground(plaf.getColor(defaultFgName));
        }
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        table.addResourceBundle("org.jhotdraw.gui.Labels");
        if (table.getString("ColorChooser.rgbSliders") == null) {
            ResourceBundle rb = ResourceBundle.getBundle("org.jhotdraw.gui.Labels");
            Enumeration<String> keys = rb.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                table.put(key, rb.getObject(key));
            }
        }
        Integer fontPlain = 0;
        Integer fontBold = 1;
        UIDefaults.ProxyLazyValue dialogPlain11 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Dialog Sans", fontPlain, 11});
        UIDefaults.ProxyLazyValue dialogPlain12 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Dialog Sans", fontPlain, 12});
        UIDefaults.ProxyLazyValue fieldPlain12 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Verdana", fontPlain, 12});
        UIDefaults.ProxyLazyValue dialogBold12 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Dialog", fontBold, 12});
        ColorUIResource black = new ColorUIResource(Color.black);
        ColorUIResource control = new ColorUIResource(0xF0F0F0);
        ColorUIResource controlText = black;
        ColorUIResource selectionBackground = new ColorUIResource(11916799);
        ColorUIResource selectionForeground = black;
        ColorUIResource listSelectionBackground = new ColorUIResource(3700183);
        UIDefaults.ProxyLazyValue focusCellHighlightBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{listSelectionBackground});
        InsetsUIResource zeroInsets = new InsetsUIResource(0, 0, 0, 0);
        BackdropBorder.UIResource buttonBorder = new BackdropBorder.UIResource(new PaletteButtonBorder());
        BackdropBorder.UIResource textBorder = new BackdropBorder.UIResource(new PaletteTextComponentBorder());
        Object[] defaults = new Object[]{"SmallSystemFont", dialogPlain11, "Button.font", dialogPlain12, "Button.background", control, "Button.foreground", controlText, "Button.border", buttonBorder, "Button.margin", zeroInsets, "Button.background", control, "Button.foreground", controlText, "Button.border", buttonBorder, "Button.margin", zeroInsets, "ColorChooser.font", dialogPlain11, "ColorChooser.defaultChoosers", new String[]{"org.jhotdraw.gui.plaf.palette.colorchooser.PaletteSwatchesChooser", "org.jhotdraw.gui.plaf.palette.colorchooser.PaletteColorWheelChooser", "org.jhotdraw.gui.plaf.palette.colorchooser.PaletteColorSlidersChooser"}, "ColorChooser.textSliderGap", 3, "FormattedTextField.font", fieldPlain12, "FormattedTextField.background", control, "FormattedTextField.foreground", controlText, "FormattedTextField.border", textBorder, "FormattedTextField.margin", zeroInsets, "FormattedTextField.opaque", Boolean.TRUE, "FormattedTextField.errorIndicatorForeground", new ColorUIResource(16665153), "FormattedTextField.selectionBackground", selectionBackground, "FormattedTextField.selectionForeground", selectionForeground, "Label.font", dialogPlain12, "Label.border", new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$EmptyBorderUIResource", new Object[]{0, 0, 0, 0}), "List.focusCellHighlightBorder", focusCellHighlightBorder, "List.cellRenderer", new UIDefaults.ProxyLazyValue("org.jhotdraw.gui.plaf.palette.PaletteListCellRenderer"), "Panel.background", control, "Panel.foreground", controlText, "Panel.opaque", Boolean.TRUE, "Ribbon.border", new UIDefaults.ProxyLazyValue("javax.swing.border.MatteBorder", new Object[]{new Insets(1, 0, 0, 0), new Color(0x777777)}), "ScrollPane.border", new UIDefaults.ProxyLazyValue("javax.swing.border.MatteBorder", new Object[]{new Insets(1, 1, 1, 1), new Color(0xA5A5A5)}), "Slider.background", control, "Slider.foreground", controlText, "Slider.horizontalSize", new DimensionUIResource(100, 20), "Slider.verticalSize", new DimensionUIResource(20, 100), "Slider.northThumb.small", new UIDefaults.ProxyLazyValue("org.jhotdraw.gui.plaf.palette.PaletteSliderThumbIcon", new Object[]{"/org/jhotdraw/gui/plaf/palette/images/Slider.northThumbs.small.png", 6, true}), "Slider.westThumb.small", new UIDefaults.ProxyLazyValue("org.jhotdraw.gui.plaf.palette.PaletteSliderThumbIcon", new Object[]{"/org/jhotdraw/gui/plaf/palette/images/Slider.westThumbs.small.png", 6, true}), "TabbedPane.font", dialogPlain12, "TabbedPane.selectedFont", dialogBold12, "TabbedPane.background", control, "TabbedPane.contentAreaColor", control, "TabbedPane.foreground", controlText, "TabbedPane.highlight", new ColorUIResource(0xA5A5A5), "TabbedPane.lightHighlight", new ColorUIResource(0xA5A5A5), "TabbedPane.shadow", new ColorUIResource(0xA5A5A5), "TabbedPane.darkShadow", new ColorUIResource(0x333333), "TextArea.selectionBackground", selectionBackground, "TextArea.selectionForeground", selectionForeground, "TextField.font", fieldPlain12, "TextField.background", control, "TextField.foreground", controlText, "TextField.border", textBorder, "TextField.margin", zeroInsets, "TextField.opaque", Boolean.TRUE, "TextField.selectionBackground", selectionBackground, "TextField.selectionForeground", selectionForeground, "ToolBar.font", dialogPlain12, "ToolBar.background", control, "ToolBar.foreground", controlText, "ToolBar.dockingBackground", control, "ToolBar.floatingBackground", control, "ToolBar.border", new UIDefaults.ProxyLazyValue("org.jhotdraw.gui.plaf.palette.PaletteToolBarBorder$UIResource")};
        table.putDefaults(defaults);
    }

    @Nullable
    static Object getUIOfType(ComponentUI ui, Class klass) {
        if (klass.isInstance(ui)) {
            return ui;
        }
        return null;
    }
}

