/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.undo;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public class UndoRedoManager
extends UndoManager {
    protected PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private static final boolean DEBUG = false;
    private static ResourceBundleUtil labels;
    private boolean hasSignificantEdits = false;
    private boolean undoOrRedoInProgress;
    public static final UndoableEdit DISCARD_ALL_EDITS;
    private UndoAction undoAction;
    private RedoAction redoAction;

    public static ResourceBundleUtil getLabels() {
        if (labels == null) {
            labels = ResourceBundleUtil.getBundle("org.jhotdraw.undo.Labels");
        }
        return labels;
    }

    public UndoRedoManager() {
        UndoRedoManager.getLabels();
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
    }

    public void setLocale(Locale l) {
        labels = ResourceBundleUtil.getBundle("org.jhotdraw.undo.Labels", l);
    }

    @Override
    public void discardAllEdits() {
        super.discardAllEdits();
        this.updateActions();
        this.setHasSignificantEdits(false);
    }

    public void setHasSignificantEdits(boolean newValue) {
        boolean oldValue = this.hasSignificantEdits;
        this.hasSignificantEdits = newValue;
        this.firePropertyChange("hasSignificantEdits", oldValue, newValue);
    }

    public boolean hasSignificantEdits() {
        return this.hasSignificantEdits;
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        if (this.undoOrRedoInProgress) {
            anEdit.die();
            return true;
        }
        boolean success = super.addEdit(anEdit);
        this.updateActions();
        if (success && anEdit.isSignificant() && this.editToBeUndone() == anEdit) {
            this.setHasSignificantEdits(true);
        }
        return success;
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    private void updateActions() {
        String label;
        if (this.canUndo()) {
            this.undoAction.setEnabled(true);
            label = this.getUndoPresentationName();
        } else {
            this.undoAction.setEnabled(false);
            label = labels.getString("edit.undo.text");
        }
        this.undoAction.putValue("Name", label);
        this.undoAction.putValue("ShortDescription", label);
        if (this.canRedo()) {
            this.redoAction.setEnabled(true);
            label = this.getRedoPresentationName();
        } else {
            this.redoAction.setEnabled(false);
            label = labels.getString("edit.redo.text");
        }
        this.redoAction.putValue("Name", label);
        this.redoAction.putValue("ShortDescription", label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undo() throws CannotUndoException {
        this.undoOrRedoInProgress = true;
        try {
            super.undo();
        }
        finally {
            this.undoOrRedoInProgress = false;
            this.updateActions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redo() throws CannotUndoException {
        this.undoOrRedoInProgress = true;
        try {
            super.redo();
        }
        finally {
            this.undoOrRedoInProgress = false;
            this.updateActions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undoOrRedo() throws CannotUndoException, CannotRedoException {
        this.undoOrRedoInProgress = true;
        try {
            super.undoOrRedo();
        }
        finally {
            this.undoOrRedoInProgress = false;
            this.updateActions();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    static {
        DISCARD_ALL_EDITS = new AbstractUndoableEdit(){

            @Override
            public boolean canUndo() {
                return false;
            }

            @Override
            public boolean canRedo() {
                return false;
            }
        };
    }

    private class RedoAction
    extends AbstractAction {
        public RedoAction() {
            labels.configureAction(this, "edit.redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                UndoRedoManager.this.redo();
            }
            catch (CannotRedoException e) {
                System.out.println("Cannot redo: " + e);
            }
        }
    }

    private class UndoAction
    extends AbstractAction {
        public UndoAction() {
            labels.configureAction(this, "edit.undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                UndoRedoManager.this.undo();
            }
            catch (CannotUndoException e) {
                System.err.println("Cannot undo: " + e);
                e.printStackTrace();
            }
        }
    }
}

