/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.overlay;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import net.imagej.Dataset;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.display.ImageDisplay;
import net.imagej.overlay.ThresholdOverlay;
import net.imglib2.Cursor;
import net.imglib2.ops.pointset.HyperVolumePointSet;
import net.imglib2.ops.pointset.PointSet;
import org.jhotdraw.draw.AbstractAttributedFigure;
import org.jhotdraw.draw.AttributeKeys;
import org.scijava.display.Displayable;
import org.scijava.ui.awt.AWTColors;
import org.scijava.util.ColorRGB;

public class ThresholdFigure
extends AbstractAttributedFigure
implements Displayable {
    private static final long serialVersionUID = 1L;
    private final ImageDisplay display;
    private final Dataset dataset;
    private final ThresholdOverlay overlay;
    private final Rectangle2D.Double rect;
    private double[] tmpPos;

    public ThresholdFigure(ImageDisplay display, Dataset dataset, ThresholdOverlay overlay) {
        this.display = display;
        this.dataset = dataset;
        this.overlay = overlay;
        this.rect = new Rectangle2D.Double();
        this.setAttributeEnabled(AttributeKeys.FILL_COLOR, true);
        this.setAttributeEnabled(AttributeKeys.STROKE_COLOR, false);
        this.setAttributeEnabled(AttributeKeys.TEXT_COLOR, false);
        this.set(AttributeKeys.FILL_COLOR, Color.DARK_GRAY);
        overlay.setFigure((Displayable)this);
    }

    public boolean contains(Point2D.Double pt) {
        int d = this.dataset.numDimensions();
        if (this.tmpPos == null || this.tmpPos.length != d) {
            this.tmpPos = new double[d];
        }
        this.tmpPos[0] = pt.x;
        this.tmpPos[1] = pt.y;
        for (int i = 2; i < this.tmpPos.length; ++i) {
            AxisType axisType = ((CalibratedAxis)this.dataset.axis(i)).type();
            this.tmpPos[i] = this.display.getLongPosition(axisType);
        }
        return this.overlay.getRegionOfInterest().contains(this.tmpPos);
    }

    public Rectangle2D.Double getBounds() {
        return new Rectangle2D.Double(0.0, 0.0, this.dataset.max(0), this.dataset.max(1));
    }

    public Object getTransformRestoreData() {
        return new Object();
    }

    public void restoreTransformTo(Object arg0) {
    }

    public void transform(AffineTransform arg0) {
    }

    protected void drawStroke(Graphics2D arg0) {
    }

    public Point2D.Double getStartPoint() {
        return new Point2D.Double(this.dataset.min(0), this.dataset.min(1));
    }

    public Point2D.Double getEndPoint() {
        return new Point2D.Double(this.dataset.max(0), this.dataset.max(1));
    }

    public Rectangle2D.Double getDrawingArea() {
        return new Rectangle2D.Double(0.0, 0.0, this.dataset.max(0), this.dataset.max(1));
    }

    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
    }

    protected void drawFill(Graphics2D g) {
        Color origC = g.getColor();
        Color withinColor = AWTColors.getColor((ColorRGB)this.overlay.getColorWithin());
        Color lessColor = AWTColors.getColor((ColorRGB)this.overlay.getColorLess());
        Color greaterColor = AWTColors.getColor((ColorRGB)this.overlay.getColorGreater());
        Color color = null;
        Color lastColor = null;
        this.rect.width = 1.0;
        this.rect.height = 1.0;
        Cursor cursor = this.getViewedPlane().cursor();
        while (cursor.hasNext()) {
            long[] pos = (long[])cursor.next();
            int classification = this.overlay.classify(pos);
            color = classification == Integer.MAX_VALUE ? null : (classification < 0 ? lessColor : (classification > 0 ? greaterColor : withinColor));
            if (color == null) continue;
            if (color != lastColor) {
                g.setColor(color);
                lastColor = color;
            }
            this.rect.x = pos[0];
            this.rect.y = pos[1];
            g.fill(this.rect);
        }
        g.setColor(origC);
    }

    public void draw() {
        this.fireAreaInvalidated();
    }

    private PointSet getViewedPlane() {
        long[] pt1 = new long[this.dataset.numDimensions()];
        long[] pt2 = (long[])pt1.clone();
        pt2[0] = this.dataset.dimension(0) - 1L;
        pt2[1] = this.dataset.dimension(1) - 1L;
        for (int i = 2; i < pt1.length; ++i) {
            AxisType axisType = ((CalibratedAxis)this.dataset.axis(i)).type();
            pt1[i] = pt2[i] = this.display.getLongPosition(axisType);
        }
        return new HyperVolumePointSet(pt1, pt2);
    }
}

