/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import net.imagej.updater.util.AbstractProgressable;
import net.imagej.updater.util.Downloadable;
import net.imagej.updater.util.Progress;
import net.imagej.updater.util.UpdaterUtil;

public class Downloader
extends AbstractProgressable {
    protected int count;
    protected int total;
    protected int itemCount;
    protected int itemTotal;
    protected long lastModified;
    protected String error;
    protected boolean cancelled;

    @Deprecated
    public Downloader() {
        this(null);
    }

    public Downloader(Progress progress) {
        if (progress != null) {
            this.addProgress(progress);
        }
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }

    public synchronized void start(Downloadable justOne) throws IOException {
        this.start(Collections.singleton(justOne));
    }

    public void start(Iterable<Downloadable> files) throws IOException {
        UpdaterUtil.useSystemProxies();
        this.cancelled = false;
        this.itemTotal = 0;
        this.itemCount = 0;
        this.total = 0;
        this.count = 0;
        for (Downloadable file : files) {
            this.total = (int)((long)this.total + file.getFilesize());
            ++this.itemTotal;
        }
        this.setTitle("Downloading...");
        for (Downloadable current : files) {
            if (this.cancelled) break;
            this.download(current);
        }
        this.done();
    }

    protected synchronized void download(Downloadable current) throws IOException {
        int count;
        URLConnection connection = UpdaterUtil.openConnection(new URL(current.getURL()));
        connection.setUseCaches(false);
        this.lastModified = connection.getLastModified();
        int currentTotal = connection.getContentLength();
        if (currentTotal < 0) {
            currentTotal = (int)current.getFilesize();
        }
        File destination = current.getDestination();
        this.addItem(current);
        File parentDirectory = destination.getParentFile();
        if (parentDirectory != null) {
            parentDirectory.mkdirs();
        }
        InputStream in = connection.getInputStream();
        FileOutputStream out = new FileOutputStream(destination);
        int currentCount = 0;
        int total = this.total;
        if (total == 0) {
            total = (this.count + currentTotal) * this.itemTotal / (this.itemCount + 1);
        }
        byte[] buffer = new byte[65536];
        while (!this.cancelled && (count = in.read(buffer)) >= 0) {
            ((OutputStream)out).write(buffer, 0, count);
            this.count += count;
            this.setCount(this.count, total);
            this.setItemCount(currentCount += count, currentTotal);
        }
        in.close();
        ((OutputStream)out).close();
        this.itemDone(current);
    }

    public long getLastModified() {
        return this.lastModified;
    }
}

