/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Platforms {
    private static final Map<String, String> LAUNCHERS = new HashMap<String, String>();
    private static final List<String> PLATFORMS;

    private Platforms() {
    }

    public static List<String> known() {
        return Collections.unmodifiableList(PLATFORMS);
    }

    public static Collection<String> launchers() {
        return Collections.unmodifiableSet(LAUNCHERS.keySet());
    }

    public static String platformForLauncher(String filename) {
        int slash = filename.indexOf("/");
        if (slash >= 0 && filename.substring(0, slash).endsWith(".app")) {
            return "macosx";
        }
        return LAUNCHERS.get(filename);
    }

    public static boolean matches(String platform, String candidate) {
        return platform.equals(candidate) || "linuxx".equals(candidate) && Platforms.isLinux(platform) || "macosx".equals(candidate) && Platforms.isMac(platform) || "winx".equals(candidate) && Platforms.isWindows(platform);
    }

    public static boolean matches(String platform, Collection<String> candidates) {
        if (candidates.isEmpty()) {
            return true;
        }
        return candidates.stream().anyMatch(c -> Platforms.matches(platform, c));
    }

    public static boolean matches(Collection<String> platforms, String candidate) {
        return platforms.stream().anyMatch(p -> Platforms.matches(p, candidate));
    }

    public static boolean isWindows(String platform) {
        return platform.startsWith("win");
    }

    public static boolean isMac(String platform) {
        return platform.startsWith("macos");
    }

    public static boolean isLinux(String platform) {
        return platform.startsWith("linux");
    }

    public static String current() {
        String osName = System.getProperty("os.name").toLowerCase().replaceAll("[^a-z0-9_-]", "");
        String osArch = System.getProperty("os.arch");
        String os = osName.startsWith("linux") ? "linux" : (osName.startsWith("mac") ? "macos" : (osName.startsWith("win") ? "win" : osName));
        HashMap<String, String> archMap = new HashMap<String, String>();
        archMap.put("aarch32", "-arm32");
        archMap.put("aarch64", "-arm64");
        archMap.put("i386", "32");
        archMap.put("i486", "32");
        archMap.put("i586", "32");
        archMap.put("i686", "32");
        archMap.put("x86", "32");
        archMap.put("x86-32", "32");
        archMap.put("x86_32", "32");
        archMap.put("amd64", "64");
        archMap.put("x64", "64");
        archMap.put("x86-64", "64");
        archMap.put("x86_64", "64");
        String arch = archMap.getOrDefault(osArch, "-" + osArch);
        return os + arch;
    }

    public static boolean isLauncher(String filename) {
        int slash = filename.indexOf("/");
        if (slash >= 0 && filename.substring(0, slash).endsWith(".app")) {
            return true;
        }
        return LAUNCHERS.containsKey(filename);
    }

    public static Set<String> inferActive(File appRoot) {
        String[] specialDirs;
        HashSet<String> activePlatforms = new HashSet<String>();
        activePlatforms.add(Platforms.current());
        if (appRoot == null) {
            return activePlatforms;
        }
        for (Map.Entry<String, String> lap : LAUNCHERS.entrySet()) {
            String launcher = lap.getKey();
            String platform = lap.getValue();
            File launcherFile = new File(appRoot, launcher);
            if (!launcherFile.exists()) continue;
            activePlatforms.add(platform);
        }
        for (String specialDir : specialDirs = new String[]{"jars", "lib"}) {
            for (String platform : Platforms.known()) {
                File dir = appRoot.toPath().resolve(specialDir).resolve(platform).toFile();
                if (!dir.isDirectory()) continue;
                activePlatforms.add(platform);
            }
        }
        return activePlatforms;
    }

    static {
        LAUNCHERS.put("fiji-linux-arm64", "linux-arm64");
        LAUNCHERS.put("fiji-linux-x64", "linux64");
        LAUNCHERS.put("fiji-windows-arm64.exe", "win-arm64");
        LAUNCHERS.put("fiji-windows-x64.exe", "win64");
        LAUNCHERS.put("config/jaunch/jaunch-linux-arm64", "linux-arm64");
        LAUNCHERS.put("config/jaunch/jaunch-linux-x64", "linux64");
        LAUNCHERS.put("config/jaunch/jaunch-windows-arm64.exe", "win-arm64");
        LAUNCHERS.put("config/jaunch/jaunch-windows-x64.exe", "win64");
        LAUNCHERS.put("ImageJ-linux32", "linux32");
        LAUNCHERS.put("ImageJ-linux64", "linux64");
        LAUNCHERS.put("Contents/MacOS/ImageJ-macosx", "macosx");
        LAUNCHERS.put("Contents/MacOS/ImageJ-tiger", "macosx");
        LAUNCHERS.put("ImageJ-win32.exe", "win32");
        LAUNCHERS.put("ImageJ-win64.exe", "win64");
        HashSet<String> platformSet = new HashSet<String>(LAUNCHERS.values());
        platformSet.add("macos64");
        platformSet.add("macos-arm64");
        PLATFORMS = new ArrayList<String>(platformSet);
        Collections.sort(PLATFORMS);
    }
}

