/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.hdf5;

import ij.ImagePlus;
import ij.Prefs;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import sc.fiji.hdf5.HDF5ImageJ;
import sc.fiji.hdf5.StackToHDF5GroupsMapping;

public class HDF5_Writer_Vibez
extends Frame
implements PlugInFilter,
ActionListener {
    String _filename;
    String _saveMode;
    ImagePlus _imp;
    BoxLayout _mylayout;
    JComboBox _compressionSelect;
    JComboBox _presetSelect;
    JTextField _dsetNameTempl;
    JTextArea _textAreaT;
    JTextArea _textAreaC;
    JLabel _dsetNamesPreview;
    ArrayList<StackToHDF5GroupsMapping> _mappingPresets = new ArrayList();

    public HDF5_Writer_Vibez() {
        super("Save to HDF5");
        this._mappingPresets.add(new StackToHDF5GroupsMapping(",/t{t}/channel{c},%d,%d"));
        this._mappingPresets.add(new StackToHDF5GroupsMapping("Standard,/t{t}/channel{c},%d,%d"));
        this._mappingPresets.add(new StackToHDF5GroupsMapping("Standard (no time),/channel{c},%d,%d"));
        this._mappingPresets.add(new StackToHDF5GroupsMapping("LSM --> ViBE-Z step0 dorsal,/step0/raw/dorsal/tile{t}/{c},%d,laserset0/channel1 laserset1/channel1 laserset0/channel0 laserset1/channel0"));
        this._mappingPresets.add(new StackToHDF5GroupsMapping("LSM --> ViBE-Z step0 ventral,/step0/raw/ventral/tile{t}/{c},%d,laserset0/channel1 laserset1/channel1 laserset0/channel0 laserset1/channel0"));
        this._mappingPresets.add(new StackToHDF5GroupsMapping("Zen --> ViBE-Z step0 dorsal tile 0,/step0/raw/dorsal/tile{t}/{c},0,laserset0/channel0 laserset1/channel0 laserset0/channel1 laserset1/channel1"));
        this._mappingPresets.add(new StackToHDF5GroupsMapping("Zen --> ViBE-Z step0 dorsal tile 1,/step0/raw/dorsal/tile{t}/{c},1,laserset0/channel0 laserset1/channel0 laserset0/channel1 laserset1/channel1"));
        this._mappingPresets.add(new StackToHDF5GroupsMapping("Zen --> ViBE-Z step0 ventral tile 0,/step0/raw/ventral/tile{t}/{c},0,laserset0/channel0 laserset1/channel0 laserset0/channel1 laserset1/channel1"));
        this._mappingPresets.add(new StackToHDF5GroupsMapping("Zen --> ViBE-Z step0 ventral tile 1,/step0/raw/ventral/tile{t}/{c},1,laserset0/channel0 laserset1/channel0 laserset0/channel1 laserset1/channel1"));
    }

    public int setup(String arg, ImagePlus imp) {
        this._saveMode = arg;
        this._imp = imp;
        return 159;
    }

    public void run(ImageProcessor ip) {
        String name;
        String directory;
        OpenDialog sd;
        String hint = "";
        if (this._saveMode.equals("append")) {
            sd = new OpenDialog("Save to HDF5 (append) ...", OpenDialog.getLastDirectory(), "");
            directory = sd.getDirectory();
            name = sd.getFileName();
            if (name == null) {
                return;
            }
            if (name == "") {
                return;
            }
            this._filename = directory + name;
            if (new File(this._filename).exists()) {
                this.setTitle("Append to Existing HDF5 File '" + name + "'");
                hint = "<font color='red'>(Append to existing HDF File '" + name + "')</font>";
            } else {
                this.setTitle("Save to New HDF5 File '" + name + "'");
            }
        } else {
            sd = new SaveDialog("Save to HDF5 (new or replace)...", OpenDialog.getLastDirectory(), ".h5");
            directory = sd.getDirectory();
            name = sd.getFileName();
            if (name == null) {
                return;
            }
            if (name == "") {
                return;
            }
            this._filename = directory + name;
            this.setTitle("Save to New HDF5 File '" + name + "'");
        }
        int nFrames = this._imp.getNFrames();
        int nChannels = this._imp.getNChannels();
        this.setLayout(new GridBagLayout());
        GridBagConstraints cs = new GridBagConstraints();
        int currentRow = 0;
        cs.anchor = 23;
        cs.fill = 2;
        cs.weightx = 0.0;
        cs.weighty = 0.0;
        cs.gridx = 0;
        cs.gridy = currentRow++;
        cs.insets = new Insets(3, 3, 0, 0);
        cs.gridwidth = 3;
        this.add((Component)new JLabel("<html>" + hint + "<h2>Select Compression (Lossless gzip algorithm)</h2></html>"), cs);
        String[] compressionLevels = new String[]{"no compression", "1 (fastest, larger file)", "2", "3", "4", "5", "6", "7", "8", "9 (slowest, smallest file)"};
        this._compressionSelect = new JComboBox<String>(compressionLevels);
        int compressionLevel = (int)Prefs.get((String)"hdf5writervibez.compressionlevel", (double)0.0);
        this._compressionSelect.setSelectedIndex(compressionLevel);
        JLabel compressionLabel = new JLabel("Compression Level: ");
        cs.fill = 0;
        cs.gridx = 0;
        cs.gridy = currentRow;
        cs.gridwidth = 1;
        this.add((Component)compressionLabel, cs);
        cs.fill = 0;
        cs.gridx = 1;
        cs.gridy = currentRow++;
        cs.gridwidth = 2;
        this.add((Component)this._compressionSelect, cs);
        cs.fill = 2;
        cs.weightx = 0.0;
        cs.weighty = 0.0;
        cs.gridx = 0;
        cs.gridy = currentRow;
        cs.insets = new Insets(3, 3, 0, 0);
        cs.gridwidth = 3;
        this.add((Component)new JLabel("<html><h2>Specify the dataset names for each 3D stack in the HDF5 file</h2></html>"), cs);
        this._presetSelect = new JComboBox();
        for (int i = 0; i < this._mappingPresets.size(); ++i) {
            this._presetSelect.addItem(this._mappingPresets.get((int)i).uniqueName_);
        }
        this._presetSelect.setSelectedIndex(0);
        this._presetSelect.setActionCommand("set_preset");
        this._presetSelect.addActionListener(this);
        JLabel presetLabel = new JLabel("Presets: ");
        cs.fill = 0;
        cs.gridx = 0;
        cs.gridy = ++currentRow;
        cs.gridwidth = 1;
        this.add((Component)presetLabel, cs);
        cs.fill = 0;
        cs.gridx = 1;
        cs.gridy = currentRow++;
        cs.gridwidth = 2;
        this.add((Component)this._presetSelect, cs);
        this._dsetNameTempl = new JTextField(Prefs.get((String)"hdf5writervibez.nametemplate", (String)"/t{t}/channel{c}"));
        this._dsetNameTempl.setActionCommand("update_preview");
        this._dsetNameTempl.addActionListener(this);
        JLabel textFieldLabel = new JLabel("Dataset Names Template: ");
        cs.gridx = 0;
        cs.gridy = currentRow;
        cs.gridwidth = 1;
        this.add((Component)textFieldLabel, cs);
        cs.fill = 2;
        cs.gridx = 1;
        cs.gridy = currentRow++;
        cs.gridwidth = 2;
        this.add((Component)this._dsetNameTempl, cs);
        cs.fill = 0;
        cs.gridx = 1;
        cs.gridy = currentRow;
        cs.gridwidth = 1;
        this.add((Component)new JLabel("Replace {t} with: (Your data has " + nFrames + " time points)"), cs);
        cs.gridx = 2;
        cs.gridy = currentRow++;
        cs.gridwidth = 1;
        this.add((Component)new JLabel("Replace {c} with: (Your data has " + nChannels + " channels)"), cs);
        this._textAreaT = new JTextArea(Prefs.get((String)"hdf5writervibez.timeformat", (String)"%d"));
        JScrollPane scrollPaneT = new JScrollPane(this._textAreaT);
        scrollPaneT.setMinimumSize(new Dimension(1, 100));
        cs.weightx = 1.0;
        cs.weighty = 1.0;
        cs.gridx = 1;
        cs.gridy = currentRow;
        cs.gridwidth = 1;
        cs.fill = 1;
        this.add((Component)scrollPaneT, cs);
        this._textAreaC = new JTextArea(Prefs.get((String)"hdf5writervibez.channelformat", (String)"%d"));
        JScrollPane scrollPaneC = new JScrollPane(this._textAreaC);
        scrollPaneC.setMinimumSize(new Dimension(1, 100));
        cs.gridx = 2;
        cs.gridy = currentRow++;
        cs.gridwidth = 1;
        this.add((Component)scrollPaneC, cs);
        JButton b0 = new JButton("Update Preview");
        b0.setActionCommand("update_preview");
        b0.addActionListener(this);
        cs.weightx = 0.0;
        cs.weighty = 0.0;
        cs.gridx = 1;
        cs.gridy = currentRow++;
        cs.gridwidth = 2;
        cs.fill = 0;
        this.add((Component)b0, cs);
        cs.fill = 0;
        cs.weightx = 0.0;
        cs.weighty = 1.0;
        cs.gridx = 0;
        cs.gridy = currentRow;
        cs.gridwidth = 1;
        this.add((Component)new JLabel("Resulting\nMapping:"), cs);
        this._dsetNamesPreview = new JLabel();
        JScrollPane scrollPanePreview = new JScrollPane(this._dsetNamesPreview);
        scrollPanePreview.setMinimumSize(new Dimension(1, 100));
        cs.gridx = 1;
        cs.gridy = currentRow++;
        cs.gridwidth = 2;
        cs.fill = 1;
        this.add((Component)scrollPanePreview, cs);
        JButton b1 = new JButton("Save");
        b1.setActionCommand("save");
        b1.addActionListener(this);
        cs.weightx = 0.0;
        cs.weighty = 0.0;
        cs.gridx = 1;
        cs.gridy = currentRow;
        cs.gridwidth = 1;
        cs.fill = 0;
        this.add((Component)b1, cs);
        JButton b2 = new JButton("Cancel");
        b2.setActionCommand("cancel");
        b2.addActionListener(this);
        cs.gridx = 2;
        cs.gridy = currentRow;
        cs.gridwidth = 1;
        this.add((Component)b2, cs);
        this.pack();
        Dimension si = this.getSize();
        si.height = 400;
        this.setSize(si);
        this.setVisible(true);
        this.updateMapping();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("set_preset")) {
            this.setPreset(this._presetSelect.getSelectedIndex());
        } else if (event.getActionCommand().equals("update_preview")) {
            this.updateMapping();
        } else if (event.getActionCommand().equals("save")) {
            this.saveHDF5();
        } else if (event.getActionCommand().equals("cancel")) {
            this.dispose();
        }
    }

    public void setPreset(int index) {
        StackToHDF5GroupsMapping m = this._mappingPresets.get(index);
        this._dsetNameTempl.setText(m.formatString_);
        String t1 = m.formatT_.replaceAll("[,\\s]+", "\n");
        String t2 = m.formatC_.replaceAll("[,\\s]+", "\n");
        this._textAreaT.setText(t1);
        this._textAreaC.setText(t2);
        this.updateMapping();
    }

    public void updateMapping() {
        String formatString = this._dsetNameTempl.getText();
        String formatT = this._textAreaT.getText();
        String formatC = this._textAreaC.getText();
        int nFrames = this._imp.getNFrames();
        int nChannels = this._imp.getNChannels();
        String[] substT = HDF5ImageJ.createNameList(formatT, nFrames);
        String[] substC = HDF5ImageJ.createNameList(formatC, nChannels);
        Object dataSetNames = null;
        String preview = new String();
        preview = preview + "<html>";
        for (int t = 0; t < nFrames; ++t) {
            for (int c = 0; c < nChannels; ++c) {
                String dsetName = formatString;
                dsetName = dsetName.replace("{t}", substT[t]);
                dsetName = dsetName.replace("{c}", substC[c]);
                preview = preview + "t:" + t + ",c:" + c + "  &rarr;  " + dsetName + "<br>";
            }
        }
        preview = preview + "</html>";
        this._dsetNamesPreview.setText(preview);
    }

    public void saveHDF5() {
        String dsetNameTemplate = this._dsetNameTempl.getText();
        String formatT = this._textAreaT.getText();
        String formatC = this._textAreaC.getText();
        int compressionLevel = this._compressionSelect.getSelectedIndex();
        Prefs.set((String)"hdf5writervibez.nametemplate", (String)dsetNameTemplate);
        Prefs.set((String)"hdf5writervibez.timeformat", (String)formatT);
        Prefs.set((String)"hdf5writervibez.channelformat", (String)formatC);
        Prefs.set((String)"hdf5writervibez.compressionlevel", (int)compressionLevel);
        HDF5ImageJ.saveHyperStack(this._imp, this._filename, dsetNameTemplate, formatT, formatC, compressionLevel, this._saveMode);
        this.dispose();
    }
}

