/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.integral;

import mpicbg.imglib.algorithm.integral.IntegralImage;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.type.numeric.real.DoubleType;

public class IntegralImageDouble<R extends NumericType<R>>
extends IntegralImage<R, DoubleType> {
    public IntegralImageDouble(Image<R> img, Converter<R, DoubleType> converter) {
        super(img, new DoubleType(), converter);
    }

    @Override
    protected void integrateLineDim0(Converter<R, DoubleType> converter, LocalizableByDimCursor<R> cursorIn, LocalizableByDimCursor<DoubleType> cursorOut, DoubleType sum, DoubleType tmpVar, int size) {
        converter.convert(cursorIn.getType(), sum);
        ((DoubleType)cursorOut.getType()).set(sum);
        double sum2 = sum.get();
        for (int i = 2; i < size; ++i) {
            cursorIn.fwd(0);
            cursorOut.fwd(0);
            converter.convert(cursorIn.getType(), tmpVar);
            ((DoubleType)cursorOut.getType()).set(sum2 += tmpVar.get());
        }
    }

    @Override
    protected void integrateLine(int d, LocalizableByDimCursor<DoubleType> cursor, DoubleType sum, int size) {
        double sum2 = ((DoubleType)cursor.getType()).get();
        for (int i = 2; i < size; ++i) {
            cursor.fwd(d);
            DoubleType type = (DoubleType)cursor.getType();
            type.set(sum2 += type.get());
        }
    }
}

