/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.kdtree;

import mpicbg.imglib.algorithm.kdtree.KDTree;
import mpicbg.imglib.algorithm.kdtree.node.Leaf;
import mpicbg.imglib.algorithm.kdtree.node.Node;
import mpicbg.imglib.algorithm.kdtree.node.NonLeaf;

public class NearestNeighborSearch<T extends Leaf<T>> {
    protected final KDTree<T> kdTree;
    private T bestPointSoFar;

    public NearestNeighborSearch(KDTree<T> kdTree) {
        this.kdTree = kdTree;
    }

    public KDTree<T> getKDTree() {
        return this.kdTree;
    }

    public T findNearestNeighbor(T point) {
        this.bestPointSoFar = null;
        return this.findNearestNeighbor(point, this.kdTree.getRoot(), 0);
    }

    protected T findNearestNeighbor(T point, Node<T> node, int depth) {
        T other;
        if (node.isLeaf()) {
            if (this.bestPointSoFar == null) {
                this.bestPointSoFar = ((Leaf)node).getEntry();
            }
            Object returnNode = ((Leaf)node).getEntry();
            if (point.distanceTo(this.bestPointSoFar) < point.distanceTo(returnNode)) {
                returnNode = this.bestPointSoFar;
            }
            return (T)returnNode;
        }
        int k = depth % this.kdTree.getDimension();
        NonLeaf nonLeaf = (NonLeaf)node;
        if (nonLeaf.right == null) {
            return this.findNearestNeighbor(point, nonLeaf.left, depth + 1);
        }
        if (nonLeaf.left == null) {
            return this.findNearestNeighbor(point, nonLeaf.right, depth + 1);
        }
        float projectedDistance = nonLeaf.coordinate - point.get(k);
        boolean lookRight = projectedDistance < 0.0f;
        T result = this.findNearestNeighbor(point, lookRight ? nonLeaf.right : nonLeaf.left, depth + 1);
        float distance = point.distanceTo(result);
        if (distance > Math.abs(projectedDistance) && point.distanceTo(other = this.findNearestNeighbor(point, lookRight ? nonLeaf.left : nonLeaf.right, depth + 1)) < distance) {
            return other;
        }
        return result;
    }
}

