/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.math;

import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.util.Util;

public class LocalizablePoint
implements Localizable {
    final int[] position;
    final int numDimensions;

    public LocalizablePoint(int[] position) {
        this.position = position;
        this.numDimensions = position.length;
    }

    public LocalizablePoint(float[] position) {
        this(position.length);
        for (int d = 0; d < this.numDimensions; ++d) {
            this.position[d] = Util.round(position[d]);
        }
    }

    public LocalizablePoint(int numDimensions) {
        this.numDimensions = numDimensions;
        this.position = new int[numDimensions];
    }

    @Override
    public void fwd(long steps) {
    }

    @Override
    public void fwd() {
    }

    @Override
    public void getPosition(int[] position) {
        for (int d = 0; d < this.numDimensions; ++d) {
            position[d] = this.position[d];
        }
    }

    @Override
    public int[] getPosition() {
        return this.position;
    }

    @Override
    public int getPosition(int dim) {
        return this.position[dim];
    }

    @Override
    public String getPositionAsString() {
        return Util.printCoordinates(this.position);
    }
}

