/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.planar;

import mpicbg.imglib.container.planar.PlanarContainer;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.planar.PlanarLocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategy;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

public class PlanarLocalizableByDimOutOfBoundsCursor<T extends Type<T>>
extends PlanarLocalizableByDimCursor<T>
implements LocalizableByDimCursor<T> {
    final OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory;
    final OutOfBoundsStrategy<T> outOfBoundsStrategy;
    boolean isOutOfBounds = false;

    public PlanarLocalizableByDimOutOfBoundsCursor(PlanarContainer<T, ?> container, Image<T> image, T type, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super(container, image, type);
        this.outOfBoundsStrategyFactory = outOfBoundsStrategyFactory;
        this.outOfBoundsStrategy = outOfBoundsStrategyFactory.createStrategy(this);
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return !this.isOutOfBounds && (this.type.getIndex() < this.lastIndex || this.sliceIndex < this.lastSliceIndex);
    }

    @Override
    public T getType() {
        if (this.isOutOfBounds) {
            return this.outOfBoundsStrategy.getType();
        }
        return (T)this.type;
    }

    @Override
    public void reset() {
        if (this.outOfBoundsStrategy == null) {
            return;
        }
        this.isClosed = false;
        this.isOutOfBounds = false;
        this.type.updateIndex(-1);
        this.position[0] = -1;
        this.sliceIndex = 0;
        for (int d = 1; d < this.numDimensions; ++d) {
            this.position[d] = 0;
        }
        this.type.updateContainer(this);
    }

    @Override
    public void fwd() {
        if (!this.isOutOfBounds) {
            int d;
            this.type.incIndex();
            if (this.type.getIndex() > this.lastIndex) {
                ++this.sliceIndex;
                this.type.updateIndex(0);
                this.type.updateContainer(this);
            }
            for (d = 0; d < this.numDimensions; ++d) {
                int n = d;
                this.position[n] = this.position[n] + 1;
                if (this.position[n] < this.dimensions[d]) break;
                this.position[d] = 0;
            }
            if (d == this.numDimensions) {
                this.isOutOfBounds = true;
                this.position[0] = this.position[0] + 1;
                this.outOfBoundsStrategy.initOutOfBOunds();
            }
        }
    }

    @Override
    public void fwd(int dim) {
        int n = dim;
        this.position[n] = this.position[n] + 1;
        if (this.isOutOfBounds) {
            if (this.position[dim] == 0) {
                this.setPosition(this.position);
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOundsFwd(dim);
            }
        } else if (this.position[dim] < this.dimensions[dim]) {
            if (dim > 1) {
                this.sliceIndex += this.sliceSteps[dim];
                this.type.updateContainer(this);
            } else {
                this.type.incIndex(this.step[dim]);
            }
        } else {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void move(int steps, int dim) {
        int n = dim;
        this.position[n] = this.position[n] + steps;
        if (this.isOutOfBounds) {
            if (this.position[dim] >= 0 && this.position[dim] < this.dimensions[dim]) {
                int d;
                this.isOutOfBounds = false;
                for (d = 0; d < this.numDimensions && !this.isOutOfBounds; ++d) {
                    this.isOutOfBounds = this.position[d] < 0 || this.position[d] >= this.dimensions[d];
                }
                if (!this.isOutOfBounds) {
                    this.type.updateIndex(this.container.getIndex(this.position));
                    this.sliceIndex = 0;
                    for (d = 2; d < this.numDimensions; ++d) {
                        this.sliceIndex += this.position[d] * this.sliceSteps[d];
                    }
                    this.type.updateContainer(this);
                } else {
                    this.outOfBoundsStrategy.notifyOutOfBOunds(steps, dim);
                }
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOunds(steps, dim);
            }
        } else if (this.position[dim] >= 0 && this.position[dim] < this.dimensions[dim]) {
            if (dim > 1) {
                this.sliceIndex += steps * this.sliceSteps[dim];
                this.type.updateContainer(this);
            } else {
                this.type.incIndex(this.step[dim] * steps);
            }
        } else {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void bck(int dim) {
        int n = dim;
        this.position[n] = this.position[n] - 1;
        if (this.isOutOfBounds) {
            if (this.position[dim] == this.dimensions[dim] - 1) {
                this.setPosition(this.position);
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOundsBck(dim);
            }
        } else if (this.position[dim] > -1) {
            if (dim > 1) {
                this.sliceIndex -= this.sliceSteps[dim];
                this.type.updateContainer(this);
            } else {
                this.type.decIndex(this.step[dim]);
            }
        } else {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void setPosition(int[] position) {
        int d;
        boolean wasOutOfBounds = this.isOutOfBounds;
        this.isOutOfBounds = false;
        for (d = 0; d < this.numDimensions; ++d) {
            this.position[d] = position[d];
            if (position[d] >= 0 && position[d] < this.dimensions[d]) continue;
            this.isOutOfBounds = true;
        }
        if (this.isOutOfBounds) {
            if (wasOutOfBounds) {
                this.outOfBoundsStrategy.notifyOutOfBOunds();
            } else {
                this.outOfBoundsStrategy.initOutOfBOunds();
            }
        } else {
            this.type.updateIndex(this.container.getIndex(position));
            this.sliceIndex = 0;
            for (d = 2; d < this.numDimensions; ++d) {
                this.sliceIndex += position[d] * this.sliceSteps[d];
            }
            this.type.updateContainer(this);
        }
    }

    @Override
    public void setPosition(int position, int dim) {
        this.position[dim] = position;
        if (this.isOutOfBounds || this.type.getIndex() == -1) {
            this.setPosition(this.position);
        } else {
            if (position < 0 || position >= this.dimensions[dim]) {
                this.isOutOfBounds = true;
                this.outOfBoundsStrategy.initOutOfBOunds();
                return;
            }
            if (dim > 1) {
                this.sliceIndex = position * this.sliceSteps[dim];
                this.type.updateContainer(this);
            } else {
                this.type.updateIndex(this.container.getIndex(this.position));
            }
        }
    }
}

