/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.interpolation.linear;

import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.InterpolatorImpl;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.util.Util;

public class LinearInterpolator<T extends NumericType<T>>
extends InterpolatorImpl<T> {
    final LocalizableByDimCursor<T> cursor;
    final T tmp1;
    final T tmp2;
    final int[] baseDim;
    final int[] location;
    final float[][] weights;
    final T[][] tree;
    final int[] halfTreeLevelSizes;
    final boolean[][] positions;

    protected LinearInterpolator(Image<T> img, InterpolatorFactory<T> interpolatorFactory, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        this(img, interpolatorFactory, outOfBoundsStrategyFactory, true);
    }

    protected LinearInterpolator(Image<T> img, InterpolatorFactory<T> interpolatorFactory, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory, boolean initGenericStructures) {
        super(img, interpolatorFactory, outOfBoundsStrategyFactory);
        this.cursor = img.createLocalizableByDimCursor(outOfBoundsStrategyFactory);
        this.tmp1 = (NumericType)img.createType();
        this.tmp2 = (NumericType)img.createType();
        this.baseDim = new int[this.numDimensions];
        this.location = new int[this.numDimensions];
        this.weights = new float[this.numDimensions][2];
        if (initGenericStructures) {
            this.tree = (NumericType[][])this.tmp1.createArray2D(this.numDimensions + 1, 1);
            this.halfTreeLevelSizes = new int[this.numDimensions + 1];
            for (int d = 0; d < this.tree.length; ++d) {
                this.tree[d] = (NumericType[])this.tmp1.createArray1D(Util.pow(2, d));
                for (int i = 0; i < this.tree[d].length; ++i) {
                    this.tree[d][i] = (NumericType)img.createType();
                }
                this.halfTreeLevelSizes[d] = this.tree[d].length / 2;
            }
            this.positions = new boolean[Util.pow(2, this.numDimensions)][this.numDimensions];
            Util.setCoordinateRecursive(this.numDimensions - 1, this.numDimensions, new int[this.numDimensions], this.positions);
            this.moveTo(this.position);
        } else {
            this.tree = null;
            this.positions = null;
            this.halfTreeLevelSizes = null;
        }
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    public T getType() {
        return this.tree[0][0];
    }

    @Override
    public void moveTo(float[] pos) {
        int d;
        for (d = 0; d < this.numDimensions; ++d) {
            this.position[d] = pos[d];
            this.baseDim[d] = pos[d] > 0.0f ? (int)pos[d] : (int)pos[d] - 1;
            this.cursor.move(this.baseDim[d] - this.cursor.getPosition(d), d);
        }
        for (d = 0; d < this.numDimensions; ++d) {
            float w;
            this.weights[d][1] = w = pos[d] - (float)this.baseDim[d];
            this.weights[d][0] = 1.0f - w;
        }
        for (int i = 0; i < this.positions.length; ++i) {
            int d2;
            for (d2 = 0; d2 < this.numDimensions; ++d2) {
                if (!this.positions[i][d2]) continue;
                this.cursor.fwd(d2);
            }
            this.tree[this.numDimensions][i].set(this.cursor.getType());
            for (d2 = 0; d2 < this.numDimensions; ++d2) {
                if (!this.positions[i][d2]) continue;
                this.cursor.bck(d2);
            }
        }
        for (d = this.numDimensions; d > 0; --d) {
            for (int i = 0; i < this.halfTreeLevelSizes[d]; ++i) {
                this.tmp1.set(this.tree[d][i * 2]);
                this.tmp2.set(this.tree[d][i * 2 + 1]);
                this.tmp1.mul(this.weights[this.numDimensions - d][0]);
                this.tmp2.mul(this.weights[this.numDimensions - d][1]);
                this.tmp1.add(this.tmp2);
                this.tree[d - 1][i].set(this.tmp1);
            }
        }
    }

    @Override
    public void moveTo(double[] pos) {
        int d;
        for (d = 0; d < this.numDimensions; ++d) {
            this.position[d] = (float)pos[d];
            this.baseDim[d] = pos[d] > 0.0 ? (int)pos[d] : (int)pos[d] - 1;
            this.cursor.move(this.baseDim[d] - this.cursor.getPosition(d), d);
        }
        for (d = 0; d < this.numDimensions; ++d) {
            float w;
            this.weights[d][1] = w = this.position[d] - (float)this.baseDim[d];
            this.weights[d][0] = 1.0f - w;
        }
        for (int i = 0; i < this.positions.length; ++i) {
            int d2;
            for (d2 = 0; d2 < this.numDimensions; ++d2) {
                if (!this.positions[i][d2]) continue;
                this.cursor.fwd(d2);
            }
            this.tree[this.numDimensions][i].set(this.cursor.getType());
            for (d2 = 0; d2 < this.numDimensions; ++d2) {
                if (!this.positions[i][d2]) continue;
                this.cursor.bck(d2);
            }
        }
        for (d = this.numDimensions; d > 0; --d) {
            for (int i = 0; i < this.halfTreeLevelSizes[d]; ++i) {
                this.tmp1.set(this.tree[d][i * 2]);
                this.tmp2.set(this.tree[d][i * 2 + 1]);
                this.tmp1.mul(this.weights[this.numDimensions - d][0]);
                this.tmp2.mul(this.weights[this.numDimensions - d][1]);
                this.tmp1.add(this.tmp2);
                this.tree[d - 1][i].set(this.tmp1);
            }
        }
    }

    @Override
    public void setPosition(float[] position) {
        int d;
        for (d = 0; d < this.numDimensions; ++d) {
            this.position[d] = position[d];
            this.baseDim[d] = position[d] > 0.0f ? (int)position[d] : (int)position[d] - 1;
        }
        this.cursor.setPosition(this.baseDim);
        for (d = 0; d < this.numDimensions; ++d) {
            float w;
            this.weights[d][1] = w = position[d] - (float)this.baseDim[d];
            this.weights[d][0] = 1.0f - w;
        }
        for (int i = 0; i < this.positions.length; ++i) {
            int d2;
            for (d2 = 0; d2 < this.numDimensions; ++d2) {
                if (!this.positions[i][d2]) continue;
                this.cursor.fwd(d2);
            }
            this.tree[this.numDimensions][i].set(this.cursor.getType());
            for (d2 = 0; d2 < this.numDimensions; ++d2) {
                if (!this.positions[i][d2]) continue;
                this.cursor.bck(d2);
            }
        }
        for (d = this.numDimensions; d > 0; --d) {
            for (int i = 0; i < this.halfTreeLevelSizes[d]; ++i) {
                this.tmp1.set(this.tree[d][i * 2]);
                this.tmp2.set(this.tree[d][i * 2 + 1]);
                this.tmp1.mul(this.weights[this.numDimensions - d][0]);
                this.tmp2.mul(this.weights[this.numDimensions - d][1]);
                this.tmp1.add(this.tmp2);
                this.tree[d - 1][i].set(this.tmp1);
            }
        }
    }

    @Override
    public void setPosition(double[] position) {
        int d;
        for (d = 0; d < this.numDimensions; ++d) {
            this.position[d] = (float)position[d];
            this.baseDim[d] = position[d] > 0.0 ? (int)position[d] : (int)position[d] - 1;
        }
        this.cursor.setPosition(this.baseDim);
        for (d = 0; d < this.numDimensions; ++d) {
            float w;
            this.weights[d][1] = w = this.position[d] - (float)this.baseDim[d];
            this.weights[d][0] = 1.0f - w;
        }
        for (int i = 0; i < this.positions.length; ++i) {
            int d2;
            for (d2 = 0; d2 < this.numDimensions; ++d2) {
                if (!this.positions[i][d2]) continue;
                this.cursor.fwd(d2);
            }
            this.tree[this.numDimensions][i].set(this.cursor.getType());
            for (d2 = 0; d2 < this.numDimensions; ++d2) {
                if (!this.positions[i][d2]) continue;
                this.cursor.bck(d2);
            }
        }
        for (d = this.numDimensions; d > 0; --d) {
            for (int i = 0; i < this.halfTreeLevelSizes[d]; ++i) {
                this.tmp1.set(this.tree[d][i * 2]);
                this.tmp2.set(this.tree[d][i * 2 + 1]);
                this.tmp1.mul(this.weights[this.numDimensions - d][0]);
                this.tmp2.mul(this.weights[this.numDimensions - d][1]);
                this.tmp1.add(this.tmp2);
                this.tree[d - 1][i].set(this.tmp1);
            }
        }
    }
}

