/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.wrapper;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;
import mpicbg.imglib.container.basictypecontainer.array.BitArray;
import mpicbg.imglib.container.basictypecontainer.array.ByteArray;
import mpicbg.imglib.container.basictypecontainer.array.CharArray;
import mpicbg.imglib.container.basictypecontainer.array.DoubleArray;
import mpicbg.imglib.container.basictypecontainer.array.FloatArray;
import mpicbg.imglib.container.basictypecontainer.array.IntArray;
import mpicbg.imglib.container.basictypecontainer.array.LongArray;
import mpicbg.imglib.container.basictypecontainer.array.ShortArray;
import mpicbg.imglib.container.cell.CellContainer;
import mpicbg.imglib.container.cell.CellContainerFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.wrapper.ExistingByteArrays;
import mpicbg.imglib.wrapper.ExistingCharArrays;
import mpicbg.imglib.wrapper.ExistingDoubleArrays;
import mpicbg.imglib.wrapper.ExistingFloatArrays;
import mpicbg.imglib.wrapper.ExistingIntArrays;
import mpicbg.imglib.wrapper.ExistingLongArrays;
import mpicbg.imglib.wrapper.ExistingShortArrays;

public class PredefinedCellContainerFactory
extends CellContainerFactory {
    ArrayDataAccess<?> existingArrays;

    public PredefinedCellContainerFactory(int cellSize, ArrayDataAccess<?> existingArrays) {
        super(cellSize);
        this.existingArrays = existingArrays;
    }

    public PredefinedCellContainerFactory(int[] cellSize, ArrayDataAccess<?> existingArrays) {
        super(cellSize);
        this.existingArrays = existingArrays;
    }

    public void disableWrapping() {
        this.existingArrays = null;
    }

    @Override
    public <T extends Type<T>> DirectAccessContainer<T, BitArray> createBitInstance(int[] dimensions, int entitiesPerPixel) {
        if (this.existingArrays == null) {
            return super.createBitInstance(dimensions, entitiesPerPixel);
        }
        throw new RuntimeException("Not supported for BitArrays");
    }

    @Override
    public <T extends Type<T>> DirectAccessContainer<T, ByteArray> createByteInstance(int[] dimensions, int entitiesPerPixel) {
        if (this.existingArrays == null) {
            return super.createByteInstance(dimensions, entitiesPerPixel);
        }
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.cellSize, dimensions);
        return new CellContainer(new CellContainerFactory(cellSize), (ExistingByteArrays)this.existingArrays, dimensions, cellSize, entitiesPerPixel);
    }

    @Override
    public <T extends Type<T>> DirectAccessContainer<T, CharArray> createCharInstance(int[] dimensions, int entitiesPerPixel) {
        if (this.existingArrays == null) {
            return super.createCharInstance(dimensions, entitiesPerPixel);
        }
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.cellSize, dimensions);
        return new CellContainer(new CellContainerFactory(cellSize), (ExistingCharArrays)this.existingArrays, dimensions, cellSize, entitiesPerPixel);
    }

    @Override
    public <T extends Type<T>> DirectAccessContainer<T, DoubleArray> createDoubleInstance(int[] dimensions, int entitiesPerPixel) {
        if (this.existingArrays == null) {
            return super.createDoubleInstance(dimensions, entitiesPerPixel);
        }
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.cellSize, dimensions);
        return new CellContainer(new CellContainerFactory(cellSize), (ExistingDoubleArrays)this.existingArrays, dimensions, cellSize, entitiesPerPixel);
    }

    @Override
    public <T extends Type<T>> DirectAccessContainer<T, FloatArray> createFloatInstance(int[] dimensions, int entitiesPerPixel) {
        if (this.existingArrays == null) {
            return super.createFloatInstance(dimensions, entitiesPerPixel);
        }
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.cellSize, dimensions);
        return new CellContainer(new CellContainerFactory(cellSize), (ExistingFloatArrays)this.existingArrays, dimensions, cellSize, entitiesPerPixel);
    }

    @Override
    public <T extends Type<T>> DirectAccessContainer<T, IntArray> createIntInstance(int[] dimensions, int entitiesPerPixel) {
        if (this.existingArrays == null) {
            return super.createIntInstance(dimensions, entitiesPerPixel);
        }
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.cellSize, dimensions);
        return new CellContainer(new CellContainerFactory(cellSize), (ExistingIntArrays)this.existingArrays, dimensions, cellSize, entitiesPerPixel);
    }

    @Override
    public <T extends Type<T>> DirectAccessContainer<T, LongArray> createLongInstance(int[] dimensions, int entitiesPerPixel) {
        if (this.existingArrays == null) {
            return super.createLongInstance(dimensions, entitiesPerPixel);
        }
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.cellSize, dimensions);
        return new CellContainer(new CellContainerFactory(cellSize), (ExistingLongArrays)this.existingArrays, dimensions, cellSize, entitiesPerPixel);
    }

    @Override
    public <T extends Type<T>> DirectAccessContainer<T, ShortArray> createShortInstance(int[] dimensions, int entitiesPerPixel) {
        if (this.existingArrays == null) {
            return super.createShortInstance(dimensions, entitiesPerPixel);
        }
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.cellSize, dimensions);
        return new CellContainer(new CellContainerFactory(cellSize), (ExistingShortArrays)this.existingArrays, dimensions, cellSize, entitiesPerPixel);
    }
}

