/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.color;

import java.awt.Color;
import java.util.Collection;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;
import script.imglib.color.fn.ColorFunction;
import script.imglib.math.fn.IFunction;

public final class HSB
extends ColorFunction {
    private final IFunction hue;
    private final IFunction saturation;
    private final IFunction brightness;

    public HSB(IFunction hue, IFunction saturation, IFunction brightness) {
        this.hue = null == hue ? empty : hue;
        this.saturation = null == saturation ? empty : saturation;
        this.brightness = null == brightness ? empty : brightness;
    }

    public HSB(Image<? extends RealType<?>> img) {
        this(new ColorFunction.Channel(img, 3), new ColorFunction.Channel(img, 2), new ColorFunction.Channel(img, 1));
    }

    public HSB(Object hue, Object saturation, Object brightness) throws Exception {
        this(HSB.wrap(hue), HSB.wrap(saturation), HSB.wrap(brightness));
    }

    public HSB(Object hue, Object saturation) throws Exception {
        this(HSB.wrap(hue), HSB.wrap(saturation), empty);
    }

    public HSB(Object hue) throws Exception {
        this(HSB.wrap(hue), empty, empty);
    }

    public HSB(IFunction fn, int channel) throws IllegalArgumentException {
        this(3 == channel ? fn : empty, 2 == channel ? fn : empty, 1 == channel ? fn : empty);
        if (channel < 1 || channel > 3) {
            throw new IllegalArgumentException("HSB: channel must be >= 1 and <= 3");
        }
    }

    public HSB(Object ob, int channel) throws Exception, IllegalArgumentException {
        this(HSB.wrap(ob), channel);
        if (channel < 1 || channel > 4) {
            throw new IllegalArgumentException("RGB: channel must be >= 1 and <= 3");
        }
    }

    @Override
    public final IFunction duplicate() throws Exception {
        return new HSB(this.hue.duplicate(), this.saturation.duplicate(), this.brightness.duplicate());
    }

    @Override
    public final double eval() {
        return Color.HSBtoRGB((float)this.hue.eval(), (float)this.saturation.eval(), (float)this.brightness.eval());
    }

    @Override
    public final void findCursors(Collection<Cursor<?>> cursors) {
        this.hue.findCursors(cursors);
        this.saturation.findCursors(cursors);
        this.brightness.findCursors(cursors);
    }
}

