/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform.interval;

import java.util.Arrays;
import net.imglib2.FinalRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.iterator.LocalizingRealIntervalIterator;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.interval.IntervalSamplingMethod;

public abstract class Faces
implements IntervalSamplingMethod {
    protected abstract double[] spacing(RealInterval var1);

    @Override
    public RealInterval bounds(RealInterval interval, RealTransform transform) {
        assert (interval.numDimensions() >= transform.numSourceDimensions()) : "Interval dimensions too small for transformation.";
        int nSource = transform.numSourceDimensions();
        int nTarget = transform.numTargetDimensions();
        double[] itSpacing = this.spacing(interval);
        double[] min = new double[nTarget];
        double[] max = new double[nTarget];
        Arrays.fill(min, Double.MAX_VALUE);
        Arrays.fill(max, Double.MIN_VALUE);
        double[] itMin = new double[nTarget];
        double[] itMax = new double[nTarget];
        for (int i = 0; i < nSource; ++i) {
            interval.realMin(itMin);
            interval.realMax(itMax);
            itMin[i] = interval.realMin(i);
            itMax[i] = interval.realMin(i);
            IntervalSamplingMethod.transformedCoordinateBounds(transform, new LocalizingRealIntervalIterator(itMin, itMax, itSpacing), min, max);
            itMin[i] = interval.realMax(i);
            itMax[i] = interval.realMax(i);
            IntervalSamplingMethod.transformedCoordinateBounds(transform, new LocalizingRealIntervalIterator(itMin, itMax, itSpacing), min, max);
        }
        return new FinalRealInterval(min, max, false);
    }
}

