/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.create.kernelLog;

import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Create.KernelLog.class)
public class DefaultCreateKernelLog<T extends ComplexType<T>>
extends AbstractUnaryFunctionOp<double[], RandomAccessibleInterval<T>>
implements Ops.Create.KernelLog {
    @Parameter
    private T type;
    private UnaryFunctionOp<Interval, RandomAccessibleInterval<T>> createOp;

    @Override
    public void initialize() {
        this.createOp = Functions.unary(this.ops(), Ops.Create.Img.class, RandomAccessibleInterval.class, Dimensions.class, new Object[]{this.type});
    }

    @Override
    public RandomAccessibleInterval<T> calculate(double[] sigmas) {
        double[] sigmaPixels = new double[sigmas.length];
        for (int i = 0; i < sigmaPixels.length; ++i) {
            double sigma_optimal;
            sigmaPixels[i] = sigma_optimal = sigmas[i] / Math.sqrt(sigmas.length);
        }
        int n = sigmaPixels.length;
        long[] dims = new long[n];
        long[] middle = new long[n];
        for (int d = 0; d < n; ++d) {
            int hksizes = Math.max(2, (int)(3.0 * sigmaPixels[d] + 0.5) + 1);
            dims[d] = 3 + 2 * hksizes;
            middle[d] = 1 + hksizes;
        }
        RandomAccessibleInterval<T> output = this.createOp.calculate((Interval)new FinalInterval(dims));
        Cursor c = Views.iterable(output).cursor();
        long[] coords = new long[sigmas.length];
        double C = 0.05 * Math.pow(1.0 / sigmas[0] / Math.sqrt(Math.PI * 2), sigmas.length);
        while (c.hasNext()) {
            c.fwd();
            c.localize(coords);
            double mantissa = 0.0;
            double exponent = 0.0;
            for (int d = 0; d < coords.length; ++d) {
                double x = coords[d] - middle[d];
                mantissa += -C * (x * x / sigmas[0] / sigmas[0] - 1.0);
                exponent += -x * x / 2.0 / sigmas[0] / sigmas[0];
            }
            ((ComplexType)c.get()).setReal(mantissa * Math.exp(exponent));
        }
        return output;
    }
}

