/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.math;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractBinaryHybridCFI;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Intervals;
import org.scijava.plugin.Plugin;

public final class IIToIIOutputII {
    private IIToIIOutputII() {
    }

    @Plugin(type=Ops.Math.Divide.class, priority=100.0)
    public static class Divide<T extends NumericType<T>>
    extends AbstractBinaryHybridCFI<IterableInterval<T>, IterableInterval<T>>
    implements Ops.Math.Divide,
    Contingent {
        private UnaryFunctionOp<IterableInterval<T>, IterableInterval<T>> outputCreator;

        @Override
        public void initialize() {
            this.outputCreator = Functions.unary(this.ops(), Ops.Create.Img.class, IterableInterval.class, this.in1(), ((NumericType)((IterableInterval)this.in1()).firstElement()).createVariable());
        }

        @Override
        public boolean conforms() {
            if (!Intervals.equalDimensions((Interval)((Interval)this.in1()), (Interval)((Interval)this.in2()))) {
                return false;
            }
            if (!((IterableInterval)this.in1()).iterationOrder().equals(((IterableInterval)this.in2()).iterationOrder())) {
                return false;
            }
            if (this.out() == null) {
                return true;
            }
            return Intervals.equalDimensions((Interval)((Interval)this.in1()), (Interval)((Interval)this.out())) && ((IterableInterval)this.in1()).iterationOrder().equals(((IterableInterval)this.out()).iterationOrder());
        }

        @Override
        public IterableInterval<T> createOutput(IterableInterval<T> input1, IterableInterval<T> input2) {
            return this.outputCreator.calculate(input1);
        }

        @Override
        public void compute(IterableInterval<T> input1, IterableInterval<T> input2, IterableInterval<T> output) {
            Cursor in1Cursor = input1.cursor();
            Cursor in2Cursor = input2.cursor();
            Cursor outCursor = output.cursor();
            while (in1Cursor.hasNext()) {
                ((NumericType)outCursor.next()).set((Type)in1Cursor.next());
                ((NumericType)outCursor.get()).div(in2Cursor.next());
            }
        }

        @Override
        public void mutate1(IterableInterval<T> arg, IterableInterval<T> in) {
            Cursor in1Cursor = arg.cursor();
            Cursor in2Cursor = in.cursor();
            while (in1Cursor.hasNext()) {
                ((NumericType)in1Cursor.next()).div(in2Cursor.next());
            }
        }

        @Override
        public void mutate2(IterableInterval<T> in, IterableInterval<T> arg) {
            NumericType tmp = (NumericType)((NumericType)in.firstElement()).createVariable();
            Cursor in1Cursor = in.cursor();
            Cursor in2Cursor = arg.cursor();
            while (in1Cursor.hasNext()) {
                tmp.set((Type)in1Cursor.next());
                tmp.div(in2Cursor.next());
                ((NumericType)in2Cursor.get()).set((Type)tmp);
            }
        }

        @Override
        public Divide<T> getIndependentInstance() {
            return this;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class, priority=100.0)
    public static class Multiply<T extends NumericType<T>>
    extends AbstractBinaryHybridCFI<IterableInterval<T>, IterableInterval<T>>
    implements Ops.Math.Multiply,
    Contingent {
        private UnaryFunctionOp<IterableInterval<T>, IterableInterval<T>> outputCreator;

        @Override
        public void initialize() {
            this.outputCreator = Functions.unary(this.ops(), Ops.Create.Img.class, IterableInterval.class, this.in1(), ((NumericType)((IterableInterval)this.in1()).firstElement()).createVariable());
        }

        @Override
        public boolean conforms() {
            if (!Intervals.equalDimensions((Interval)((Interval)this.in1()), (Interval)((Interval)this.in2()))) {
                return false;
            }
            if (!((IterableInterval)this.in1()).iterationOrder().equals(((IterableInterval)this.in2()).iterationOrder())) {
                return false;
            }
            if (this.out() == null) {
                return true;
            }
            return Intervals.equalDimensions((Interval)((Interval)this.in1()), (Interval)((Interval)this.out())) && ((IterableInterval)this.in1()).iterationOrder().equals(((IterableInterval)this.out()).iterationOrder());
        }

        @Override
        public IterableInterval<T> createOutput(IterableInterval<T> input1, IterableInterval<T> input2) {
            return this.outputCreator.calculate(input1);
        }

        @Override
        public void compute(IterableInterval<T> input1, IterableInterval<T> input2, IterableInterval<T> output) {
            Cursor in1Cursor = input1.cursor();
            Cursor in2Cursor = input2.cursor();
            Cursor outCursor = output.cursor();
            while (in1Cursor.hasNext()) {
                ((NumericType)outCursor.next()).set((Type)in1Cursor.next());
                ((NumericType)outCursor.get()).mul(in2Cursor.next());
            }
        }

        @Override
        public void mutate1(IterableInterval<T> arg, IterableInterval<T> in) {
            Cursor in1Cursor = arg.cursor();
            Cursor in2Cursor = in.cursor();
            while (in1Cursor.hasNext()) {
                ((NumericType)in1Cursor.next()).mul(in2Cursor.next());
            }
        }

        @Override
        public void mutate2(IterableInterval<T> in, IterableInterval<T> arg) {
            NumericType tmp = (NumericType)((NumericType)in.firstElement()).createVariable();
            Cursor in1Cursor = in.cursor();
            Cursor in2Cursor = arg.cursor();
            while (in1Cursor.hasNext()) {
                tmp.set((Type)in1Cursor.next());
                tmp.mul(in2Cursor.next());
                ((NumericType)in2Cursor.get()).set((Type)tmp);
            }
        }

        @Override
        public Multiply<T> getIndependentInstance() {
            return this;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class, priority=100.0)
    public static class Subtract<T extends NumericType<T>>
    extends AbstractBinaryHybridCFI<IterableInterval<T>, IterableInterval<T>>
    implements Ops.Math.Subtract,
    Contingent {
        private UnaryFunctionOp<IterableInterval<T>, IterableInterval<T>> outputCreator;

        @Override
        public void initialize() {
            this.outputCreator = Functions.unary(this.ops(), Ops.Create.Img.class, IterableInterval.class, this.in1(), ((NumericType)((IterableInterval)this.in1()).firstElement()).createVariable());
        }

        @Override
        public boolean conforms() {
            if (!Intervals.equalDimensions((Interval)((Interval)this.in1()), (Interval)((Interval)this.in2()))) {
                return false;
            }
            if (!((IterableInterval)this.in1()).iterationOrder().equals(((IterableInterval)this.in2()).iterationOrder())) {
                return false;
            }
            if (this.out() == null) {
                return true;
            }
            return Intervals.equalDimensions((Interval)((Interval)this.in1()), (Interval)((Interval)this.out())) && ((IterableInterval)this.in1()).iterationOrder().equals(((IterableInterval)this.out()).iterationOrder());
        }

        @Override
        public IterableInterval<T> createOutput(IterableInterval<T> input1, IterableInterval<T> input2) {
            return this.outputCreator.calculate(input1);
        }

        @Override
        public void compute(IterableInterval<T> input1, IterableInterval<T> input2, IterableInterval<T> output) {
            Cursor in1Cursor = input1.cursor();
            Cursor in2Cursor = input2.cursor();
            Cursor outCursor = output.cursor();
            while (in1Cursor.hasNext()) {
                ((NumericType)outCursor.next()).set((Type)in1Cursor.next());
                ((NumericType)outCursor.get()).sub(in2Cursor.next());
            }
        }

        @Override
        public void mutate1(IterableInterval<T> arg, IterableInterval<T> in) {
            Cursor in1Cursor = arg.cursor();
            Cursor in2Cursor = in.cursor();
            while (in1Cursor.hasNext()) {
                ((NumericType)in1Cursor.next()).sub(in2Cursor.next());
            }
        }

        @Override
        public void mutate2(IterableInterval<T> in, IterableInterval<T> arg) {
            NumericType tmp = (NumericType)((NumericType)in.firstElement()).createVariable();
            Cursor in1Cursor = in.cursor();
            Cursor in2Cursor = arg.cursor();
            while (in1Cursor.hasNext()) {
                tmp.set((Type)in1Cursor.next());
                tmp.sub(in2Cursor.next());
                ((NumericType)in2Cursor.get()).set((Type)tmp);
            }
        }

        @Override
        public Subtract<T> getIndependentInstance() {
            return this;
        }
    }

    @Plugin(type=Ops.Math.Add.class, priority=100.0)
    public static class Add<T extends NumericType<T>>
    extends AbstractBinaryHybridCFI<IterableInterval<T>, IterableInterval<T>>
    implements Ops.Math.Add,
    Contingent {
        private UnaryFunctionOp<IterableInterval<T>, IterableInterval<T>> outputCreator;

        @Override
        public void initialize() {
            this.outputCreator = Functions.unary(this.ops(), Ops.Create.Img.class, IterableInterval.class, this.in1(), ((NumericType)((IterableInterval)this.in1()).firstElement()).createVariable());
        }

        @Override
        public boolean conforms() {
            if (!Intervals.equalDimensions((Interval)((Interval)this.in1()), (Interval)((Interval)this.in2()))) {
                return false;
            }
            if (!((IterableInterval)this.in1()).iterationOrder().equals(((IterableInterval)this.in2()).iterationOrder())) {
                return false;
            }
            if (this.out() == null) {
                return true;
            }
            return Intervals.equalDimensions((Interval)((Interval)this.in1()), (Interval)((Interval)this.out())) && ((IterableInterval)this.in1()).iterationOrder().equals(((IterableInterval)this.out()).iterationOrder());
        }

        @Override
        public IterableInterval<T> createOutput(IterableInterval<T> input1, IterableInterval<T> input2) {
            return this.outputCreator.calculate(input1);
        }

        @Override
        public void compute(IterableInterval<T> input1, IterableInterval<T> input2, IterableInterval<T> output) {
            Cursor in1Cursor = input1.cursor();
            Cursor in2Cursor = input2.cursor();
            Cursor outCursor = output.cursor();
            while (in1Cursor.hasNext()) {
                ((NumericType)outCursor.next()).set((Type)in1Cursor.next());
                ((NumericType)outCursor.get()).add(in2Cursor.next());
            }
        }

        @Override
        public void mutate1(IterableInterval<T> arg, IterableInterval<T> in) {
            Cursor in1Cursor = arg.cursor();
            Cursor in2Cursor = in.cursor();
            while (in1Cursor.hasNext()) {
                ((NumericType)in1Cursor.next()).add(in2Cursor.next());
            }
        }

        @Override
        public void mutate2(IterableInterval<T> in, IterableInterval<T> arg) {
            NumericType tmp = (NumericType)((NumericType)in.firstElement()).createVariable();
            Cursor in1Cursor = in.cursor();
            Cursor in2Cursor = arg.cursor();
            while (in1Cursor.hasNext()) {
                tmp.set((Type)in1Cursor.next());
                tmp.add(in2Cursor.next());
                ((NumericType)in2Cursor.get()).set((Type)tmp);
            }
        }

        @Override
        public Add<T> getIndependentInstance() {
            return this;
        }
    }
}

