/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.math;

import java.util.Random;
import net.imagej.ops.Ops;
import net.imagej.ops.special.computer.AbstractUnaryComputerOp;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

public final class UnaryRealTypeMath {
    private UnaryRealTypeMath() {
    }

    @Plugin(type=Ops.Math.Ulp.class)
    public static class Ulp<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Ulp {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.ulp(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Tanh.class)
    public static class Tanh<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Tanh {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.tanh(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Tan.class)
    public static class Tan<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Tan {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.tan(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Step.class)
    public static class Step<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Step {
        @Override
        public void compute(I input, O output) {
            if (input.getRealDouble() < 0.0) {
                output.setZero();
            } else {
                output.setOne();
            }
        }
    }

    @Plugin(type=Ops.Math.Sqrt.class)
    public static class Sqrt<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Sqrt {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.sqrt(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Sqr.class)
    public static class Sqr<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Sqr {
        @Override
        public void compute(I input, O output) {
            double value = input.getRealDouble();
            output.setReal(value * value);
        }
    }

    @Plugin(type=Ops.Math.Sinh.class)
    public static class Sinh<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Sinh {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.sinh(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.SincPi.class)
    public static class SincPi<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.SincPi {
        @Override
        public void compute(I input, O output) {
            double x = input.getRealDouble();
            double value = x == 0.0 ? 1.0 : Math.sin(Math.PI * x) / (Math.PI * x);
            output.setReal(value);
        }
    }

    @Plugin(type=Ops.Math.Sinc.class)
    public static class Sinc<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Sinc {
        @Override
        public void compute(I input, O output) {
            double x = input.getRealDouble();
            double value = x == 0.0 ? 1.0 : Math.sin(x) / x;
            output.setReal(value);
        }
    }

    @Plugin(type=Ops.Math.Sin.class)
    public static class Sin<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Sin {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.sin(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Signum.class)
    public static class Signum<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Signum {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.signum(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Sech.class)
    public static class Sech<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Sech {
        @Override
        public void compute(I input, O output) {
            output.setReal(1.0 / Math.cosh(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Sec.class)
    public static class Sec<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Sec {
        @Override
        public void compute(I input, O output) {
            output.setReal(1.0 / Math.cos(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Round.class)
    public static class Round<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Round {
        @Override
        public void compute(I input, O output) {
            output.setReal((double)Math.round(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Reciprocal.class)
    public static class Reciprocal<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Reciprocal {
        @Parameter
        private double dbzVal;

        @Override
        public void compute(I input, O output) {
            double inputVal = input.getRealDouble();
            if (inputVal == 0.0) {
                output.setReal(this.dbzVal);
            } else {
                output.setReal(1.0 / inputVal);
            }
        }
    }

    @Plugin(type=Ops.Math.RandomUniform.class)
    public static class RandomUniform<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.RandomUniform {
        @Parameter(required=false)
        private long seed = -6066930261531658096L;
        private Random rng;

        public long getSeed() {
            return this.seed;
        }

        public void setSeed(long seed) {
            this.seed = seed;
        }

        @Override
        public void compute(I input, O output) {
            if (this.rng == null) {
                this.rng = new Random(this.seed);
            }
            double r = this.rng.nextDouble();
            output.setReal(r * input.getRealDouble());
        }
    }

    @Plugin(type=Ops.Math.RandomGaussian.class)
    public static class RandomGaussian<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.RandomGaussian {
        @Parameter(required=false)
        private long seed = -6066930261531658096L;
        private Random rng;

        public long getSeed() {
            return this.seed;
        }

        public void setSeed(long seed) {
            this.seed = seed;
        }

        @Override
        public void compute(I input, O output) {
            if (this.rng == null) {
                this.rng = new Random(this.seed);
            }
            output.setReal(this.rng.nextGaussian() * Math.abs(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Power.class)
    public static class PowerConstant<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Power {
        @Parameter
        private double constant;

        @Override
        public void compute(I input, O output) {
            output.setReal(Math.pow(input.getRealDouble(), this.constant));
        }
    }

    @Plugin(type=Ops.Math.Negate.class)
    public static class Negate<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Negate {
        @Override
        public void compute(I input, O output) {
            output.setReal(-input.getRealDouble());
        }
    }

    @Plugin(type=Ops.Math.NearestInt.class)
    public static class NearestInt<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.NearestInt {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.rint(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Min.class)
    public static class MinConstant<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Min {
        @Parameter
        private double constant;

        @Override
        public void compute(I input, O output) {
            double value = input.getRealDouble();
            if (value > this.constant) {
                output.setReal(value);
            } else {
                output.setReal(this.constant);
            }
        }
    }

    @Plugin(type=Ops.Math.Max.class)
    public static class MaxConstant<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Max {
        @Parameter
        private double constant;

        @Override
        public void compute(I input, O output) {
            double value = input.getRealDouble();
            if (value < this.constant) {
                output.setReal(value);
            } else {
                output.setReal(this.constant);
            }
        }
    }

    @Plugin(type=Ops.Math.LogOnePlusX.class)
    public static class LogOnePlusX<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.LogOnePlusX {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.log1p(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Log2.class)
    public static class Log2<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Log2 {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.log(input.getRealDouble()) / Math.log(2.0));
        }
    }

    @Plugin(type=Ops.Math.Log10.class)
    public static class Log10<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Log10 {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.log10(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Log.class)
    public static class Log<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Log {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.log(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Invert.class)
    public static class Invert<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Invert {
        @Parameter
        private double specifiedMin;
        @Parameter
        private double specifiedMax;

        @Override
        public void compute(I input, O output) {
            output.setReal(this.specifiedMax - (input.getRealDouble() - this.specifiedMin));
        }
    }

    @Plugin(type=Ops.Math.Gamma.class)
    public static class GammaConstant<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Gamma {
        @Parameter
        private double constant;

        @Override
        public void compute(I input, O output) {
            double inputVal = input.getRealDouble();
            if (inputVal <= 0.0) {
                output.setReal(0.0f);
            } else {
                output.setReal(Math.exp(this.constant * Math.log(inputVal)));
            }
        }
    }

    @Plugin(type=Ops.Math.Floor.class)
    public static class Floor<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Floor {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.floor(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.ExpMinusOne.class)
    public static class ExpMinusOne<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.ExpMinusOne {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.exp(input.getRealDouble()) - 1.0);
        }
    }

    @Plugin(type=Ops.Math.Exp.class)
    public static class Exp<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Exp {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.exp(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.CubeRoot.class)
    public static class CubeRoot<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.CubeRoot {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.cbrt(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Csch.class)
    public static class Csch<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Csch {
        @Override
        public void compute(I input, O output) {
            output.setReal(1.0 / Math.sinh(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Csc.class)
    public static class Csc<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Csc {
        @Override
        public void compute(I input, O output) {
            output.setReal(1.0 / Math.sin(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Coth.class)
    public static class Coth<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Coth {
        @Override
        public void compute(I input, O output) {
            output.setReal(1.0 / Math.tanh(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Cot.class)
    public static class Cot<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Cot {
        @Override
        public void compute(I input, O output) {
            output.setReal(1.0 / Math.tan(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Cosh.class)
    public static class Cosh<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Cosh {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.cosh(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Cos.class)
    public static class Cos<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Cos {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.cos(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Ceil.class)
    public static class Ceil<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Ceil {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.ceil(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Arctanh.class)
    public static class Arctanh<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Arctanh {
        @Override
        public void compute(I input, O output) {
            double xt = input.getRealDouble();
            output.setReal(0.5 * Math.log((1.0 + xt) / (1.0 - xt)));
        }
    }

    @Plugin(type=Ops.Math.Arctan.class)
    public static class Arctan<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Arctan {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.atan(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Arcsinh.class)
    public static class Arcsinh<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Arcsinh {
        @Override
        public void compute(I input, O output) {
            double xt = input.getRealDouble();
            double delta = Math.sqrt(xt * xt + 1.0);
            output.setReal(Math.log(xt + delta));
        }
    }

    @Plugin(type=Ops.Math.Arcsin.class)
    public static class Arcsin<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Arcsin {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.asin(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Arcsech.class)
    public static class Arcsech<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Arcsech {
        @Override
        public void compute(I input, O output) {
            double xt = input.getRealDouble();
            double numer = 1.0 + Math.sqrt(1.0 - xt * xt);
            output.setReal(Math.log(numer / xt));
        }
    }

    @Plugin(type=Ops.Math.Arcsec.class)
    public static class Arcsec<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Arcsec {
        private static final Arcsin<DoubleType, DoubleType> asin = new Arcsin();
        private final DoubleType angle = new DoubleType();
        private final DoubleType tmp = new DoubleType();

        @Override
        public void compute(I input, O output) {
            double xt = input.getRealDouble();
            if (xt > -1.0 && xt < 1.0) {
                throw new IllegalArgumentException("arcsec(x) : x out of range");
            }
            if (xt == -1.0) {
                output.setReal(Math.PI);
            } else if (xt == 1.0) {
                output.setReal(0.0f);
            } else {
                this.tmp.setReal(Math.sqrt(xt * xt - 1.0) / xt);
                asin.compute(this.tmp, this.angle);
                double value = this.angle.getRealDouble();
                if (xt < -1.0) {
                    value += Math.PI;
                }
                output.setReal(value);
            }
        }
    }

    @Plugin(type=Ops.Math.Arccsch.class)
    public static class Arccsch<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Arccsch {
        @Override
        public void compute(I input, O output) {
            double xt = input.getRealDouble();
            double delta = Math.sqrt(1.0 + 1.0 / (xt * xt));
            output.setReal(Math.log(1.0 / xt + delta));
        }
    }

    @Plugin(type=Ops.Math.Arccsc.class)
    public static class Arccsc<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Arccsc {
        private static final Arcsin<DoubleType, DoubleType> asin = new Arcsin();
        private final DoubleType angle = new DoubleType();
        private final DoubleType tmp = new DoubleType();

        @Override
        public void compute(I input, O output) {
            double xt = input.getRealDouble();
            if (xt > -1.0 && xt < 1.0) {
                throw new IllegalArgumentException("arccsc(x) : x out of range");
            }
            if (xt == -1.0) {
                output.setReal(-1.5707963267948966);
            } else if (xt == 1.0) {
                output.setReal(1.5707963267948966);
            } else {
                this.tmp.setReal(1.0 / xt);
                asin.compute(this.tmp, this.angle);
                output.setReal(this.angle.getRealDouble());
            }
        }
    }

    @Plugin(type=Ops.Math.Arccoth.class)
    public static class Arccoth<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Arccoth {
        @Override
        public void compute(I input, O output) {
            double xt = input.getRealDouble();
            output.setReal(0.5 * Math.log((xt + 1.0) / (xt - 1.0)));
        }
    }

    @Plugin(type=Ops.Math.Arccot.class)
    public static class Arccot<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Arccot {
        @Override
        public void compute(I input, O output) {
            double value = Math.atan(1.0 / input.getRealDouble());
            if (input.getRealDouble() < 0.0) {
                value += Math.PI;
            }
            output.setReal(value);
        }
    }

    @Plugin(type=Ops.Math.Arccosh.class)
    public static class Arccosh<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Arccosh {
        @Override
        public void compute(I input, O output) {
            double xt = input.getRealDouble();
            double delta = Math.sqrt(xt * xt - 1.0);
            if (xt <= -1.0) {
                delta = -delta;
            }
            output.setReal(Math.log(xt + delta));
        }
    }

    @Plugin(type=Ops.Math.Arccos.class)
    public static class Arccos<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Arccos {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.acos(input.getRealDouble()));
        }
    }

    @Plugin(type=Ops.Math.Abs.class)
    public static class Abs<I extends RealType<I>, O extends RealType<O>>
    extends AbstractUnaryComputerOp<I, O>
    implements Ops.Math.Abs {
        @Override
        public void compute(I input, O output) {
            output.setReal(Math.abs(input.getRealDouble()));
        }
    }
}

