/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour.io.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.scijava.AbstractContextual;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginService;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionProvider;
import org.scijava.ui.behaviour.io.gui.CommandDescriptions;

public class CommandDescriptionsBuilder
extends AbstractContextual {
    @Parameter
    private PluginService pluginService;
    private final List<ProviderAndContext> registered = new ArrayList<ProviderAndContext>();

    public void addManually(CommandDescriptionProvider provider, String context) {
        for (ProviderAndContext pac : this.registered) {
            if (!pac.context.equals(context) || !pac.provider.getClass().equals(provider.getClass())) continue;
            System.err.println("Potential problem: a provider of class " + provider.getClass() + " is already registered for context \"" + context + "\".");
        }
        this.registered.add(new ProviderAndContext(provider, context));
    }

    public void addManually(CommandDescriptionProvider provider, String ... contexts) {
        Arrays.stream(contexts).forEachOrdered(context -> this.addManually(provider, (String)context));
    }

    public void discoverProviders() {
        this.discoverProviders((CommandDescriptionProvider p) -> true);
    }

    public void discoverProviders(CommandDescriptionProvider.Scope ... scopes) {
        this.discoverProviders((CommandDescriptionProvider provider) -> Arrays.asList(scopes).contains(provider.getScope()));
    }

    public void discoverProviders(Predicate<CommandDescriptionProvider> predicate) {
        List providers = this.pluginService.createInstancesOfType(CommandDescriptionProvider.class);
        for (CommandDescriptionProvider provider : providers) {
            if (!predicate.test(provider)) continue;
            for (String context : provider.getExpectedContexts()) {
                this.registered.add(new ProviderAndContext(provider, context));
            }
        }
    }

    public void verifyManuallyAdded() {
        ArrayList<ProviderAndContext> discovered = new ArrayList<ProviderAndContext>();
        List providers = this.pluginService.createInstancesOfType(CommandDescriptionProvider.class);
        for (CommandDescriptionProvider provider : providers) {
            for (String context : provider.getExpectedContexts()) {
                discovered.add(new ProviderAndContext(provider, context));
            }
        }
        boolean anyFailed = false;
        block2: for (ProviderAndContext r : this.registered) {
            for (ProviderAndContext d : discovered) {
                if (!r.context.equals(d.context) || !r.provider.getClass().equals(d.provider.getClass())) continue;
                continue block2;
            }
            System.err.println(r.provider.getClass() + " (\"" + r.context + "\") is manually registered, but could not be discovered.");
            anyFailed = true;
        }
        if (anyFailed) {
            System.err.println();
        }
        block4: for (ProviderAndContext d : discovered) {
            for (ProviderAndContext r : this.registered) {
                if (!r.context.equals(d.context) || !r.provider.getClass().equals(d.provider.getClass())) continue;
                continue block4;
            }
            System.err.println(d.provider.getClass() + " (\"" + d.context + "\") was discovered, but was not manually registered.");
        }
    }

    public CommandDescriptions build() {
        CommandDescriptions descriptions = new CommandDescriptions();
        for (ProviderAndContext pac : this.registered) {
            descriptions.setKeyconfigContext(pac.context);
            pac.provider.getCommandDescriptions(descriptions);
        }
        return descriptions;
    }

    private static class ProviderAndContext {
        final CommandDescriptionProvider provider;
        final String context;

        public ProviderAndContext(CommandDescriptionProvider provider, String context) {
            this.provider = provider;
            this.context = context;
        }
    }
}

