/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.timelapsedisplay;

import java.io.File;
import java.util.ArrayList;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.ViewStructure;
import mpicbg.spim.registration.bead.Bead;

public class RegistrationStatistics {
    double minError = 0.0;
    double avgError = 0.0;
    double maxError = 0.0;
    double minRatio = 1.0;
    double maxRatio = 0.0;
    double avgRatio = 0.0;
    final int timePoint;
    File worstView;

    public RegistrationStatistics(ViewStructure viewStructure) {
        this.timePoint = viewStructure.getTimePoint();
        this.collect(viewStructure);
    }

    public RegistrationStatistics(int timePoint, double minError, double avgError, double maxError, double minRatio, double avgRatio, double maxRatio, File worstView) {
        this(timePoint, minError, avgError, maxError, minRatio, avgRatio, maxRatio);
        this.worstView = worstView;
    }

    public RegistrationStatistics(int timePoint, double minError, double avgError, double maxError, double minRatio, double avgRatio, double maxRatio) {
        this.timePoint = timePoint;
        this.minError = minError;
        this.avgError = avgError;
        this.maxError = maxError;
        this.minRatio = minRatio;
        this.avgRatio = avgRatio;
        this.maxRatio = maxRatio;
    }

    final int getTimePoint() {
        return this.timePoint;
    }

    final double getMinError() {
        return this.minError;
    }

    final double getAvgError() {
        return this.avgError;
    }

    final double getMaxError() {
        return this.maxError;
    }

    final double getMinRatio() {
        return this.minRatio;
    }

    final double getAvgRatio() {
        return this.avgRatio;
    }

    final double getMaxRatio() {
        return this.maxRatio;
    }

    protected void collect(ViewStructure viewStructure) {
        this.minError = viewStructure.getGlobalErrorStatistics().getMinAlignmentError();
        this.avgError = viewStructure.getGlobalErrorStatistics().getAverageAlignmentError();
        this.maxError = viewStructure.getGlobalErrorStatistics().getMaxAlignmentError();
        this.minRatio = 1.0;
        this.maxRatio = 0.0;
        this.avgRatio = 0.0;
        int numViews = 0;
        ViewDataBeads worstView = viewStructure.getViews().get(0);
        for (ViewDataBeads view : viewStructure.getViews()) {
            if (!view.getUseForRegistration()) continue;
            ArrayList<Bead> beadList = view.getBeadStructure().getBeadList();
            int candidates = 0;
            int correspondences = 0;
            for (Bead bead : beadList) {
                candidates += bead.getDescriptorCorrespondence().size();
                correspondences += bead.getRANSACCorrespondence().size();
            }
            if (candidates > 0) {
                double ratio = (double)correspondences / (double)candidates;
                if (ratio <= this.minRatio) {
                    this.minRatio = ratio;
                    worstView = view;
                }
                if (ratio > this.maxRatio) {
                    this.maxRatio = ratio;
                }
                this.avgRatio += ratio;
            } else {
                this.minRatio = 0.0;
            }
            ++numViews;
        }
        this.avgRatio /= (double)numViews;
        this.worstView = new File(worstView.getFileName());
    }
}

