/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.pointdescriptor.model;

import java.util.Collection;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.pointdescriptor.model.TranslationInvariantModel;

public class FixedModel
extends TranslationInvariantModel<FixedModel> {
    protected static final int MIN_NUM_MATCHES = 1;
    protected double m00 = 1.0;
    protected double m01 = 0.0;
    protected double m02 = 0.0;
    protected double m03 = 0.0;
    protected double m10 = 0.0;
    protected double m11 = 1.0;
    protected double m12 = 0.0;
    protected double m13 = 0.0;
    protected double m20 = 0.0;
    protected double m21 = 0.0;
    protected double m22 = 1.0;
    protected double m23 = 0.0;

    public FixedModel(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
    }

    @Override
    public boolean canDoNumDimension(int numDimensions) {
        return numDimensions == 3;
    }

    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        if (matches.size() < 1) {
            throw new NotEnoughDataPointsException(matches.size() + " matches given, we need at least " + 1 + " data point.");
        }
    }

    public final void set(FixedModel m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m03 = m.m03;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m13 = m.m13;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
        this.m23 = m.m23;
        this.cost = m.cost;
    }

    public FixedModel copy() {
        FixedModel m = new FixedModel(this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23);
        m.cost = this.cost;
        return m;
    }

    public final int getMinNumMatches() {
        return 1;
    }

    public final double[] apply(double[] l) {
        double[] transformed = (double[])l.clone();
        this.applyInPlace(transformed);
        return transformed;
    }

    public final void applyInPlace(double[] l) {
        assert (l.length == 3) : "3d 3x3 transformations can be applied to 3d points only.";
        double l0 = l[0];
        double l1 = l[1];
        l[0] = l0 * this.m00 + l1 * this.m01 + l[2] * this.m02 + this.m03;
        l[1] = l0 * this.m10 + l1 * this.m11 + l[2] * this.m12 + this.m13;
        l[2] = l0 * this.m20 + l1 * this.m21 + l[2] * this.m22 + this.m23;
    }

    public final String toString() {
        return "3d-3x3: (" + this.m00 + ", " + this.m01 + ", " + this.m02 + ", " + this.m03 + ", " + this.m10 + ", " + this.m11 + ", " + this.m12 + ", " + this.m13 + ", " + this.m20 + ", " + this.m21 + ", " + this.m22 + ", " + this.m23 + ")";
    }
}

