/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.registration.bead;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.AffineModel3D;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.RigidModel3D;
import mpicbg.models.TranslationModel3D;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.io.SPIMConfiguration;
import mpicbg.spim.mpicbg.TileConfigurationSPIM;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.ViewStructure;
import mpicbg.spim.registration.bead.Bead;
import mpicbg.spim.registration.bead.error.GlobalErrorStatistics;
import mpicbg.spim.registration.detection.DetectionRegistration;
import mpicbg.spim.registration.detection.descriptor.CoordSystem3d;
import mpicbg.util.TransformUtils;
import spim.vecmath.Matrix4f;
import spim.vecmath.Quat4f;
import spim.vecmath.Transform3D;
import spim.vecmath.Vector3d;
import spim.vecmath.Vector3f;

public class BeadRegistration {
    public static float minInlierFactor = 3.0f;
    public static boolean preAlignTiles = false;
    final ViewStructure viewStructure;
    static final NumberFormat nf = NumberFormat.getPercentInstance();

    public BeadRegistration(ViewStructure viewStructure) {
        this.viewStructure = viewStructure;
    }

    public ViewStructure getViewStructure() {
        return this.viewStructure;
    }

    public TileConfigurationSPIM registerViews() {
        return BeadRegistration.registerViews(this.viewStructure);
    }

    public TileConfigurationSPIM registerViews(boolean resetW) {
        return BeadRegistration.registerViews(this.viewStructure, resetW);
    }

    public void registerViewStructure(ViewStructure template) {
        BeadRegistration.registerViewStructure(this.viewStructure, template);
    }

    public static void registerViewStructure(ViewStructure reference, ViewStructure template) {
        int viewIndexA;
        final int debugLevel = Math.min(reference.getDebugLevel(), template.getDebugLevel());
        final GlobalErrorStatistics errorStatistics = template.getGlobalErrorStatistics();
        final SPIMConfiguration conf = template.getSPIMConfiguration();
        if (reference.getTimePoint() == template.getTimePoint()) {
            for (int view = 0; view < reference.getNumViews(); ++view) {
                ViewDataBeads templateView = template.getViews().get(view);
                ViewDataBeads referenceView = reference.getViews().get(view);
                templateView.getTile().getModel().set(referenceView.getTile().getModel());
                for (int i = 0; i < reference.getNumViews(); ++i) {
                    if (i == view) continue;
                    templateView.getViewErrorStatistics().setViewConnected(template.getViews().get(i), true);
                }
            }
            if (conf.writeRegistration) {
                for (ViewDataBeads view : template.getViews()) {
                    view.writeRegistrationTimeLapse(template.getTimePoint());
                }
            }
            return;
        }
        for (ViewDataBeads views : template.getViews()) {
            views.getTile().getModel().set(views.getUninitializedModel());
        }
        for (ViewDataBeads view : reference.getViews()) {
            if (debugLevel <= 0) {
                IOFunctions.println(view + ": " + (float)view.getZStretching());
            }
            for (Bead bead : view.getBeadStructure().getBeadList()) {
                double[] dArray = bead.getL();
                dArray[2] = dArray[2] * (double)((float)view.getZStretching());
                bead.getDescriptorCorrespondence().clear();
                bead.getRANSACCorrespondence().clear();
            }
        }
        for (ViewDataBeads view : template.getViews()) {
            if (debugLevel <= 0) {
                IOFunctions.println(view + ": " + (float)view.getZStretching());
            }
            for (Bead bead : view.getBeadStructure().getBeadList()) {
                double[] dArray = bead.getL();
                dArray[2] = dArray[2] * (double)((float)view.getZStretching());
                bead.getDescriptorCorrespondence().clear();
                bead.getRANSACCorrespondence().clear();
            }
        }
        final Vector<ViewDataBeads[]> comparePairs = new Vector<ViewDataBeads[]>();
        for (viewIndexA = 0; viewIndexA < template.getNumViews() - 1; ++viewIndexA) {
            for (int viewIndexB = viewIndexA + 1; viewIndexB < template.getNumViews(); ++viewIndexB) {
                if (!template.getViews().get(viewIndexA).getUseForRegistration() || !template.getViews().get(viewIndexB).getUseForRegistration()) continue;
                comparePairs.add(new ViewDataBeads[]{template.getViews().get(viewIndexA), template.getViews().get(viewIndexB)});
            }
        }
        for (viewIndexA = 0; viewIndexA < reference.getNumViews(); ++viewIndexA) {
            for (int viewIndexB = 0; viewIndexB < template.getNumViews(); ++viewIndexB) {
                if (!reference.getViews().get(viewIndexA).getUseForRegistration() || !reference.getViews().get(viewIndexB).getUseForRegistration()) continue;
                comparePairs.add(new ViewDataBeads[]{reference.getViews().get(viewIndexA), template.getViews().get(viewIndexB)});
            }
        }
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads();
        final int numThreads = threads.length;
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    CoordSystem3d<Bead> ce = new CoordSystem3d<Bead>();
                    for (int i = 0; i < comparePairs.size(); ++i) {
                        if (i % numThreads != myNumber) continue;
                        ViewDataBeads[] pair = (ViewDataBeads[])comparePairs.get(i);
                        ViewDataBeads viewA = pair[0];
                        ViewDataBeads viewB = pair[1];
                        if (debugLevel <= 0) {
                            IOFunctions.println(viewA.getName() + "<->" + viewB.getName() + ": Starting Correspondence Extraction, " + viewA.getBeadStructure().getBeadList().size() + " <-> " + viewB.getBeadStructure().getBeadList().size() + " detection comparisons.");
                        }
                        ArrayList candidates = ce.extractCorrespondenceCandidates(viewA.getBeadStructure().getBeadList(), viewB.getBeadStructure().getBeadList(), conf.differenceThreshold, conf.ratioOfDistance, conf.useAssociatedBeads);
                        ArrayList correspondences = new ArrayList();
                        Model model = viewA.getTile().getModel().copy();
                        String result = DetectionRegistration.computeRANSAC(candidates, correspondences, model, conf.max_epsilon, conf.min_inlier_ratio, minInlierFactor, conf.numIterations);
                        if (debugLevel <= 1) {
                            IOFunctions.println(viewA.getName() + "<->" + viewB.getName() + ": " + result);
                        }
                        GlobalErrorStatistics globalErrorStatistics = errorStatistics;
                        synchronized (globalErrorStatistics) {
                            errorStatistics.setNumCandidates(errorStatistics.getNumCandidates() + candidates.size());
                        }
                        if (correspondences.size() == 0) {
                            viewA.getViewErrorStatistics().resetViewSpecificError(viewB);
                        } else {
                            globalErrorStatistics = errorStatistics;
                            synchronized (globalErrorStatistics) {
                                errorStatistics.setNumCorrespondences(errorStatistics.getNumCorrespondences() + correspondences.size());
                                errorStatistics.setAbsoluteLocalAlignmentError(errorStatistics.getAbsoluteLocalAlignmentError() + model.getCost());
                                errorStatistics.setAlignmentErrorCount(errorStatistics.getAlignmentErrorCount() + 1);
                            }
                            if (viewA.getViewStructure() == viewB.getViewStructure()) {
                                viewA.getViewErrorStatistics().setViewSpecificError(viewB, model.getCost());
                                viewB.getViewErrorStatistics().setViewSpecificError(viewA, model.getCost());
                            }
                        }
                        DetectionRegistration.addPointMatches(correspondences, viewA.getTile(), viewB.getTile());
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
        if (debugLevel <= 1) {
            for (ViewDataBeads view : reference.getViews()) {
                IOFunctions.println(view + " has " + view.getViewErrorStatistics().getNumTrueCorrespondencePairs() + " correspondences in " + view.getViewErrorStatistics().getNumConnectedViews() + " other views.");
            }
            for (ViewDataBeads view : template.getViews()) {
                IOFunctions.println(view + " has " + view.getViewErrorStatistics().getNumTrueCorrespondencePairs() + " correspondences in " + view.getViewErrorStatistics().getNumConnectedViews() + " other views.");
            }
            IOFunctions.println("The total number of detections was: " + errorStatistics.getNumDetections());
            IOFunctions.println("The total number of true correspondences is: " + errorStatistics.getNumCorrespondences());
            IOFunctions.println("The total number of correspondence candidates was: " + errorStatistics.getNumCandidates());
            float ratio = (float)errorStatistics.getNumCorrespondences() / (float)errorStatistics.getNumCandidates();
            IOFunctions.println("The ratio is: " + nf.format(ratio));
        }
        ArrayList<ViewDataBeads> views = new ArrayList<ViewDataBeads>();
        views.addAll(reference.getViews());
        views.addAll(template.getViews());
        int numTilesReference = 0;
        for (ViewDataBeads view : reference.getViews()) {
            if (!view.getUseForRegistration()) continue;
            ++numTilesReference;
        }
        BeadRegistration.optimizeTiles(views, numTilesReference, errorStatistics, debugLevel);
        for (ViewDataBeads view : reference.getViews()) {
            for (Bead bead : view.getBeadStructure().getBeadList()) {
                double[] dArray = bead.getL();
                dArray[2] = dArray[2] / (double)((float)view.getZStretching());
                bead.resetW();
            }
        }
        for (ViewDataBeads view : template.getViews()) {
            for (Bead bead : view.getBeadStructure().getBeadList()) {
                double[] dArray = bead.getL();
                dArray[2] = dArray[2] / (double)((float)view.getZStretching());
                bead.resetW();
            }
        }
        if (conf.writeRegistration) {
            for (ViewDataBeads view : template.getViews()) {
                view.writeRegistrationTimeLapse(reference.getTimePoint());
            }
        }
    }

    public static TileConfigurationSPIM registerViews(ViewStructure viewStructure) {
        return BeadRegistration.registerViews(viewStructure, true);
    }

    /*
     * WARNING - void declaration
     */
    public static TileConfigurationSPIM registerViews(final ViewStructure viewStructure, boolean resetW) {
        void var6_9;
        final ArrayList<ViewDataBeads> views = viewStructure.getViews();
        final GlobalErrorStatistics errorStatistics = viewStructure.getGlobalErrorStatistics();
        final SPIMConfiguration conf = viewStructure.getSPIMConfiguration();
        for (ViewDataBeads viewDataBeads : views) {
            if (viewStructure.getDebugLevel() <= 0) {
                IOFunctions.println(viewDataBeads + ": " + (float)viewDataBeads.getZStretching());
            }
            for (Bead bead : viewDataBeads.getBeadStructure().getBeadList()) {
                double[] dArray = bead.getL();
                dArray[2] = dArray[2] * (double)((float)viewDataBeads.getZStretching());
                bead.getDescriptorCorrespondence().clear();
                bead.getRANSACCorrespondence().clear();
            }
        }
        final Vector<int[]> comparePairs = new Vector<int[]>();
        for (ViewDataBeads view : views) {
            errorStatistics.setNumDetections(errorStatistics.getNumDetections() + view.getViewErrorStatistics().getNumDetections());
        }
        boolean bl = false;
        while (var6_9 < views.size() - 1) {
            for (void viewIndexB = var6_9 + true; viewIndexB < views.size(); ++viewIndexB) {
                if (!views.get((int)var6_9).getUseForRegistration() || !views.get((int)viewIndexB).getUseForRegistration()) continue;
                comparePairs.add(new int[]{var6_9, viewIndexB});
            }
            ++var6_9;
        }
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads();
        final int numThreads = threads.length;
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int myNumber = atomicInteger.getAndIncrement();
                    CoordSystem3d<Bead> ce = new CoordSystem3d<Bead>();
                    for (int i = 0; i < comparePairs.size(); ++i) {
                        if (i % numThreads != myNumber) continue;
                        int[] pair = (int[])comparePairs.get(i);
                        ViewDataBeads viewA = (ViewDataBeads)views.get(pair[0]);
                        ViewDataBeads viewB = (ViewDataBeads)views.get(pair[1]);
                        if (viewStructure.getDebugLevel() <= 0) {
                            IOFunctions.println(viewA.getName() + "<->" + viewB.getName() + ": Starting Correspondence Extraction, " + viewA.getBeadStructure().getBeadList().size() + " <-> " + viewB.getBeadStructure().getBeadList().size() + " detection comparisons.");
                        }
                        ArrayList candidates = ce.extractCorrespondenceCandidates(viewA.getBeadStructure().getBeadList(), viewB.getBeadStructure().getBeadList(), conf.differenceThreshold, conf.ratioOfDistance, conf.useAssociatedBeads);
                        ArrayList correspondences = new ArrayList();
                        Model model = viewA.getTile().getModel().copy();
                        String result = DetectionRegistration.computeRANSAC(candidates, correspondences, model, conf.max_epsilon, conf.min_inlier_ratio, minInlierFactor, conf.numIterations);
                        if (viewStructure.getDebugLevel() <= 1) {
                            IOFunctions.println(viewA.getName() + "<->" + viewB.getName() + ": " + result);
                        }
                        GlobalErrorStatistics globalErrorStatistics = errorStatistics;
                        synchronized (globalErrorStatistics) {
                            errorStatistics.setNumCandidates(errorStatistics.getNumCandidates() + candidates.size());
                        }
                        if (correspondences.size() == 0) {
                            viewA.getViewErrorStatistics().resetViewSpecificError(viewB);
                        } else {
                            globalErrorStatistics = errorStatistics;
                            synchronized (globalErrorStatistics) {
                                errorStatistics.setNumCorrespondences(errorStatistics.getNumCorrespondences() + correspondences.size());
                                errorStatistics.setAbsoluteLocalAlignmentError(errorStatistics.getAbsoluteLocalAlignmentError() + model.getCost());
                                errorStatistics.setAlignmentErrorCount(errorStatistics.getAlignmentErrorCount() + 1);
                            }
                            if (viewA.getViewStructure() == viewB.getViewStructure()) {
                                viewA.getViewErrorStatistics().setViewSpecificError(viewB, model.getCost());
                                viewB.getViewErrorStatistics().setViewSpecificError(viewA, model.getCost());
                            }
                        }
                        DetectionRegistration.addPointMatches(correspondences, viewA.getTile(), viewB.getTile());
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
        if (viewStructure.getDebugLevel() <= 1) {
            for (ViewDataBeads view : views) {
                IOFunctions.println(view + " has " + view.getViewErrorStatistics().getNumTrueCorrespondencePairs() + " correspondences in " + view.getViewErrorStatistics().getNumConnectedViews() + " other views.");
            }
            IOFunctions.println("The total number of detections was: " + errorStatistics.getNumDetections());
            IOFunctions.println("The total number of correspondence candidates was: " + errorStatistics.getNumCandidates());
            IOFunctions.println("The total number of true correspondences is: " + errorStatistics.getNumCorrespondences());
        }
        TileConfigurationSPIM tc = BeadRegistration.optimizeTiles(views, errorStatistics, viewStructure.getDebugLevel());
        for (ViewDataBeads view : views) {
            for (Bead bead : view.getBeadStructure().getBeadList()) {
                double[] dArray = bead.getL();
                dArray[2] = dArray[2] / (double)((float)view.getZStretching());
                if (!resetW) continue;
                bead.resetW();
            }
        }
        if (conf.writeRegistration) {
            for (ViewDataBeads view : views) {
                view.writeSegmentation();
                view.writeRegistration();
            }
        }
        return tc;
    }

    public static void computeErrors(ArrayList<ViewDataBeads> views, TileConfigurationSPIM tc) {
        tc.computeError();
    }

    public static TileConfigurationSPIM optimizeTiles(ArrayList<ViewDataBeads> views, GlobalErrorStatistics errorStatistics, int debugLevel) {
        return BeadRegistration.optimizeTiles(views, 1, errorStatistics, debugLevel);
    }

    public static TileConfigurationSPIM optimizeTiles(ArrayList<ViewDataBeads> views, int numFixed, GlobalErrorStatistics errorStatistics, int debugLevel) {
        TileConfigurationSPIM tc = new TileConfigurationSPIM(debugLevel);
        int fixedTiles = 0;
        for (ViewDataBeads view : views) {
            if (view.getTile().getConnectedTiles().size() <= 0) continue;
            tc.addTile(view.getTile());
            if (fixedTiles >= numFixed) continue;
            if (debugLevel <= 1) {
                IOFunctions.println("Fixing tile " + view);
            }
            tc.fixTile(view.getTile());
            ++fixedTiles;
        }
        try {
            if (preAlignTiles) {
                int unaligned = tc.preAlign().size();
                if (unaligned > 0) {
                    IOFunctions.println("pre-aligned all tiles but " + unaligned);
                } else {
                    IOFunctions.println("prealigned all tiles");
                }
            }
            tc.optimize(10.0, 10000, 200, debugLevel);
            errorStatistics.setAverageAlignmentError(tc.getError());
            errorStatistics.setMinAlignmentError(tc.getMinError());
            errorStatistics.setMaxAlignmentError(tc.getMaxError());
        }
        catch (NotEnoughDataPointsException e) {
            e.printStackTrace();
            errorStatistics.setAverageAlignmentError(Double.MAX_VALUE);
            errorStatistics.setMinAlignmentError(Double.MAX_VALUE);
            errorStatistics.setMaxAlignmentError(Double.MAX_VALUE);
        }
        catch (IllDefinedDataPointsException e) {
            e.printStackTrace();
            errorStatistics.setAverageAlignmentError(Double.MAX_VALUE);
            errorStatistics.setMinAlignmentError(Double.MAX_VALUE);
            errorStatistics.setMaxAlignmentError(Double.MAX_VALUE);
        }
        if (debugLevel <= 1) {
            IOFunctions.println("Optimizer Matrices");
        }
        for (ViewDataBeads view : views) {
            if (view.getTile().getConnectedTiles().size() > 0) {
                if (debugLevel > 1) continue;
                IOFunctions.println(view + ":");
                IOFunctions.println("Transformation:\n" + view.getTile().getModel());
                Transform3D t = TransformUtils.getTransform3D1((AbstractAffineModel3D)view.getTile().getModel());
                Vector3d s = new Vector3d();
                t.getScale(s);
                if (view.getViewStructure().getDebugLevel() <= 1) {
                    IOFunctions.println("Scaling: " + s);
                }
                if (!(view.getTile().getModel() instanceof RigidModel3D)) continue;
                Matrix4f matrix = new Matrix4f();
                TransformUtils.getTransform3D((RigidModel3D)view.getTile().getModel()).get(matrix);
                Quat4f qu = new Quat4f();
                qu.set(matrix);
                Vector3f n = new Vector3f(qu.getX(), qu.getY(), qu.getZ());
                n.normalize();
                if (view.getViewStructure().getDebugLevel() > 1) continue;
                IOFunctions.println("Approx. Axis: " + n);
                IOFunctions.println("Approx. Angle: " + Math.toDegrees(Math.acos(qu.getW()) * 2.0));
                continue;
            }
            if (!view.getUseForRegistration()) continue;
            for (ViewDataBeads otherView : views) {
                view.getViewErrorStatistics().resetViewSpecificError(otherView);
            }
            view.getBeadStructure().clearAllRANSACCorrespondences();
            if (debugLevel > 1) continue;
            IOFunctions.println(view + ": is not connected to any other tile!");
        }
        block6: for (ViewDataBeads view : views) {
            if (view.getUseForRegistration()) continue;
            int angle = view.getAcqusitionAngle();
            int timepoint = view.getViewStructure().getTimePoint();
            for (ViewDataBeads view2 : views) {
                if (view2.getAcqusitionAngle() != angle || timepoint != view2.getViewStructure().getTimePoint() || !view2.getUseForRegistration()) continue;
                view.getTile().getModel().set(view2.getTile().getModel());
                continue block6;
            }
        }
        return tc;
    }

    public static void concatenateAxialScaling(AbstractAffineModel3D model, double zStretching) {
        if (model != null) {
            if (model instanceof AffineModel3D) {
                AffineModel3D tmpModel = new AffineModel3D();
                float z = (float)zStretching;
                tmpModel.set(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, (double)z, 0.0);
                ((AffineModel3D)model).concatenate(tmpModel);
            } else if (model instanceof RigidModel3D) {
                RigidModel3D tmpModel = new RigidModel3D();
                float z = (float)zStretching;
                tmpModel.set(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, (double)z, 0.0);
                ((RigidModel3D)model).concatenate(tmpModel);
            } else if (model instanceof TranslationModel3D) {
                IOFunctions.println("Cannot concatenate Axial Scaling with TranslationModel3D, you can load the registration as Affine or Rigid model and run it then!");
            } else {
                IOFunctions.println("Cannot concatenate Axial Scaling, unknown model: " + model.getClass().getSimpleName());
            }
        }
    }

    public static void concatenateAxialScaling(ViewDataBeads view, int debugLevel) {
        AbstractAffineModel3D m = (AbstractAffineModel3D)view.getTile().getModel();
        if (m != null) {
            BeadRegistration.concatenateAxialScaling(m, view.getZStretching());
            if (debugLevel <= 0) {
                IOFunctions.println(view + "(" + view.getZStretching() + "): " + m);
            }
        }
    }

    public static void concatenateAxialScaling(ArrayList<ViewDataBeads> views, int debugLevel) {
        if (debugLevel <= 0) {
            IOFunctions.println("----------------------Scaling corrected-------------------");
        }
        for (ViewDataBeads view : views) {
            BeadRegistration.concatenateAxialScaling(view, debugLevel);
        }
    }
}

