/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin.thinout;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.chart.ui.TextAnchor;

public class MouseListenerValue
implements ChartMouseListener {
    final ChartPanel panel;
    ValueMarker valueMarker;

    MouseListenerValue(ChartPanel panel, double startValue) {
        this.panel = panel;
        this.valueMarker = this.makeMarker(startValue);
        ((XYPlot)panel.getChart().getPlot()).addDomainMarker((Marker)this.valueMarker);
    }

    protected ValueMarker makeMarker(double value) {
        ValueMarker valueMarker = new ValueMarker(value);
        valueMarker.setStroke((Stroke)new BasicStroke(2.0f));
        valueMarker.setPaint((Paint)new Color(0.0f, 0.0f, 1.0f));
        valueMarker.setLabel(" Distance=" + value);
        valueMarker.setLabelPaint((Paint)Color.BLUE);
        valueMarker.setLabelAnchor(RectangleAnchor.TOP);
        valueMarker.setLabelTextAnchor(TextAnchor.TOP_LEFT);
        return valueMarker;
    }

    public void chartMouseClicked(ChartMouseEvent e) {
        if (e.getTrigger().getButton() == 1) {
            double value = MouseListenerValue.getChartXLocation(e.getTrigger().getPoint(), this.panel);
            this.valueMarker.setValue(value);
            this.valueMarker.setLabel(" Distance=" + value);
        }
    }

    public static int getChartXLocation(Point point, ChartPanel panel) {
        Point2D p = panel.translateScreenToJava2D(point);
        Rectangle2D plotArea = panel.getScreenDataArea();
        XYPlot plot = (XYPlot)panel.getChart().getPlot();
        double chartX = plot.getDomainAxis().java2DToValue(p.getX(), plotArea, plot.getDomainAxisEdge());
        return (int)Math.round(chartX);
    }

    public void chartMouseMoved(ChartMouseEvent e) {
    }
}

