/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.boundingbox;

import ij.gui.GenericDialog;
import java.awt.Choice;
import java.awt.Label;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.sequence.ImgLoader;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Dimensions;
import net.imglib2.FinalRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.img.imageplus.ImagePlusImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ComplexType;
import spim.fiji.plugin.fusion.Fusion;
import spim.fiji.plugin.util.GUIHelper;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.ViewSetupUtils;
import spim.fiji.spimdata.boundingbox.BoundingBox;
import spim.process.fusion.export.ImgExport;

public class BoundingBoxGUI
extends BoundingBox {
    public static int staticDownsampling = 1;
    public static int[] defaultMin = new int[]{0, 0, 0};
    public static int[] defaultMax = new int[]{0, 0, 0};
    public static String[] pixelTypes = new String[]{"32-bit floating point", "16-bit unsigned integer"};
    public static int defaultPixelType = 0;
    protected int pixelType = 0;
    public static String[] imgTypes = new String[]{"ArrayImg", "PlanarImg (large images, easy to display)", "CellImg (large images)"};
    public static int defaultImgType = 1;
    protected int imgtype = 1;
    protected final List<ViewId> viewIdsToProcess;
    protected final SpimData2 spimData;
    protected int downsampling = 1;
    protected boolean changedSpimDataObject = false;

    public BoundingBoxGUI(SpimData2 spimData, List<ViewId> viewIdsToProcess) {
        super(null, null);
        this.spimData = spimData;
        this.viewIdsToProcess = viewIdsToProcess;
    }

    public BoundingBoxGUI(SpimData2 spimData, List<ViewId> viewIdsToProcess, BoundingBox bb) {
        super(bb.getMin(), bb.getMax());
        this.spimData = spimData;
        this.viewIdsToProcess = viewIdsToProcess;
    }

    public boolean queryParameters(Fusion fusion, ImgExport imgExport) {
        return this.queryParameters(fusion, imgExport, true);
    }

    public boolean queryParameters(Fusion fusion, ImgExport imgExport, boolean allowModifyDimensions) {
        boolean compress = fusion == null ? false : fusion.compressBoundingBoxDialog();
        boolean supportsDownsampling = fusion == null ? false : fusion.supportsDownsampling();
        boolean supports16BitUnsigned = fusion == null ? false : fusion.supports16BitUnsigned();
        GenericDialog gd = this.getSimpleDialog(compress, allowModifyDimensions);
        if (!compress) {
            gd.addMessage("");
        }
        if (supportsDownsampling) {
            gd.addSlider("Downsample fused dataset", 1.0, 10.0, (double)staticDownsampling);
        }
        if (supports16BitUnsigned) {
            gd.addChoice("Pixel_type", pixelTypes, pixelTypes[defaultPixelType]);
        }
        if (fusion != null && imgExport != null) {
            gd.addChoice("ImgLib2_container", imgTypes, imgTypes[defaultImgType]);
        }
        if (fusion != null) {
            fusion.queryAdditionalParameters(gd);
        }
        if (imgExport != null) {
            imgExport.queryAdditionalParameters(gd, this.spimData);
        }
        gd.addMessage("Estimated size: ", GUIHelper.largestatusfont, GUIHelper.good);
        Label l1 = (Label)gd.getMessage();
        gd.addMessage("???x???x??? pixels", GUIHelper.smallStatusFont, GUIHelper.good);
        Label l2 = (Label)gd.getMessage();
        ManageListeners m = new ManageListeners(gd, gd.getNumericFields(), gd.getChoices(), l1, l2, fusion, imgExport, supportsDownsampling, supports16BitUnsigned);
        if (fusion != null) {
            fusion.registerAdditionalListeners(m);
        }
        m.update();
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        if (allowModifyDimensions) {
            this.min[0] = (int)Math.round(gd.getNextNumber());
            this.min[1] = (int)Math.round(gd.getNextNumber());
            this.min[2] = (int)Math.round(gd.getNextNumber());
            this.max[0] = (int)Math.round(gd.getNextNumber());
            this.max[1] = (int)Math.round(gd.getNextNumber());
            this.max[2] = (int)Math.round(gd.getNextNumber());
        } else {
            BoundingBoxGUI.setNFIndex(gd, 6);
        }
        this.downsampling = supportsDownsampling ? (staticDownsampling = (int)Math.round(gd.getNextNumber())) : 1;
        if (supports16BitUnsigned) {
            this.pixelType = defaultPixelType = gd.getNextChoiceIndex();
        } else {
            defaultPixelType = 0;
            this.pixelType = 0;
        }
        if (fusion != null && imgExport != null) {
            this.imgtype = defaultImgType = gd.getNextChoiceIndex();
        }
        if (this.min[0] > this.max[0] || this.min[1] > this.max[1] || this.min[2] > this.max[2]) {
            IOFunctions.println("Invalid coordinates, min cannot be larger than max");
            return false;
        }
        if (fusion != null && !fusion.parseAdditionalParameters(gd)) {
            return false;
        }
        if (imgExport != null && !imgExport.parseAdditionalParameters(gd, this.spimData)) {
            return false;
        }
        BoundingBoxGUI.defaultMin[0] = this.min[0];
        BoundingBoxGUI.defaultMin[1] = this.min[1];
        BoundingBoxGUI.defaultMin[2] = this.min[2];
        BoundingBoxGUI.defaultMax[0] = this.max[0];
        BoundingBoxGUI.defaultMax[1] = this.max[1];
        BoundingBoxGUI.defaultMax[2] = this.max[2];
        return true;
    }

    protected GenericDialog getSimpleDialog(boolean compress, boolean allowModifyDimensions) {
        int[] rangeMin = new int[3];
        int[] rangeMax = new int[3];
        this.setUpDefaultValues(rangeMin, rangeMax);
        GenericDialog gd = new GenericDialog("Manually define Bounding Box");
        gd.addMessage("Note: Coordinates are in global coordinates as shown in Fiji status bar of a fused datasets", GUIHelper.smallStatusFont);
        if (!compress) {
            gd.addMessage("", GUIHelper.smallStatusFont);
        }
        gd.addSlider("Minimal_X", (double)rangeMin[0], (double)rangeMax[0], (double)this.min[0]);
        gd.addSlider("Minimal_Y", (double)rangeMin[1], (double)rangeMax[1], (double)this.min[1]);
        gd.addSlider("Minimal_Z", (double)rangeMin[2], (double)rangeMax[2], (double)this.min[2]);
        if (!compress) {
            gd.addMessage("");
        }
        gd.addSlider("Maximal_X", (double)rangeMin[0], (double)rangeMax[0], (double)this.max[0]);
        gd.addSlider("Maximal_Y", (double)rangeMin[1], (double)rangeMax[1], (double)this.max[1]);
        gd.addSlider("Maximal_Z", (double)rangeMin[2], (double)rangeMax[2], (double)this.max[2]);
        if (!allowModifyDimensions) {
            int i;
            for (i = gd.getSliders().size() - 6; i < gd.getSliders().size(); ++i) {
                ((Scrollbar)gd.getSliders().get(i)).setEnabled(false);
            }
            for (i = gd.getNumericFields().size() - 6; i < gd.getNumericFields().size(); ++i) {
                ((TextField)gd.getNumericFields().get(i)).setEnabled(false);
            }
        }
        return gd;
    }

    protected void setUpDefaultValues(int[] rangeMin, int[] rangeMax) {
        double[] minBB = new double[rangeMin.length];
        double[] maxBB = new double[rangeMin.length];
        this.changedSpimDataObject = BoundingBoxGUI.computeMaxBoundingBoxDimensions(this.spimData, this.viewIdsToProcess, minBB, maxBB);
        for (int d = 0; d < minBB.length; ++d) {
            rangeMin[d] = Math.round((float)Math.floor(minBB[d]));
            rangeMax[d] = Math.round((float)Math.floor(maxBB[d]));
            if (rangeMin[d] < 0) {
                int n = d;
                rangeMin[n] = rangeMin[n] - 1;
            }
            if (rangeMax[d] > 0) {
                int n = d;
                rangeMax[n] = rangeMax[n] + 1;
            }
            if (this.min == null || this.max == null) {
                this.min = new int[rangeMin.length];
                this.max = new int[rangeMin.length];
            }
            if (this.min[d] == 0 && this.max[d] == 0) {
                if (defaultMin[d] == 0 && defaultMax[d] == 0) {
                    this.min[d] = rangeMin[d];
                    this.max[d] = rangeMax[d];
                } else {
                    this.min[d] = defaultMin[d];
                    this.max[d] = defaultMax[d];
                }
            }
            if (this.min[d] > this.max[d]) {
                this.min[d] = this.max[d];
            }
            if (this.min[d] < rangeMin[d]) {
                rangeMin[d] = this.min[d];
            }
            if (this.max[d] <= rangeMax[d]) continue;
            rangeMax[d] = this.max[d];
        }
    }

    public BoundingBoxGUI newInstance(SpimData2 spimData, List<ViewId> viewIdsToProcess) {
        return new BoundingBoxGUI(spimData, viewIdsToProcess);
    }

    public String getDescription() {
        return "Define manually";
    }

    public boolean cleanUp() {
        return this.changedSpimDataObject;
    }

    public int getDownSampling() {
        return this.downsampling;
    }

    public int getPixelType() {
        return this.pixelType;
    }

    public int getImgType() {
        return this.imgtype;
    }

    public <T extends ComplexType<T> & NativeType<T>> ImgFactory<T> getImgFactory(T type) {
        Object imgFactory = this.getImgType() == 0 ? new ArrayImgFactory() : (this.getImgType() == 1 ? new ImagePlusImgFactory() : new CellImgFactory(new int[]{256}));
        return imgFactory;
    }

    public long[] getDimensions() {
        long[] dim = new long[this.numDimensions()];
        this.dimensions(dim);
        int d = 0;
        while (d < this.numDimensions()) {
            int n = d++;
            dim[n] = dim[n] / (long)this.getDownSampling();
        }
        return dim;
    }

    public static boolean computeMaxBoundingBoxDimensions(SpimData2 spimData, List<ViewId> viewIdsToProcess, double[] minBB, double[] maxBB) {
        for (int d = 0; d < minBB.length; ++d) {
            minBB[d] = Double.MAX_VALUE;
            maxBB[d] = -1.7976931348623157E308;
        }
        boolean changed = false;
        IOFunctions.println(new Date(System.currentTimeMillis()) + ": Estimating Bounding Box for Fusion. If size of images is not known (they were never opened before), some of them need to be opened once to determine their size.");
        for (ViewId viewId : viewIdsToProcess) {
            ViewDescription viewDescription = ((SequenceDescription)spimData.getSequenceDescription()).getViewDescription(viewId.getTimePointId(), viewId.getViewSetupId());
            if (!viewDescription.isPresent()) continue;
            if (!((ViewSetup)viewDescription.getViewSetup()).hasSize()) {
                changed = true;
            }
            Dimensions size = ViewSetupUtils.getSizeOrLoad(viewDescription.getViewSetup(), viewDescription.getTimePoint(), (ImgLoader)((SequenceDescription)spimData.getSequenceDescription()).getImgLoader());
            double[] min = new double[]{0.0, 0.0, 0.0};
            double[] max = new double[]{size.dimension(0) - 1L, size.dimension(1) - 1L, size.dimension(2) - 1L};
            ViewRegistration r = spimData.getViewRegistrations().getViewRegistration(viewId);
            r.updateModel();
            FinalRealInterval interval = r.getModel().estimateBounds((RealInterval)new FinalRealInterval(min, max));
            for (int d = 0; d < minBB.length; ++d) {
                minBB[d] = Math.min(minBB[d], interval.realMin(d));
                maxBB[d] = Math.max(maxBB[d], interval.realMax(d));
            }
        }
        return changed;
    }

    protected static long numPixels(long[] min, long[] max, int downsampling) {
        long numpixels = 1L;
        for (int d = 0; d < min.length; ++d) {
            numpixels *= (max[d] - min[d]) / (long)downsampling;
        }
        return numpixels;
    }

    private static final void setNFIndex(GenericDialog gd, int nfIndex) {
        try {
            Class<Object> clazz = null;
            boolean found = false;
            do {
                if ((clazz = clazz == null ? gd.getClass() : clazz.getSuperclass()) == null) continue;
                for (Field field : clazz.getDeclaredFields()) {
                    if (!field.getName().equals("nfIndex")) continue;
                    found = true;
                }
            } while (!found && clazz != null);
            if (!found) {
                System.out.println("Failed to find GenericDialog.nfIndex field. Quiting.");
                return;
            }
            Field nfIndexField = clazz.getDeclaredField("nfIndex");
            nfIndexField.setAccessible(true);
            nfIndexField.setInt(gd, nfIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class ManageListeners {
        final GenericDialog gd;
        final TextField minX;
        final TextField minY;
        final TextField minZ;
        final TextField maxX;
        final TextField maxY;
        final TextField maxZ;
        final TextField downsample;
        final Choice pixelTypeChoice;
        final Choice imgTypeChoice;
        final Label label1;
        final Label label2;
        final Fusion fusion;
        final boolean supportsDownsampling;
        final boolean supports16bit;
        final long[] min = new long[3];
        final long[] max = new long[3];

        public ManageListeners(GenericDialog gd, Vector<?> tf, Vector<?> choices, Label label1, Label label2, Fusion fusion, ImgExport imgExport, boolean supportsDownsampling, boolean supports16bit) {
            this.gd = gd;
            this.minX = (TextField)tf.get(0);
            this.minY = (TextField)tf.get(1);
            this.minZ = (TextField)tf.get(2);
            this.maxX = (TextField)tf.get(3);
            this.maxY = (TextField)tf.get(4);
            this.maxZ = (TextField)tf.get(5);
            if (supports16bit) {
                this.pixelTypeChoice = (Choice)choices.get(0);
                this.imgTypeChoice = fusion != null && imgExport != null ? (Choice)choices.get(1) : null;
            } else {
                this.pixelTypeChoice = null;
                this.imgTypeChoice = fusion != null && imgExport != null ? (Choice)choices.get(0) : null;
            }
            this.downsample = supportsDownsampling ? (TextField)tf.get(6) : null;
            this.label1 = label1;
            this.label2 = label2;
            this.supportsDownsampling = supportsDownsampling;
            this.supports16bit = supports16bit;
            this.fusion = fusion;
            this.addListeners(imgExport);
        }

        protected void addListeners(ImgExport imgExport) {
            this.minX.addTextListener(new TextListener(){

                @Override
                public void textValueChanged(TextEvent e) {
                    ManageListeners.this.update();
                }
            });
            this.minY.addTextListener(new TextListener(){

                @Override
                public void textValueChanged(TextEvent e) {
                    ManageListeners.this.update();
                }
            });
            this.minZ.addTextListener(new TextListener(){

                @Override
                public void textValueChanged(TextEvent e) {
                    ManageListeners.this.update();
                }
            });
            this.maxX.addTextListener(new TextListener(){

                @Override
                public void textValueChanged(TextEvent e) {
                    ManageListeners.this.update();
                }
            });
            this.maxY.addTextListener(new TextListener(){

                @Override
                public void textValueChanged(TextEvent e) {
                    ManageListeners.this.update();
                }
            });
            this.maxZ.addTextListener(new TextListener(){

                @Override
                public void textValueChanged(TextEvent e) {
                    ManageListeners.this.update();
                }
            });
            if (this.fusion != null && imgExport != null) {
                this.imgTypeChoice.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        ManageListeners.this.update();
                    }
                });
            }
            if (this.supportsDownsampling) {
                this.downsample.addTextListener(new TextListener(){

                    @Override
                    public void textValueChanged(TextEvent e) {
                        ManageListeners.this.update();
                    }
                });
            }
            if (this.supports16bit) {
                this.pixelTypeChoice.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        ManageListeners.this.update();
                    }
                });
            }
        }

        public void update() {
            try {
                this.min[0] = Long.parseLong(this.minX.getText());
                this.min[1] = Long.parseLong(this.minY.getText());
                this.min[2] = Long.parseLong(this.minZ.getText());
                this.max[0] = Long.parseLong(this.maxX.getText());
                this.max[1] = Long.parseLong(this.maxY.getText());
                this.max[2] = Long.parseLong(this.maxZ.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            BoundingBoxGUI.this.downsampling = this.supportsDownsampling ? Integer.parseInt(this.downsample.getText()) : 1;
            BoundingBoxGUI.this.pixelType = this.supports16bit ? this.pixelTypeChoice.getSelectedIndex() : 0;
            BoundingBoxGUI.this.imgtype = this.imgTypeChoice != null ? this.imgTypeChoice.getSelectedIndex() : 1;
            long numPixels = BoundingBoxGUI.numPixels(this.min, this.max, BoundingBoxGUI.this.downsampling);
            int bytePerPixel = BoundingBoxGUI.this.pixelType == 1 ? 2 : 4;
            long megabytes = numPixels * (long)bytePerPixel / 0x100000L;
            if (numPixels > Integer.MAX_VALUE && BoundingBoxGUI.this.imgtype == 0) {
                this.label1.setText(megabytes + " MB is too large for ArrayImg!");
                this.label1.setForeground(GUIHelper.error);
            } else {
                if (this.fusion == null) {
                    this.label1.setText("Fused image: " + megabytes + " MB");
                } else {
                    this.label1.setText("Fused image: " + megabytes + " MB, required total memory ~" + this.fusion.totalRAM(megabytes, bytePerPixel) + " MB");
                }
                this.label1.setForeground(GUIHelper.good);
            }
            this.label2.setText("Dimensions: " + (this.max[0] - this.min[0] + 1L) / (long)BoundingBoxGUI.this.downsampling + " x " + (this.max[1] - this.min[1] + 1L) / (long)BoundingBoxGUI.this.downsampling + " x " + (this.max[2] - this.min[2] + 1L) / (long)BoundingBoxGUI.this.downsampling + " pixels @ " + pixelTypes[BoundingBoxGUI.this.pixelType]);
        }
    }
}

