/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.export;

import bdv.export.ExportMipmapInfo;
import bdv.export.ProgressWriter;
import bdv.export.SubTaskProgressWriter;
import bdv.export.WriteSequenceToHdf5;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.hdf5.Partition;
import bdv.spimdata.tools.MergePartitionList;
import ij.gui.GenericDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewTransformAffine;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.util.Pair;
import net.imglib2.util.Util;
import spim.fiji.plugin.resave.Generic_Resave_HDF5;
import spim.fiji.plugin.resave.ProgressWriterIJ;
import spim.fiji.plugin.resave.Resave_HDF5;
import spim.fiji.spimdata.SpimData2;
import spim.process.fusion.boundingbox.BoundingBoxGUI;
import spim.process.fusion.export.AppendSpimData2;
import spim.process.fusion.export.ExportSpimData2HDF5;
import spim.process.fusion.export.ImgExport;

public class AppendSpimData2HDF5
implements ImgExport {
    public static String defaultPath = null;
    private List<TimePoint> newTimepoints;
    private List<ViewSetup> newViewSetups;
    private Generic_Resave_HDF5.Parameters params;
    private SpimData2 spimData;
    private SpimData2 fusionOnlySpimData;
    private Map<Integer, ExportMipmapInfo> perSetupExportMipmapInfo;
    private HashMap<ViewId, Partition> viewIdToPartition;
    private final ProgressWriter progressWriter = new ProgressWriterIJ();

    @Override
    public boolean finish() {
        return true;
    }

    @Override
    public void setXMLData(List<TimePoint> newTimepoints, List<ViewSetup> newViewSetups) {
        this.newTimepoints = newTimepoints;
        this.newViewSetups = newViewSetups;
    }

    @Override
    public boolean queryParameters(SpimData2 spimData, boolean is16bit) {
        System.out.println("queryParameters()");
        if (this.newTimepoints == null || this.newViewSetups == null) {
            IOFunctions.println("new timepoints and new viewsetup list not set yet ... cannot continue");
            return false;
        }
        Hdf5ImageLoader il = (Hdf5ImageLoader)((SequenceDescription)spimData.getSequenceDescription()).getImgLoader();
        this.perSetupExportMipmapInfo = Resave_HDF5.proposeMipmaps(this.newViewSetups);
        String fn = il.getHdf5File().getAbsolutePath();
        if (fn.endsWith(".h5")) {
            fn = fn.substring(0, fn.length() - ".h5".length());
        }
        String fusionHdfFilename = "";
        String fusionXmlFilename = "";
        int i = 0;
        while (true) {
            fusionHdfFilename = String.format("%s-f%d.h5", fn, i);
            fusionXmlFilename = String.format("%s-f%d.xml", fn, i);
            if (!new File(fusionHdfFilename).exists() && !new File(fusionXmlFilename).exists()) break;
            ++i;
        }
        int firstviewSetupId = this.newViewSetups.get(0).getId();
        this.params = Generic_Resave_HDF5.getParameters(this.perSetupExportMipmapInfo.get(firstviewSetupId), false, this.getDescription(), is16bit);
        if (this.params == null) {
            System.out.println("abort ");
            return false;
        }
        this.params.setHDF5File(new File(fusionHdfFilename));
        this.params.setSeqFile(new File(fusionXmlFilename));
        Pair<SpimData2, HashMap<ViewId, Partition>> init = ExportSpimData2HDF5.initSpimData(this.newTimepoints, this.newViewSetups, this.params, this.perSetupExportMipmapInfo);
        this.fusionOnlySpimData = (SpimData2)((Object)init.getA());
        this.viewIdToPartition = (HashMap)init.getB();
        this.perSetupExportMipmapInfo.putAll(MergePartitionList.getHdf5PerSetupExportMipmapInfos((AbstractSequenceDescription)spimData.getSequenceDescription()));
        this.spimData = spimData;
        AppendSpimData2.appendSpimData2(spimData, this.newTimepoints, this.newViewSetups);
        ArrayList mergedPartitions = MergePartitionList.getMergedHdf5PartitionList((AbstractSequenceDescription)spimData.getSequenceDescription(), (AbstractSequenceDescription)this.fusionOnlySpimData.getSequenceDescription());
        String mergedHdfFilename = "";
        int i2 = 0;
        while (new File(mergedHdfFilename = String.format("%s-m%d.h5", fn, i2)).exists()) {
            ++i2;
        }
        SequenceDescription seq = (SequenceDescription)spimData.getSequenceDescription();
        Hdf5ImageLoader newLoader = new Hdf5ImageLoader(new File(mergedHdfFilename), mergedPartitions, (AbstractSequenceDescription)seq, false);
        seq.setImgLoader((BasicImgLoader)newLoader);
        WriteSequenceToHdf5.writeHdf5PartitionLinkFile((AbstractSequenceDescription)spimData.getSequenceDescription(), this.perSetupExportMipmapInfo);
        return true;
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> boolean exportImage(RandomAccessibleInterval<T> img, BoundingBoxGUI bb, TimePoint tp, ViewSetup vs) {
        System.out.println("exportImage1()");
        return this.exportImage(img, bb, tp, vs, Double.NaN, Double.NaN);
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> boolean exportImage(RandomAccessibleInterval<T> img, BoundingBoxGUI bb, TimePoint tp, ViewSetup vs, double min, double max) {
        System.out.println("exportImage2()");
        Object ushortimg = !UnsignedShortType.class.isInstance(Util.getTypeFromInterval(img)) ? ExportSpimData2HDF5.convert(img, this.params) : img;
        Partition partition = this.viewIdToPartition.get(new ViewId(tp.getId(), vs.getId()));
        ExportMipmapInfo mipmapInfo = this.perSetupExportMipmapInfo.get(vs.getId());
        boolean writeMipmapInfo = true;
        boolean deflate = this.params.getDeflate();
        SubTaskProgressWriter progressWriter = new SubTaskProgressWriter(this.progressWriter, 0.0, 1.0);
        int numThreads = Math.max(1, Runtime.getRuntime().availableProcessors() - 2);
        WriteSequenceToHdf5.writeViewToHdf5PartitionFile(ushortimg, (Partition)partition, (int)tp.getId(), (int)vs.getId(), (ExportMipmapInfo)mipmapInfo, (boolean)true, (boolean)deflate, null, null, (int)numThreads, (ProgressWriter)progressWriter);
        ViewRegistration vr = this.spimData.getViewRegistrations().getViewRegistration(new ViewId(tp.getId(), vs.getId()));
        double scale = bb.getDownSampling();
        AffineTransform3D m = new AffineTransform3D();
        m.set(scale, 0.0, 0.0, (double)bb.min(0), 0.0, scale, 0.0, (double)bb.min(1), 0.0, 0.0, scale, (double)bb.min(2));
        ViewTransformAffine vt = new ViewTransformAffine("fusion bounding box", m);
        vr.getTransformList().clear();
        vr.getTransformList().add(vt);
        return true;
    }

    @Override
    public void queryAdditionalParameters(GenericDialog gd, SpimData2 spimData) {
    }

    @Override
    public boolean parseAdditionalParameters(GenericDialog gd, SpimData2 spimData) {
        return true;
    }

    @Override
    public ImgExport newInstance() {
        BoundingBoxGUI.defaultPixelType = 1;
        return new AppendSpimData2HDF5();
    }

    @Override
    public String getDescription() {
        return "Append to current XML Project (HDF5)";
    }
}

