/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.weightedavg;

import ij.gui.GenericDialog;
import java.awt.Choice;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.RandomAccessible;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NearestNeighborInterpolatorFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import spim.fiji.plugin.Apply_Transformation;
import spim.fiji.plugin.fusion.Fusion;
import spim.fiji.spimdata.SpimData2;
import spim.process.fusion.FusionHelper;
import spim.process.fusion.boundingbox.BoundingBoxGUI;
import spim.process.fusion.export.FixedNameImgTitler;
import spim.process.fusion.export.ImgExport;
import spim.process.fusion.export.ImgExportTitle;
import spim.process.fusion.weightedavg.ProcessFusion;
import spim.process.fusion.weightedavg.ProcessIndependent;
import spim.process.fusion.weightedavg.ProcessParalell;
import spim.process.fusion.weightedavg.ProcessSequential;

public class WeightedAverageFusion
extends Fusion {
    final WeightedAvgFusionType type;
    public static int defaultNumParalellViewsIndex = 0;
    protected int numParalellViews = 1;
    protected Choice sequentialViews = null;

    public WeightedAverageFusion(SpimData2 spimData, List<ViewId> viewIdsToProcess, WeightedAvgFusionType type) {
        super(spimData, viewIdsToProcess);
        this.type = type;
    }

    public WeightedAvgFusionType getFusionType() {
        return this.type;
    }

    public <T extends RealType<T>> InterpolatorFactory<T, RandomAccessible<T>> getInterpolatorFactory(T type) {
        if (this.getInterpolation() == 0) {
            return new NearestNeighborInterpolatorFactory();
        }
        return new NLinearInterpolatorFactory();
    }

    @Override
    public boolean fuseData(BoundingBoxGUI bb, ImgExport exporter) {
        FixedNameImgTitler titler = new FixedNameImgTitler("");
        if (exporter instanceof ImgExportTitle) {
            ((ImgExportTitle)exporter).setImgTitler(titler);
        }
        ProcessFusion process = this.getFusionType() == WeightedAvgFusionType.FUSEDATA && this.numParalellViews == 0 ? new ProcessParalell(this.spimData, this.viewIdsToProcess, bb, this.useBlending, this.useContentBased) : (this.getFusionType() == WeightedAvgFusionType.FUSEDATA ? new ProcessSequential(this.spimData, this.viewIdsToProcess, bb, this.useBlending, this.useContentBased, this.numParalellViews) : new ProcessIndependent(this.spimData, (List<ViewId>)this.viewIdsToProcess, bb, exporter, this.newViewsetups));
        for (TimePoint t : this.timepointsToProcess) {
            for (Channel c : this.channelsToProcess) {
                ArrayList<Angle> anglesToProcess = SpimData2.getAllAnglesForChannelTimepointSorted(this.spimData, this.viewIdsToProcess, c, t);
                ArrayList<Illumination> illumsToProcess = SpimData2.getAllIlluminationsForChannelTimepointSorted(this.spimData, this.viewIdsToProcess, c, t);
                titler.setTitle("TP" + t.getName() + "_Ch" + c.getName() + FusionHelper.getIllumName(illumsToProcess) + FusionHelper.getAngleName(anglesToProcess));
                if (bb.getPixelType() == 0) {
                    exporter.exportImage(process.fuseStack(new FloatType(), this.getInterpolatorFactory(new FloatType()), t, c), bb, t, (ViewSetup)this.newViewsetups.get(SpimData2.getViewSetup(((SequenceDescription)this.spimData.getSequenceDescription()).getViewSetupsOrdered(), c, (Angle)anglesToProcess.get(0), (Illumination)illumsToProcess.get(0))));
                    continue;
                }
                exporter.exportImage(process.fuseStack(new UnsignedShortType(), this.getInterpolatorFactory(new UnsignedShortType()), t, c), bb, t, (ViewSetup)this.newViewsetups.get(SpimData2.getViewSetup(((SequenceDescription)this.spimData.getSequenceDescription()).getViewSetupsOrdered(), c, (Angle)anglesToProcess.get(0), (Illumination)illumsToProcess.get(0))));
            }
        }
        return true;
    }

    @Override
    public boolean queryParameters() {
        return true;
    }

    @Override
    public WeightedAverageFusion newInstance(SpimData2 spimData, List<ViewId> viewIdsToProcess) {
        return new WeightedAverageFusion(spimData, viewIdsToProcess, this.type);
    }

    @Override
    public String getDescription() {
        if (this.type == WeightedAvgFusionType.FUSEDATA) {
            return "Weighted-average fusion";
        }
        return "No fusion, create individual registered images";
    }

    @Override
    public boolean supports16BitUnsigned() {
        return true;
    }

    @Override
    public boolean supportsDownsampling() {
        return true;
    }

    @Override
    public boolean compressBoundingBoxDialog() {
        return false;
    }

    @Override
    public void queryAdditionalParameters(GenericDialog gd) {
        if (Fusion.defaultInterpolation >= Fusion.interpolationTypes.length) {
            Fusion.defaultInterpolation = Fusion.interpolationTypes.length - 1;
        }
        if (this.getFusionType() == WeightedAvgFusionType.FUSEDATA) {
            int maxViews = 0;
            for (TimePoint t : this.timepointsToProcess) {
                for (Channel c : this.channelsToProcess) {
                    maxViews = Math.max(maxViews, FusionHelper.assembleInputData(this.spimData, t, c, this.viewIdsToProcess).size());
                }
            }
            String[] views = new String[maxViews];
            views[0] = "All";
            for (int i = 1; i < views.length; ++i) {
                views[i] = "" + i;
            }
            if (defaultNumParalellViewsIndex < 0 || defaultNumParalellViewsIndex >= views.length) {
                defaultNumParalellViewsIndex = 0;
            }
            gd.addChoice("Process_views_in_paralell", views, views[defaultNumParalellViewsIndex]);
            this.sequentialViews = (Choice)gd.getChoices().lastElement();
        }
        if (this.getFusionType() == WeightedAvgFusionType.FUSEDATA) {
            gd.addCheckbox("Blend images smoothly", Fusion.defaultUseBlending);
            gd.addCheckbox("Content-based fusion", Fusion.defaultUseContentBased);
        }
        gd.addChoice("Interpolation", Fusion.interpolationTypes, Fusion.interpolationTypes[Fusion.defaultInterpolation]);
    }

    @Override
    public boolean parseAdditionalParameters(GenericDialog gd) {
        if (this.getFusionType() == WeightedAvgFusionType.FUSEDATA) {
            this.numParalellViews = defaultNumParalellViewsIndex = gd.getNextChoiceIndex();
            this.useBlending = Fusion.defaultUseBlending = gd.getNextBoolean();
            this.useContentBased = Fusion.defaultUseContentBased = gd.getNextBoolean();
        } else {
            this.useContentBased = false;
            this.useBlending = false;
        }
        this.interpolation = Fusion.defaultInterpolation = gd.getNextChoiceIndex();
        return true;
    }

    @Override
    public long totalRAM(long fusedSizeMB, int bytePerPixel) {
        if (this.type == WeightedAvgFusionType.FUSEDATA && this.sequentialViews.getSelectedIndex() == 0) {
            return fusedSizeMB + (long)this.getMaxNumViewsPerTimepoint() * (this.avgPixels / 0x100000L) * (long)bytePerPixel;
        }
        if (this.type == WeightedAvgFusionType.FUSEDATA) {
            return fusedSizeMB + (long)this.sequentialViews.getSelectedIndex() * (this.avgPixels / 0x100000L) * (long)bytePerPixel;
        }
        return fusedSizeMB + this.avgPixels / 0x100000L * (long)bytePerPixel;
    }

    @Override
    protected Map<ViewSetup, ViewSetup> createNewViewSetups(BoundingBoxGUI bb) {
        if (this.type == WeightedAvgFusionType.FUSEDATA) {
            return WeightedAverageFusion.assembleNewViewSetupsFusion(this.spimData, this.viewIdsToProcess, bb, "Fused", "Fused");
        }
        return WeightedAverageFusion.assembleNewViewSetupsSequential(this.spimData, this.viewIdsToProcess, bb);
    }

    public static Map<ViewSetup, ViewSetup> assembleNewViewSetupsFusion(SpimData2 spimData, List<ViewId> viewIdsToProcess, BoundingBoxGUI bb, String newAngleName, String newIlluminationName) {
        HashMap<ViewSetup, ViewSetup> map = new HashMap<ViewSetup, ViewSetup>();
        int maxViewSetupIndex = -1;
        int maxAngleIndex = -1;
        int maxIllumIndex = -1;
        for (ViewSetup v : ((SequenceDescription)spimData.getSequenceDescription()).getViewSetups().values()) {
            maxViewSetupIndex = Math.max(maxViewSetupIndex, v.getId());
        }
        for (Angle a : ((SequenceDescription)spimData.getSequenceDescription()).getAllAngles().values()) {
            maxAngleIndex = Math.max(maxAngleIndex, a.getId());
        }
        for (Illumination i : ((SequenceDescription)spimData.getSequenceDescription()).getAllIlluminations().values()) {
            maxIllumIndex = Math.max(maxIllumIndex, i.getId());
        }
        Angle newAngle = new Angle(maxAngleIndex + 1, newAngleName + "_" + (maxAngleIndex + 1));
        Illumination newIllum = new Illumination(maxIllumIndex + 1, newIlluminationName + "_" + (maxIllumIndex + 1));
        String unit = ((ViewSetup)((SequenceDescription)spimData.getSequenceDescription()).getViewSetupsOrdered().get(0)).getVoxelSize().unit();
        double minResolution = Apply_Transformation.assembleAllMetaData((SequenceDescription)spimData.getSequenceDescription(), ((SequenceDescription)spimData.getSequenceDescription()).getViewDescriptions().values()) * (double)bb.getDownSampling();
        for (Channel channel : SpimData2.getAllChannelsSorted(spimData, viewIdsToProcess)) {
            ViewSetup newSetup = new ViewSetup(++maxViewSetupIndex, null, (Dimensions)new FinalDimensions(bb.getDimensions()), (VoxelDimensions)new FinalVoxelDimensions(unit, new double[]{minResolution, minResolution, minResolution}), channel, newAngle, newIllum);
            for (ViewId viewId : viewIdsToProcess) {
                ViewDescription oldVD = ((SequenceDescription)spimData.getSequenceDescription()).getViewDescription(viewId);
                ViewSetup oldSetup = (ViewSetup)oldVD.getViewSetup();
                if (!oldVD.isPresent() || oldSetup.getChannel().getId() != channel.getId()) continue;
                map.put(oldSetup, newSetup);
            }
        }
        return map;
    }

    public static Map<ViewSetup, ViewSetup> assembleNewViewSetupsSequential(SpimData2 spimData, List<ViewId> viewIdsToProcess, BoundingBoxGUI bb) {
        int i;
        HashMap<ViewSetup, ViewSetup> map = new HashMap<ViewSetup, ViewSetup>();
        int maxViewSetupIndex = -1;
        int maxAngleIndex = -1;
        int maxIllumIndex = -1;
        for (ViewSetup v : ((SequenceDescription)spimData.getSequenceDescription()).getViewSetups().values()) {
            maxViewSetupIndex = Math.max(maxViewSetupIndex, v.getId());
        }
        for (Angle a : ((SequenceDescription)spimData.getSequenceDescription()).getAllAngles().values()) {
            maxAngleIndex = Math.max(maxAngleIndex, a.getId());
        }
        for (Illumination i2 : ((SequenceDescription)spimData.getSequenceDescription()).getAllIlluminations().values()) {
            maxIllumIndex = Math.max(maxIllumIndex, i2.getId());
        }
        String unit = ((ViewSetup)((SequenceDescription)spimData.getSequenceDescription()).getViewSetupsOrdered().get(0)).getVoxelSize().unit();
        double minResolution = Apply_Transformation.assembleAllMetaData((SequenceDescription)spimData.getSequenceDescription(), ((SequenceDescription)spimData.getSequenceDescription()).getViewDescriptions().values()) * (double)bb.getDownSampling();
        ArrayList<Angle> oldAngles = SpimData2.getAllAnglesSorted(spimData, viewIdsToProcess);
        ArrayList<Illumination> oldIllums = SpimData2.getAllIlluminationsSorted(spimData, viewIdsToProcess);
        HashMap mapOldToNewAngles = new HashMap();
        HashMap mapOldToNewIlluminations = new HashMap();
        for (i = 0; i < oldAngles.size(); ++i) {
            mapOldToNewAngles.put(oldAngles.get(i), new Angle(maxAngleIndex + i + 1, "Transf_" + ((Angle)oldAngles.get(i)).getName() + "_" + maxAngleIndex + i + 1, ((Angle)oldAngles.get(i)).getRotationAngleDegrees(), ((Angle)oldAngles.get(i)).getRotationAxis()));
        }
        for (i = 0; i < oldIllums.size(); ++i) {
            mapOldToNewIlluminations.put(oldIllums.get(i), new Illumination(maxIllumIndex + i + 1, "Transf_" + ((Illumination)oldIllums.get(i)).getName() + "_" + maxIllumIndex + i + 1));
        }
        for (ViewId viewId : viewIdsToProcess) {
            ViewSetup oldSetup;
            ViewDescription oldVD = ((SequenceDescription)spimData.getSequenceDescription()).getViewDescription(viewId);
            if (!oldVD.isPresent() || map.containsKey(oldSetup = (ViewSetup)oldVD.getViewSetup())) continue;
            Channel channel = oldSetup.getChannel();
            Angle oldAngle = oldSetup.getAngle();
            Illumination oldIllumination = oldSetup.getIllumination();
            Angle newAngle = (Angle)mapOldToNewAngles.get(oldAngle);
            Illumination newIllumination = (Illumination)mapOldToNewIlluminations.get(oldIllumination);
            ViewSetup newSetup = new ViewSetup(++maxViewSetupIndex, null, (Dimensions)new FinalDimensions(bb.getDimensions()), (VoxelDimensions)new FinalVoxelDimensions(unit, new double[]{minResolution, minResolution, minResolution}), channel, newAngle, newIllumination);
            map.put(oldSetup, newSetup);
        }
        return map;
    }

    public static enum WeightedAvgFusionType {
        FUSEDATA,
        INDEPENDENT;

    }
}

