/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.weights;

import ij.ImageJ;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealRandomAccess;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.type.numeric.real.FloatType;

public class BlendingRealRandomAccess
implements RealRandomAccess<FloatType> {
    final Interval interval;
    final int[] min;
    final int[] dimMinus1;
    final float[] l;
    final float[] border;
    final float[] blending;
    final int n;
    final FloatType v;
    private static final double[] lookUp = new double[1001];

    private static final int indexFor(double d) {
        return (int)Math.round(d * 1000.0);
    }

    public BlendingRealRandomAccess(Interval interval, float[] border, float[] blending) {
        this.interval = interval;
        this.n = interval.numDimensions();
        this.l = new float[this.n];
        this.border = border;
        this.blending = blending;
        this.v = new FloatType();
        this.min = new int[this.n];
        this.dimMinus1 = new int[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.min[d] = (int)interval.min(d);
            this.dimMinus1[d] = (int)interval.max(d) - this.min[d];
        }
    }

    public FloatType get() {
        this.v.set(BlendingRealRandomAccess.computeWeight(this.l, this.min, this.dimMinus1, this.border, this.blending, this.n));
        return this.v;
    }

    private static final float computeWeight(float[] location, int[] min, int[] dimMinus1, float[] border, float[] blending, int n) {
        float minDistance = 1.0f;
        for (int d = 0; d < n; ++d) {
            float l = location[d] - (float)min[d];
            float dist = Math.max(0.0f, Math.min(l - border[d], (float)dimMinus1[d] - l - border[d]));
            if (dist == 0.0f) {
                return 0.0f;
            }
            float relDist = dist / blending[d];
            if (!(relDist < 1.0f)) continue;
            minDistance = (float)((double)minDistance * lookUp[BlendingRealRandomAccess.indexFor(relDist)]);
        }
        return minDistance;
    }

    public void localize(float[] position) {
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.l[d];
        }
    }

    public void localize(double[] position) {
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.l[d];
        }
    }

    public float getFloatPosition(int d) {
        return this.l[d];
    }

    public double getDoublePosition(int d) {
        return this.l[d];
    }

    public int numDimensions() {
        return this.n;
    }

    public void move(float distance, int d) {
        int n = d;
        this.l[n] = this.l[n] + distance;
    }

    public void move(double distance, int d) {
        int n = d;
        this.l[n] = (float)((double)this.l[n] + distance);
    }

    public void move(RealLocalizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.l[n] = this.l[n] + localizable.getFloatPosition(d);
        }
    }

    public void move(float[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.l[n] = this.l[n] + distance[d];
        }
    }

    public void move(double[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.l[n] = (float)((double)this.l[n] + distance[d]);
        }
    }

    public void setPosition(RealLocalizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.l[d] = localizable.getFloatPosition(d);
        }
    }

    public void setPosition(float[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.l[d] = position[d];
        }
    }

    public void setPosition(double[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.l[d] = (float)position[d];
        }
    }

    public void setPosition(float position, int d) {
        this.l[d] = position;
    }

    public void setPosition(double position, int d) {
        this.l[d] = (float)position;
    }

    public void fwd(int d) {
        int n = d;
        this.l[n] = this.l[n] + 1.0f;
    }

    public void bck(int d) {
        int n = d;
        this.l[n] = this.l[n] - 1.0f;
    }

    public void move(int distance, int d) {
        int n = d;
        this.l[n] = this.l[n] + (float)distance;
    }

    public void move(long distance, int d) {
        int n = d;
        this.l[n] = this.l[n] + (float)distance;
    }

    public void move(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.l[n] = this.l[n] + localizable.getFloatPosition(d);
        }
    }

    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.l[n] = this.l[n] + (float)distance[d];
        }
    }

    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.l[n] = this.l[n] + (float)distance[d];
        }
    }

    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.l[d] = localizable.getFloatPosition(d);
        }
    }

    public void setPosition(int[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.l[d] = position[d];
        }
    }

    public void setPosition(long[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.l[d] = position[d];
        }
    }

    public void setPosition(int position, int d) {
        this.l[d] = position;
    }

    public void setPosition(long position, int d) {
        this.l[d] = position;
    }

    public RealRandomAccess<FloatType> copy() {
        BlendingRealRandomAccess r = new BlendingRealRandomAccess(this.interval, this.border, this.blending);
        r.setPosition((RealLocalizable)this);
        return r;
    }

    public static void main(String[] args) {
        new ImageJ();
        ArrayImg img = ArrayImgs.floats((long[])new long[]{500L, 500L});
        BlendingRealRandomAccess blend = new BlendingRealRandomAccess((Interval)img, new float[]{100.0f, 0.0f}, new float[]{12.0f, 150.0f});
        Cursor c = img.localizingCursor();
        while (c.hasNext()) {
            c.fwd();
            blend.setPosition((Localizable)c);
            ((FloatType)c.get()).setReal(blend.get().getRealFloat());
        }
        ImageJFunctions.show((RandomAccessibleInterval)img);
    }

    static {
        for (double d = 0.0; d <= 1.0001; d += 0.001) {
            BlendingRealRandomAccess.lookUp[BlendingRealRandomAccess.indexFor((double)d)] = (Math.cos((1.0 - d) * Math.PI) + 1.0) / 2.0;
        }
    }
}

