/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointregistration.optimizationtypes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewId;
import spim.fiji.spimdata.SpimData2;
import spim.process.interestpointregistration.ChannelProcess;
import spim.process.interestpointregistration.MatchPointList;
import spim.process.interestpointregistration.PairwiseMatch;
import spim.process.interestpointregistration.optimizationtypes.GlobalOptimizationSubset;
import spim.process.interestpointregistration.optimizationtypes.GlobalOptimizationType;

public class AllToAllRegistrationWithRange
extends GlobalOptimizationType {
    final int range;

    public AllToAllRegistrationWithRange(SpimData2 spimData, List<ViewId> viewIdsToProcess, List<ChannelProcess> channelsToProcess, int range, boolean considerTimePointsAsUnit) {
        super(spimData, viewIdsToProcess, channelsToProcess, considerTimePointsAsUnit);
        this.range = range;
    }

    @Override
    public List<GlobalOptimizationSubset> assembleAllViewPairs() {
        HashMap<ViewId, MatchPointList> allPointLists = new HashMap<ViewId, MatchPointList>();
        for (TimePoint timepoint : SpimData2.getAllTimePointsSorted(this.spimData, this.viewIdsToProcess)) {
            HashMap<ViewId, MatchPointList> pointLists = this.getInterestPoints(timepoint);
            allPointLists.putAll(pointLists);
        }
        ArrayList views = new ArrayList();
        views.addAll(allPointLists.keySet());
        Collections.sort(views);
        ArrayList<PairwiseMatch> viewPairs = new ArrayList<PairwiseMatch>();
        for (int a = 0; a < views.size() - 1; ++a) {
            for (int b = a + 1; b < views.size(); ++b) {
                ViewId viewIdA = (ViewId)views.get(a);
                ViewId viewIdB = (ViewId)views.get(b);
                if (this.isFixedTile(viewIdA) || this.isFixedTile(viewIdB) || Math.abs(viewIdA.getTimePointId() - viewIdB.getTimePointId()) > this.range) continue;
                MatchPointList listA = (MatchPointList)allPointLists.get(viewIdA);
                MatchPointList listB = (MatchPointList)allPointLists.get(viewIdB);
                if (!AllToAllRegistrationWithRange.isValid(viewIdA, listA) || !AllToAllRegistrationWithRange.isValid(viewIdB, listB) || this.considerTimePointsAsUnit() && viewIdA.getTimePointId() == viewIdB.getTimePointId()) continue;
                viewPairs.add(new PairwiseMatch(viewIdA, viewIdB, listA, listB));
            }
        }
        ArrayList<GlobalOptimizationSubset> list = new ArrayList<GlobalOptimizationSubset>();
        list.add(new GlobalOptimizationSubset(viewPairs, "all-to-all matching with range " + this.range + " over all timepoints"));
        return list;
    }
}

