/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.BoundingLeaf;
import org.jogamp.java3d.BoundingLeafRetained;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.HashKey;
import org.jogamp.java3d.IllegalSceneGraphException;
import org.jogamp.java3d.IllegalSharingException;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.LeafRetained;
import org.jogamp.java3d.SetLiveState;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroupRetained;
import org.jogamp.java3d.VirtualUniverse;

class ClipRetained
extends LeafRetained {
    static final int BOUNDS_CHANGED = 1;
    static final int BOUNDINGLEAF_CHANGED = 2;
    static final int BACKDISTANCE_CHANGED = 4;
    double backDistance = 100.0;
    double backDistanceInVworld;
    Bounds applicationRegion = null;
    BoundingLeafRetained boundingLeaf = null;
    Bounds transformedRegion = null;
    boolean inImmCtx = false;
    static final int targetThreads = 4224;
    boolean isViewScoped = false;

    ClipRetained() {
        this.nodeType = 2;
        this.localBounds = new BoundingBox((Bounds)null);
    }

    final void initBackDistance(double backDistance) {
        this.backDistance = backDistance;
    }

    final void setBackDistance(double backDistance) {
        this.backDistance = backDistance;
        this.sendMessage(4, new Double(backDistance), null);
    }

    final double getBackDistance() {
        return this.backDistance;
    }

    final void initApplicationBounds(Bounds region) {
        this.applicationRegion = region != null ? (Bounds)region.clone() : null;
    }

    final void setApplicationBounds(Bounds region) {
        this.initApplicationBounds(region);
        if (this.boundingLeaf == null) {
            this.sendMessage(1, region != null ? region.clone() : null, null);
        }
    }

    final Bounds getApplicationBounds() {
        return this.applicationRegion != null ? (Bounds)this.applicationRegion.clone() : null;
    }

    void initApplicationBoundingLeaf(BoundingLeaf region) {
        this.boundingLeaf = region != null ? (BoundingLeafRetained)region.retained : null;
    }

    void setApplicationBoundingLeaf(BoundingLeaf region) {
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this);
        }
        if (region != null) {
            this.boundingLeaf = (BoundingLeafRetained)region.retained;
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this);
        } else {
            this.boundingLeaf = null;
        }
        this.sendMessage(2, this.boundingLeaf != null ? this.boundingLeaf.mirrorBoundingLeaf : null, this.applicationRegion != null ? this.applicationRegion.clone() : null);
    }

    BoundingLeaf getApplicationBoundingLeaf() {
        return this.boundingLeaf != null ? (BoundingLeaf)this.boundingLeaf.source : null;
    }

    void setInImmCtx(boolean inCtx) {
        this.inImmCtx = inCtx;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    @Override
    void setLive(SetLiveState s) {
        if (this.inImmCtx) {
            throw new IllegalSharingException(J3dI18N.getString("ClipRetained0"));
        }
        super.doSetLive(s);
        if (this.inBackgroundGroup) {
            throw new IllegalSceneGraphException(J3dI18N.getString("ClipRetained1"));
        }
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("ClipRetained2"));
        }
        this.initMirrorObject();
        if (s.viewScopedNodeList != null && s.viewLists != null) {
            s.viewScopedNodeList.add(this);
            s.scopedNodesViewList.add(s.viewLists.get(0));
        } else {
            s.nodeList.add(this);
        }
        if (s.switchTargets != null && s.switchTargets[0] != null) {
            s.switchTargets[0].addNode(this, 1);
        }
        this.switchState = s.switchStates.get(0);
        if (s.transformTargets != null && s.transformTargets[0] != null) {
            s.transformTargets[0].addNode(this, 1);
            s.notifyThreads |= 0x2000;
        }
        s.notifyThreads |= 0x1080;
        super.markAsLive();
    }

    @Override
    void clearLive(SetLiveState s) {
        super.clearLive(s);
        if (s.viewScopedNodeList != null && s.viewLists != null) {
            s.viewScopedNodeList.add(this);
            s.scopedNodesViewList.add(s.viewLists.get(0));
        } else {
            s.nodeList.add(this);
        }
        if (s.transformTargets != null && s.transformTargets[0] != null) {
            s.transformTargets[0].addNode(this, 1);
            s.notifyThreads |= 0x2000;
        }
        s.notifyThreads |= 0x1080;
        if (s.switchTargets != null && s.switchTargets[0] != null) {
            s.switchTargets[0].addNode(this, 1);
        }
    }

    void initMirrorObject() {
        Transform3D lastLocalToVworld = this.getLastLocalToVworld();
        if (this.boundingLeaf != null) {
            this.transformedRegion = this.boundingLeaf.mirrorBoundingLeaf.transformedRegion;
        } else if (this.applicationRegion != null) {
            this.transformedRegion = (Bounds)this.applicationRegion.clone();
            this.transformedRegion.transform(this.applicationRegion, lastLocalToVworld);
        } else {
            this.transformedRegion = null;
        }
        this.backDistanceInVworld = this.backDistance * lastLocalToVworld.getDistanceScale();
    }

    void updateImmediateMirrorObject(Object[] objs) {
        int component = (Integer)objs[1];
        Transform3D currentLocalToVworld = this.getCurrentLocalToVworld();
        if ((component & 1) != 0) {
            if (objs[2] != null) {
                this.transformedRegion = ((Bounds)objs[2]).copy(this.transformedRegion);
                this.transformedRegion.transform(this.transformedRegion, currentLocalToVworld);
            } else {
                this.transformedRegion = null;
            }
        } else if ((component & 2) != 0) {
            if (objs[2] != null) {
                this.transformedRegion = ((BoundingLeafRetained)objs[2]).transformedRegion;
            } else {
                Bounds appRegion = (Bounds)objs[3];
                if (appRegion != null) {
                    this.transformedRegion = appRegion.copy(this.transformedRegion);
                    this.transformedRegion.transform(appRegion, currentLocalToVworld);
                } else {
                    this.transformedRegion = null;
                }
            }
        } else if ((component & 4) != 0) {
            this.backDistanceInVworld = (Double)objs[2] * currentLocalToVworld.getDistanceScale();
        }
    }

    @Override
    void updateBoundingLeaf() {
        if (this.boundingLeaf != null && this.boundingLeaf.mirrorBoundingLeaf.switchState.currentSwitchOn) {
            this.transformedRegion = this.boundingLeaf.mirrorBoundingLeaf.transformedRegion;
        } else if (this.applicationRegion != null) {
            this.transformedRegion = this.applicationRegion.copy(this.transformedRegion);
            this.transformedRegion.transform(this.applicationRegion, this.getCurrentLocalToVworld());
        } else {
            this.transformedRegion = null;
        }
    }

    void updateImmediateTransformChange() {
        if (this.boundingLeaf == null && this.applicationRegion != null) {
            this.transformedRegion = (Bounds)this.applicationRegion.clone();
            this.transformedRegion.transform(this.applicationRegion, this.getCurrentLocalToVworld());
        }
    }

    final void sendMessage(int attrMask, Object attr, Object attr2) {
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 4224;
        createMessage.type = 21;
        createMessage.universe = this.universe;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = attr;
        createMessage.args[3] = attr2;
        VirtualUniverse.mc.processMessage(createMessage);
    }

    @Override
    void mergeTransform(TransformGroupRetained xform) {
        super.mergeTransform(xform);
        if (this.applicationRegion != null) {
            this.applicationRegion.transform(xform.transform);
        }
    }

    @Override
    void getMirrorObjects(ArrayList leafList, HashKey key) {
        leafList.add(this);
    }
}

