/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.transform;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.ij.TransformMeshMapping;
import mpicbg.models.AffineModel2D;
import mpicbg.models.PointMatch;
import mpicbg.models.TransformMesh;
import mpicbg.util.Util;

public class TransformMeshMappingWithMasks<T extends TransformMesh>
extends TransformMeshMapping<T> {
    public TransformMeshMappingWithMasks(T t) {
        super(t);
    }

    protected static final void mapTriangle(TransformMesh m, AffineModel2D ai, ImageProcessor source, ImageProcessor target, ByteProcessor targetOutside) {
        int w = target.getWidth() - 1;
        int h = target.getHeight() - 1;
        ArrayList pm = (ArrayList)m.getAV().get(ai);
        double[] min = new double[2];
        double[] max = new double[2];
        TransformMeshMappingWithMasks.calculateBoundingBox((ArrayList)pm, (double[])min, (double[])max);
        int minX = Math.max(0, Util.roundPos((double)min[0]));
        int minY = Math.max(0, Util.roundPos((double)min[1]));
        int maxX = Math.min(w, Util.roundPos((double)max[0]));
        int maxY = Math.min(h, Util.roundPos((double)max[1]));
        double[] a = ((PointMatch)pm.get(0)).getP2().getW();
        double ax = a[0];
        double ay = a[1];
        double[] b = ((PointMatch)pm.get(1)).getP2().getW();
        double bx = b[0];
        double by = b[1];
        double[] c = ((PointMatch)pm.get(2)).getP2().getW();
        double cx = c[0];
        double cy = c[1];
        double[] t = new double[2];
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                if (!TransformMeshMappingWithMasks.isInTriangle((double)ax, (double)ay, (double)bx, (double)by, (double)cx, (double)cy, (double)x, (double)y)) continue;
                t[0] = x;
                t[1] = y;
                try {
                    ai.applyInverseInPlace(t);
                }
                catch (Exception e) {
                    continue;
                }
                target.set(x, y, source.getPixel((int)(t[0] + 0.5), (int)(t[1] + 0.5)));
                targetOutside.set(x, y, 255);
            }
        }
    }

    protected static final void mapTriangleInterpolated(TransformMesh m, AffineModel2D ai, ImageProcessor source, ImageProcessor target, ByteProcessor targetOutside) {
        int w = target.getWidth() - 1;
        int h = target.getHeight() - 1;
        ArrayList pm = (ArrayList)m.getAV().get(ai);
        double[] min = new double[2];
        double[] max = new double[2];
        TransformMeshMappingWithMasks.calculateBoundingBox((ArrayList)pm, (double[])min, (double[])max);
        int minX = Math.max(0, Util.roundPos((double)min[0]));
        int minY = Math.max(0, Util.roundPos((double)min[1]));
        int maxX = Math.min(w, Util.roundPos((double)max[0]));
        int maxY = Math.min(h, Util.roundPos((double)max[1]));
        double[] a = ((PointMatch)pm.get(0)).getP2().getW();
        double ax = a[0];
        double ay = a[1];
        double[] b = ((PointMatch)pm.get(1)).getP2().getW();
        double bx = b[0];
        double by = b[1];
        double[] c = ((PointMatch)pm.get(2)).getP2().getW();
        double cx = c[0];
        double cy = c[1];
        double[] t = new double[2];
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                if (!TransformMeshMappingWithMasks.isInTriangle((double)ax, (double)ay, (double)bx, (double)by, (double)cx, (double)cy, (double)x, (double)y)) continue;
                t[0] = x;
                t[1] = y;
                try {
                    ai.applyInverseInPlace(t);
                }
                catch (Exception e) {
                    continue;
                }
                target.set(x, y, source.getPixelInterpolated(t[0], t[1]));
                targetOutside.set(x, y, 255);
            }
        }
    }

    protected static final void mapTriangle(TransformMesh m, AffineModel2D ai, ImageProcessor source, ImageProcessor sourceMask, ImageProcessor target, ImageProcessor targetMask, ByteProcessor targetOutside) {
        int w = target.getWidth() - 1;
        int h = target.getHeight() - 1;
        ArrayList pm = (ArrayList)m.getAV().get(ai);
        double[] min = new double[2];
        double[] max = new double[2];
        TransformMeshMappingWithMasks.calculateBoundingBox((ArrayList)pm, (double[])min, (double[])max);
        int minX = Math.max(0, Util.roundPos((double)min[0]));
        int minY = Math.max(0, Util.roundPos((double)min[1]));
        int maxX = Math.min(w, Util.roundPos((double)max[0]));
        int maxY = Math.min(h, Util.roundPos((double)max[1]));
        double[] a = ((PointMatch)pm.get(0)).getP2().getW();
        double ax = a[0];
        double ay = a[1];
        double[] b = ((PointMatch)pm.get(1)).getP2().getW();
        double bx = b[0];
        double by = b[1];
        double[] c = ((PointMatch)pm.get(2)).getP2().getW();
        double cx = c[0];
        double cy = c[1];
        double[] t = new double[2];
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                if (!TransformMeshMappingWithMasks.isInTriangle((double)ax, (double)ay, (double)bx, (double)by, (double)cx, (double)cy, (double)x, (double)y)) continue;
                t[0] = x;
                t[1] = y;
                try {
                    ai.applyInverseInPlace(t);
                }
                catch (Exception e) {
                    continue;
                }
                target.set(x, y, source.getPixel((int)(t[0] + 0.5), (int)(t[1] + 0.5)));
                targetOutside.set(x, y, 255);
                targetMask.set(x, y, sourceMask.getPixel((int)(t[0] + 0.5), (int)(t[1] + 0.5)));
            }
        }
    }

    protected static final void mapTriangleInterpolated(TransformMesh m, AffineModel2D ai, ImageProcessor source, ImageProcessor sourceMask, ImageProcessor target, ImageProcessor targetMask, ByteProcessor targetOutside) {
        int w = target.getWidth() - 1;
        int h = target.getHeight() - 1;
        ArrayList pm = (ArrayList)m.getAV().get(ai);
        double[] min = new double[2];
        double[] max = new double[2];
        TransformMeshMappingWithMasks.calculateBoundingBox((ArrayList)pm, (double[])min, (double[])max);
        int minX = Math.max(0, Util.roundPos((double)min[0]));
        int minY = Math.max(0, Util.roundPos((double)min[1]));
        int maxX = Math.min(w, Util.roundPos((double)max[0]));
        int maxY = Math.min(h, Util.roundPos((double)max[1]));
        double[] a = ((PointMatch)pm.get(0)).getP2().getW();
        double ax = a[0];
        double ay = a[1];
        double[] b = ((PointMatch)pm.get(1)).getP2().getW();
        double bx = b[0];
        double by = b[1];
        double[] c = ((PointMatch)pm.get(2)).getP2().getW();
        double cx = c[0];
        double cy = c[1];
        double[] t = new double[2];
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                if (!TransformMeshMappingWithMasks.isInTriangle((double)ax, (double)ay, (double)bx, (double)by, (double)cx, (double)cy, (double)x, (double)y)) continue;
                t[0] = x;
                t[1] = y;
                try {
                    ai.applyInverseInPlace(t);
                }
                catch (Exception e) {
                    continue;
                }
                target.set(x, y, source.getPixelInterpolated(t[0], t[1]));
                targetOutside.set(x, y, 255);
                targetMask.set(x, y, sourceMask.getPixelInterpolated(t[0], t[1]));
            }
        }
    }

    protected static final void mapShortAlphaTriangle(TransformMesh m, AffineModel2D ai, ShortProcessor source, ByteProcessor alpha, ShortProcessor target) {
        int w = target.getWidth() - 1;
        int h = target.getHeight() - 1;
        ArrayList pm = (ArrayList)m.getAV().get(ai);
        double[] min = new double[2];
        double[] max = new double[2];
        TransformMeshMappingWithMasks.calculateBoundingBox((ArrayList)pm, (double[])min, (double[])max);
        int minX = Math.max(0, Util.roundPos((double)min[0]));
        int minY = Math.max(0, Util.roundPos((double)min[1]));
        int maxX = Math.min(w, Util.roundPos((double)max[0]));
        int maxY = Math.min(h, Util.roundPos((double)max[1]));
        double[] a = ((PointMatch)pm.get(0)).getP2().getW();
        double ax = a[0];
        double ay = a[1];
        double[] b = ((PointMatch)pm.get(1)).getP2().getW();
        double bx = b[0];
        double by = b[1];
        double[] c = ((PointMatch)pm.get(2)).getP2().getW();
        double cx = c[0];
        double cy = c[1];
        double[] t = new double[2];
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                if (!TransformMeshMappingWithMasks.isInTriangle((double)ax, (double)ay, (double)bx, (double)by, (double)cx, (double)cy, (double)x, (double)y)) continue;
                t[0] = x;
                t[1] = y;
                try {
                    ai.applyInverseInPlace(t);
                }
                catch (Exception e) {
                    continue;
                }
                int is = source.getPixelInterpolated(t[0], t[1]);
                int it = target.get(x, y);
                double f = (double)alpha.getPixelInterpolated(t[0], t[1]) / 255.0;
                double v = (double)it + f * (double)(is - it);
                target.set(x, y, (int)Math.max(0L, Math.min(65535L, Math.round(v))));
            }
        }
    }

    public final void map(ImageProcessorWithMasks source, ImageProcessorWithMasks target, int numThreads) {
        target.outside = new ByteProcessor(target.getWidth(), target.getHeight());
        HashMap av = ((TransformMesh)this.transform).getAV();
        if (numThreads > 1) {
            ArrayList<AffineModel2D> triangles = new ArrayList<AffineModel2D>(av.keySet());
            AtomicInteger i = new AtomicInteger(0);
            ArrayList<Thread> threads = new ArrayList<Thread>(numThreads);
            for (int k = 0; k < numThreads; ++k) {
                Thread mtt = new MapTriangleThread(i, triangles, (TransformMesh)this.transform, source, target);
                threads.add(mtt);
                mtt.start();
            }
            for (Thread mtt : threads) {
                try {
                    mtt.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        } else if (source.mask == null) {
            for (AffineModel2D triangle : av.keySet()) {
                TransformMeshMappingWithMasks.mapTriangle((TransformMesh)this.transform, triangle, source.ip, target.ip, target.outside);
            }
        } else {
            for (AffineModel2D triangle : av.keySet()) {
                TransformMeshMappingWithMasks.mapTriangle((TransformMesh)this.transform, triangle, source.ip, source.mask, target.ip, target.mask, target.outside);
            }
        }
    }

    public final void mapInterpolated(ImageProcessorWithMasks source, ImageProcessorWithMasks target, int numThreads) {
        target.outside = new ByteProcessor(target.getWidth(), target.getHeight());
        source.ip.setInterpolationMethod(1);
        if (source.mask != null) {
            source.mask.setInterpolationMethod(1);
        }
        HashMap av = ((TransformMesh)this.transform).getAV();
        if (numThreads > 1) {
            ArrayList<AffineModel2D> triangles = new ArrayList<AffineModel2D>(av.keySet());
            AtomicInteger i = new AtomicInteger(0);
            ArrayList<Thread> threads = new ArrayList<Thread>(numThreads);
            for (int k = 0; k < numThreads; ++k) {
                Thread mtt = new MapTriangleInterpolatedThread(i, triangles, (TransformMesh)this.transform, source, target);
                threads.add(mtt);
                mtt.start();
            }
            for (Thread mtt : threads) {
                try {
                    mtt.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        } else if (source.mask == null) {
            for (AffineModel2D triangle : av.keySet()) {
                TransformMeshMappingWithMasks.mapTriangleInterpolated((TransformMesh)this.transform, triangle, source.ip, target.ip, target.outside);
            }
        } else {
            for (AffineModel2D triangle : av.keySet()) {
                TransformMeshMappingWithMasks.mapTriangleInterpolated((TransformMesh)this.transform, triangle, source.ip, source.mask, target.ip, target.mask, target.outside);
            }
        }
    }

    public final void map(ImageProcessorWithMasks source, ImageProcessorWithMasks target) {
        this.map(source, target, Runtime.getRuntime().availableProcessors());
    }

    public final void mapInterpolated(ImageProcessorWithMasks source, ImageProcessorWithMasks target) {
        this.mapInterpolated(source, target, Runtime.getRuntime().availableProcessors());
    }

    public final void map(ShortProcessor source, ByteProcessor alpha, ShortProcessor target, int numThreads) {
        ArrayList<AffineModel2D> l = new ArrayList<AffineModel2D>();
        l.addAll(((TransformMesh)this.transform).getAV().keySet());
        AtomicInteger i = new AtomicInteger(0);
        ArrayList<Thread> threads = new ArrayList<Thread>(numThreads);
        for (int k = 0; k < numThreads; ++k) {
            Thread mtt = new MapShortAlphaTriangleThread(i, l, (TransformMesh)this.transform, source, alpha, target);
            threads.add(mtt);
            mtt.start();
        }
        for (Thread mtt : threads) {
            try {
                mtt.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public final void map(ShortProcessor source, ByteProcessor alpha, ShortProcessor target) {
        this.map(source, alpha, target, Runtime.getRuntime().availableProcessors());
    }

    public final void map(ColorProcessor source, ByteProcessor alpha, ColorProcessor target, ByteProcessor targetMask) {
        this.map(source, alpha, target, targetMask, Runtime.getRuntime().availableProcessors());
    }

    public final void map(ColorProcessor source, ByteProcessor alpha, ColorProcessor target, ByteProcessor targetMask, int numThreads) {
        ArrayList<AffineModel2D> l = new ArrayList<AffineModel2D>();
        l.addAll(((TransformMesh)this.transform).getAV().keySet());
        AtomicInteger i = new AtomicInteger(0);
        ArrayList<Thread> threads = new ArrayList<Thread>(numThreads);
        for (int k = 0; k < numThreads; ++k) {
            Thread mtt = new MapColorAlphaTriangleThread(i, l, (TransformMesh)this.transform, source, alpha, target, targetMask);
            threads.add(mtt);
            mtt.start();
        }
        for (Thread mtt : threads) {
            try {
                mtt.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected static final void mapColorAlphaTriangle(TransformMesh m, AffineModel2D ai, ColorProcessor source, ByteProcessor alpha, ColorProcessor target, ByteProcessor targetMask) {
        int w = target.getWidth() - 1;
        int h = target.getHeight() - 1;
        ArrayList pm = (ArrayList)m.getAV().get(ai);
        double[] min = new double[2];
        double[] max = new double[2];
        TransformMeshMappingWithMasks.calculateBoundingBox((ArrayList)pm, (double[])min, (double[])max);
        int minX = Math.max(0, Util.roundPos((double)min[0]));
        int minY = Math.max(0, Util.roundPos((double)min[1]));
        int maxX = Math.min(w, Util.roundPos((double)max[0]));
        int maxY = Math.min(h, Util.roundPos((double)max[1]));
        double[] a = ((PointMatch)pm.get(0)).getP2().getW();
        double ax = a[0];
        double ay = a[1];
        double[] b = ((PointMatch)pm.get(1)).getP2().getW();
        double bx = b[0];
        double by = b[1];
        double[] c = ((PointMatch)pm.get(2)).getP2().getW();
        double cx = c[0];
        double cy = c[1];
        double[] t = new double[2];
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                if (!TransformMeshMappingWithMasks.isInTriangle((double)ax, (double)ay, (double)bx, (double)by, (double)cx, (double)cy, (double)x, (double)y)) continue;
                t[0] = x;
                t[1] = y;
                try {
                    ai.applyInverseInPlace(t);
                }
                catch (Exception e) {
                    continue;
                }
                int is = source.getPixelInterpolated(t[0], t[1]);
                int it = target.get(x, y);
                int f_raw = alpha.getPixelInterpolated(t[0], t[1]);
                double f = (double)f_raw / 255.0;
                int is_r = (is & 0xFF0000) >> 16;
                int is_g = (is & 0xFF00) >> 8;
                int is_b = is & 0xFF;
                int it_r = (it & 0xFF0000) >> 16;
                int it_g = (it & 0xFF00) >> 8;
                int it_b = it & 0xFF;
                int v = (int)Math.min(Math.max(Math.round((double)it_r + f * (double)(is_r - it_r)), 0L), 255L) << 16 | (int)Math.min(Math.max(Math.round((double)it_g + f * (double)(is_g - it_g)), 0L), 255L) << 8 | (int)Math.min(Math.max(Math.round((double)it_b + f * (double)(is_b - it_b)), 0L), 255L);
                target.set(x, y, v);
                targetMask.set(x, y, Math.min(Math.max(f_raw, targetMask.get(x, y)), 255));
            }
        }
    }

    public final void map(ByteProcessor source, ByteProcessor alpha, ByteProcessor target, ByteProcessor targetMask, int numThreads) {
        ArrayList<AffineModel2D> l = new ArrayList<AffineModel2D>();
        l.addAll(((TransformMesh)this.transform).getAV().keySet());
        AtomicInteger i = new AtomicInteger(0);
        ArrayList<Thread> threads = new ArrayList<Thread>(numThreads);
        for (int k = 0; k < numThreads; ++k) {
            Thread mtt = new MapByteAlphaTriangleThread(i, l, (TransformMesh)this.transform, source, alpha, target, targetMask);
            threads.add(mtt);
            mtt.start();
        }
        for (Thread mtt : threads) {
            try {
                mtt.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public final void map(ByteProcessor source, ByteProcessor alpha, ByteProcessor target, ByteProcessor targetMask) {
        this.map(source, alpha, target, targetMask, Runtime.getRuntime().availableProcessors());
    }

    protected static final void mapByteAlphaTriangle(TransformMesh m, AffineModel2D ai, ByteProcessor source, ByteProcessor alpha, ByteProcessor target, ByteProcessor targetMask) {
        int w = target.getWidth() - 1;
        int h = target.getHeight() - 1;
        ArrayList pm = (ArrayList)m.getAV().get(ai);
        double[] min = new double[2];
        double[] max = new double[2];
        TransformMeshMappingWithMasks.calculateBoundingBox((ArrayList)pm, (double[])min, (double[])max);
        int minX = Math.max(0, Util.roundPos((double)min[0]));
        int minY = Math.max(0, Util.roundPos((double)min[1]));
        int maxX = Math.min(w, Util.roundPos((double)max[0]));
        int maxY = Math.min(h, Util.roundPos((double)max[1]));
        double[] a = ((PointMatch)pm.get(0)).getP2().getW();
        double ax = a[0];
        double ay = a[1];
        double[] b = ((PointMatch)pm.get(1)).getP2().getW();
        double bx = b[0];
        double by = b[1];
        double[] c = ((PointMatch)pm.get(2)).getP2().getW();
        double cx = c[0];
        double cy = c[1];
        double[] t = new double[2];
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                if (!TransformMeshMappingWithMasks.isInTriangle((double)ax, (double)ay, (double)bx, (double)by, (double)cx, (double)cy, (double)x, (double)y)) continue;
                t[0] = x;
                t[1] = y;
                try {
                    ai.applyInverseInPlace(t);
                }
                catch (Exception e) {
                    continue;
                }
                int is = source.getPixelInterpolated(t[0], t[1]);
                int it = target.get(x, y);
                int f_raw = alpha.getPixelInterpolated(t[0], t[1]);
                double f = (double)f_raw / 255.0;
                double v = (double)it + f * (double)(is - it);
                target.set(x, y, (int)Math.max(0L, Math.min(255L, Math.round(v))));
                targetMask.set(x, y, Math.min(Math.max(f_raw, targetMask.get(x, y)), 255));
            }
        }
    }

    private static final class MapByteAlphaTriangleThread
    extends Thread {
        private final AtomicInteger i;
        private final List<AffineModel2D> triangles;
        private final TransformMesh transform;
        final ByteProcessor source;
        final ByteProcessor target;
        final ByteProcessor alpha;
        final ByteProcessor targetMask;

        MapByteAlphaTriangleThread(AtomicInteger i, List<AffineModel2D> triangles, TransformMesh transform, ByteProcessor source, ByteProcessor alpha, ByteProcessor target, ByteProcessor targetMask) {
            this.i = i;
            this.triangles = triangles;
            this.transform = transform;
            this.source = source;
            this.alpha = alpha;
            this.target = target;
            this.targetMask = targetMask;
        }

        @Override
        public final void run() {
            int k = this.i.getAndIncrement();
            while (!this.isInterrupted() && k < this.triangles.size()) {
                TransformMeshMappingWithMasks.mapByteAlphaTriangle(this.transform, this.triangles.get(k), this.source, this.alpha, this.target, this.targetMask);
                k = this.i.getAndIncrement();
            }
        }
    }

    private static final class MapColorAlphaTriangleThread
    extends Thread {
        private final AtomicInteger i;
        private final List<AffineModel2D> triangles;
        private final TransformMesh transform;
        final ColorProcessor source;
        final ColorProcessor target;
        final ByteProcessor alpha;
        final ByteProcessor targetMask;

        MapColorAlphaTriangleThread(AtomicInteger i, List<AffineModel2D> triangles, TransformMesh transform, ColorProcessor source, ByteProcessor alpha, ColorProcessor target, ByteProcessor targetMask) {
            this.i = i;
            this.triangles = triangles;
            this.transform = transform;
            this.source = source;
            this.alpha = alpha;
            this.target = target;
            this.targetMask = targetMask;
        }

        @Override
        public final void run() {
            int k = this.i.getAndIncrement();
            while (!this.isInterrupted() && k < this.triangles.size()) {
                TransformMeshMappingWithMasks.mapColorAlphaTriangle(this.transform, this.triangles.get(k), this.source, this.alpha, this.target, this.targetMask);
                k = this.i.getAndIncrement();
            }
        }
    }

    private static final class MapShortAlphaTriangleThread
    extends Thread {
        private final AtomicInteger i;
        private final List<AffineModel2D> triangles;
        private final TransformMesh transform;
        final ShortProcessor source;
        final ShortProcessor target;
        final ByteProcessor alpha;

        MapShortAlphaTriangleThread(AtomicInteger i, List<AffineModel2D> triangles, TransformMesh transform, ShortProcessor source, ByteProcessor alpha, ShortProcessor target) {
            this.i = i;
            this.triangles = triangles;
            this.transform = transform;
            this.source = source;
            this.alpha = alpha;
            this.target = target;
        }

        @Override
        public final void run() {
            int k = this.i.getAndIncrement();
            while (!this.isInterrupted() && k < this.triangles.size()) {
                TransformMeshMappingWithMasks.mapShortAlphaTriangle(this.transform, this.triangles.get(k), this.source, this.alpha, this.target);
                k = this.i.getAndIncrement();
            }
        }
    }

    private static final class MapTriangleInterpolatedThread
    extends Thread {
        private final AtomicInteger i;
        private final List<AffineModel2D> triangles;
        private final TransformMesh transform;
        final ImageProcessorWithMasks source;
        final ImageProcessorWithMasks target;

        MapTriangleInterpolatedThread(AtomicInteger i, List<AffineModel2D> triangles, TransformMesh transform, ImageProcessorWithMasks source, ImageProcessorWithMasks target) {
            this.i = i;
            this.triangles = triangles;
            this.transform = transform;
            this.source = source;
            this.target = target;
        }

        @Override
        public final void run() {
            int k = this.i.getAndIncrement();
            while (!this.isInterrupted() && k < this.triangles.size()) {
                if (this.source.mask == null) {
                    TransformMeshMappingWithMasks.mapTriangleInterpolated(this.transform, this.triangles.get(k), this.source.ip, this.target.ip, this.target.outside);
                } else {
                    TransformMeshMappingWithMasks.mapTriangleInterpolated(this.transform, this.triangles.get(k), this.source.ip, this.source.mask, this.target.ip, this.target.mask, this.target.outside);
                }
                k = this.i.getAndIncrement();
            }
        }
    }

    private static final class MapTriangleThread
    extends Thread {
        private final AtomicInteger i;
        private final List<AffineModel2D> triangles;
        private final TransformMesh transform;
        final ImageProcessorWithMasks source;
        final ImageProcessorWithMasks target;

        MapTriangleThread(AtomicInteger i, List<AffineModel2D> triangles, TransformMesh transform, ImageProcessorWithMasks source, ImageProcessorWithMasks target) {
            this.i = i;
            this.triangles = triangles;
            this.transform = transform;
            this.source = source;
            this.target = target;
        }

        @Override
        public final void run() {
            int k = this.i.getAndIncrement();
            while (!this.isInterrupted() && k < this.triangles.size()) {
                if (this.source.mask == null) {
                    TransformMeshMappingWithMasks.mapTriangle(this.transform, this.triangles.get(k), this.source.ip, this.target.ip, this.target.outside);
                } else {
                    TransformMeshMappingWithMasks.mapTriangle(this.transform, this.triangles.get(k), this.source.ip, this.source.mask, this.target.ip, this.target.mask, this.target.outside);
                }
                k = this.i.getAndIncrement();
            }
        }
    }

    public static final class ImageProcessorWithMasks {
        public final ImageProcessor ip;
        public ByteProcessor outside = null;
        public ImageProcessor mask = null;

        public ImageProcessorWithMasks(ImageProcessor ip, ImageProcessor mask, ByteProcessor outside) {
            this.ip = ip;
            if (outside != null) {
                if (ip.getWidth() == outside.getWidth() && ip.getHeight() == outside.getHeight()) {
                    this.outside = outside;
                } else {
                    System.err.println("ImageProcessorWithMasks: ip and outside mask differ in size, setting outside = null");
                }
            }
            if (mask != null) {
                if (ip.getWidth() == mask.getWidth() && ip.getHeight() == mask.getHeight()) {
                    this.mask = mask;
                } else {
                    System.err.println("ImageProcessorWithMasks: ip and mask differ in size, setting mask = null");
                }
            }
        }

        public final int getWidth() {
            return this.ip.getWidth();
        }

        public final int getHeight() {
            return this.ip.getHeight();
        }
    }
}

