/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apposed.appose.BuildHandler;
import org.apposed.appose.Environment;

public class Builder {
    public final Map<String, List<String>> config = new HashMap<String, List<String>>();
    public final List<ProgressConsumer> progressSubscribers = new ArrayList<ProgressConsumer>();
    public final List<Consumer<String>> outputSubscribers = new ArrayList<Consumer<String>>();
    public final List<Consumer<String>> errorSubscribers = new ArrayList<Consumer<String>>();
    private final List<BuildHandler> handlers = new ArrayList<BuildHandler>();
    private boolean includeSystemPath;
    private String scheme = "conda";

    Builder() {
        ServiceLoader.load(BuildHandler.class).forEach(this.handlers::add);
    }

    public Builder subscribeProgress(ProgressConsumer subscriber) {
        this.progressSubscribers.add(subscriber);
        return this;
    }

    public Builder subscribeOutput(Consumer<String> subscriber) {
        this.outputSubscribers.add(subscriber);
        return this;
    }

    public Builder subscribeError(Consumer<String> subscriber) {
        this.errorSubscribers.add(subscriber);
        return this;
    }

    public Builder logDebug() {
        String reset = "\u001b[0m";
        String yellow = "\u001b[0;33m";
        String red = "\u001b[0;31m";
        return this.subscribeProgress((title, cur, max) -> System.out.printf("%s: %d/%d\n", title, cur, max)).subscribeOutput(msg -> System.out.printf("%s%s%s", yellow, msg.isEmpty() ? "." : msg, reset)).subscribeError(msg -> System.out.printf("%s%s%s", red, msg.isEmpty() ? "." : msg, reset));
    }

    public Builder useSystemPath() {
        this.includeSystemPath = true;
        return this;
    }

    public Builder scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public Builder file(String filePath) throws IOException {
        return this.file(new File(filePath));
    }

    public Builder file(String filePath, String scheme) throws IOException {
        return this.file(new File(filePath), scheme);
    }

    public Builder file(File file) throws IOException {
        return this.file(file, file.getName());
    }

    public Builder file(File file, String scheme) throws IOException {
        byte[] bytes = Files.readAllBytes(file.toPath());
        return this.include(new String(bytes), scheme);
    }

    public Builder channel(String name) {
        return this.channel(name, this.scheme);
    }

    public Builder channel(String name, String location) {
        if (this.handle(handler -> handler.channel(name, location))) {
            return this;
        }
        throw new IllegalArgumentException("Unsupported channel: " + name + (location == null ? "" : "=" + location));
    }

    public Builder include(String content) {
        return this.include(content, this.scheme);
    }

    public Builder include(String content, String scheme) {
        if (this.handle(handler -> handler.include(content, scheme))) {
            return this;
        }
        throw new IllegalArgumentException("Unsupported '" + scheme + "' content: " + content);
    }

    public Environment build() throws IOException {
        return this.build((String)this.handlers.stream().map(BuildHandler::envName).filter(Objects::nonNull).findFirst().orElse(null));
    }

    public Environment build(String envName) throws IOException {
        if (envName == null || envName.isEmpty()) {
            throw new IllegalArgumentException("No environment name given.");
        }
        Path apposeRoot = Paths.get(System.getProperty("user.home"), ".local", "share", "appose");
        return this.build(apposeRoot.resolve(envName).toFile());
    }

    public Environment build(File envDir) throws IOException {
        if (envDir == null) {
            throw new IllegalArgumentException("No environment directory given.");
        }
        if (!envDir.exists() && !envDir.mkdirs()) {
            throw new RuntimeException("Failed to create environment directory: " + envDir);
        }
        if (!envDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + envDir);
        }
        this.config.clear();
        for (BuildHandler handler : this.handlers) {
            handler.build(envDir, this);
        }
        final String base = envDir.getAbsolutePath();
        final List<String> launchArgs = Builder.listFromConfig("launchArgs", this.config);
        final List<String> binPaths = Builder.listFromConfig("binPaths", this.config);
        final List<String> classpath = Builder.listFromConfig("classpath", this.config);
        binPaths.add(envDir.getAbsolutePath());
        if (this.includeSystemPath) {
            List<String> systemPaths = Arrays.asList(System.getenv("PATH").split(File.pathSeparator));
            binPaths.addAll(systemPaths);
        }
        return new Environment(){

            @Override
            public String base() {
                return base;
            }

            @Override
            public List<String> binPaths() {
                return binPaths;
            }

            @Override
            public List<String> classpath() {
                return classpath;
            }

            @Override
            public List<String> launchArgs() {
                return launchArgs;
            }
        };
    }

    private boolean handle(Function<BuildHandler, Boolean> handlerFunction) {
        boolean handled = false;
        for (BuildHandler handler : this.handlers) {
            handled |= handlerFunction.apply(handler).booleanValue();
        }
        return handled;
    }

    private static List<String> listFromConfig(String key, Map<String, List<String>> config) {
        List value = config.getOrDefault(key, Collections.emptyList());
        return value.stream().map(Object::toString).collect(Collectors.toList());
    }

    public static interface ProgressConsumer {
        public void accept(String var1, long var2, long var4);
    }
}

