/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apposed.appose.Service;
import org.apposed.appose.Types;

public class GroovyWorker {
    private static final Map<String, Task> TASKS = new ConcurrentHashMap<String, Task>();

    public static void main(String ... args) throws IOException {
        String line;
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        while ((line = stdin.readLine()) != null) {
            Map<String, Object> request = Types.decode(line);
            String uuid = (String)request.get("task");
            String requestType = (String)request.get("requestType");
            switch (Service.RequestType.valueOf(requestType)) {
                case EXECUTE: {
                    String script = (String)request.get("script");
                    Map inputs = (Map)request.get("inputs");
                    GroovyWorker.execute(uuid, script, inputs);
                    break;
                }
                case CANCEL: {
                    GroovyWorker.cancel(uuid);
                    break;
                }
            }
        }
    }

    private static void execute(String uuid, String script, Map<String, Object> inputs) {
        Task task = new Task(uuid);
        TASKS.put(uuid, task);
        task.start(script, inputs);
    }

    private static void cancel(String uuid) {
        Task task = TASKS.get(uuid);
        if (task == null) {
            System.err.println("No such task: " + uuid);
            return;
        }
        task.cancelRequested = true;
    }

    public static class Task {
        public final String uuid;
        public final Map<Object, Object> outputs = new ConcurrentHashMap<Object, Object>();
        public boolean cancelRequested;

        public Task(String uuid) {
            this.uuid = uuid;
        }

        public void update(String message, Long current, Long maximum) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            if (message != null) {
                args.put("message", message);
            }
            if (current != null) {
                args.put("current", current);
            }
            if (maximum != null) {
                args.put("maximum", maximum);
            }
            this.respond(Service.ResponseType.UPDATE, args);
        }

        public void cancel() {
            this.respond(Service.ResponseType.CANCELATION, null);
        }

        public void fail(String error) {
            Map<String, Object> args = error == null ? null : Collections.singletonMap("error", error);
            this.respond(Service.ResponseType.FAILURE, args);
        }

        private void start(String script, Map<String, Object> inputs) {
            new Thread(() -> {
                Object result;
                Binding binding = new Binding();
                binding.setVariable("task", (Object)this);
                inputs.forEach((arg_0, arg_1) -> ((Binding)binding).setVariable(arg_0, arg_1));
                this.reportLaunch();
                try {
                    GroovyShell shell = new GroovyShell(binding);
                    result = shell.evaluate(script);
                }
                catch (Exception exc) {
                    this.fail(Types.stackTrace(exc));
                    return;
                }
                if (result instanceof Map) {
                    this.outputs.putAll((Map)result);
                } else if (result != null) {
                    this.outputs.put("result", result);
                }
                this.reportCompletion();
            }, "Appose-" + this.uuid).start();
        }

        private void reportLaunch() {
            this.respond(Service.ResponseType.LAUNCH, null);
        }

        private void reportCompletion() {
            Map<String, Object> args = Collections.singletonMap("outputs", this.outputs);
            this.respond(Service.ResponseType.COMPLETION, args);
        }

        private void respond(Service.ResponseType responseType, Map<String, Object> args) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("task", this.uuid);
            response.put("responseType", responseType.toString());
            if (args != null) {
                response.putAll(args);
            }
            try {
                System.out.println(Types.encode(response));
            }
            catch (Exception exc) {
                if (responseType == Service.ResponseType.FAILURE) {
                    throw new RuntimeException(exc);
                }
                this.fail(Types.stackTrace(exc));
            }
            System.out.flush();
        }
    }
}

