/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.mamba;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apposed.appose.mamba.Mamba;

final class MambaInstallerUtils {
    private MambaInstallerUtils() {
    }

    public static void unBZip2(File source, File destination) throws FileNotFoundException, IOException, InterruptedException {
        try (BZip2CompressorInputStream input = new BZip2CompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(source)));
             FileOutputStream output = new FileOutputStream(destination);){
            MambaInstallerUtils.copy((InputStream)input, output);
        }
    }

    private static long copy(InputStream input, OutputStream output) throws IOException, InterruptedException {
        int bufferSize = 4096;
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Decompressing stopped.");
            }
            if (output != null) {
                output.write(buffer, 0, n);
            }
            count += (long)n;
        }
        return count;
    }

    public static void unTar(File inputFile, File outputDir) throws FileNotFoundException, IOException, InterruptedException {
        try (FileInputStream is = new FileInputStream(inputFile);
             TarArchiveInputStream debInputStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)is);){
            TarArchiveEntry entry = null;
            while ((entry = debInputStream.getNextEntry()) != null) {
                File outputFile = new File(outputDir, entry.getName());
                if (entry.isDirectory()) {
                    if (outputFile.exists() || outputFile.mkdirs()) continue;
                    throw new IllegalStateException(String.format("Couldn't create directory %s.", outputFile.getAbsolutePath()));
                }
                if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                    throw new IOException("Failed to create directory " + outputFile.getParentFile().getAbsolutePath());
                }
                FileOutputStream outputFileStream = new FileOutputStream(outputFile);
                Throwable throwable = null;
                try {
                    MambaInstallerUtils.copy((InputStream)debInputStream, outputFileStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (outputFileStream == null) continue;
                    if (throwable != null) {
                        try {
                            ((OutputStream)outputFileStream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((OutputStream)outputFileStream).close();
                }
            }
        }
        catch (ArchiveException e) {
            throw new IOException(e);
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, URISyntaxException, InterruptedException {
        String url = Mamba.MICROMAMBA_URL;
        File tempFile = File.createTempFile("miniconda", ".tar.bz2");
        tempFile.deleteOnExit();
        URL website = MambaInstallerUtils.redirectedURL(new URL(url));
        ReadableByteChannel rbc = Channels.newChannel(website.openStream());
        try (FileOutputStream fos = new FileOutputStream(tempFile);){
            long transferred = fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            System.out.print(tempFile.length());
        }
        String tarPath = "C:\\Users\\angel\\OneDrive\\Documentos\\pasteur\\git\\micromamba-1.5.1-1.tar";
        String mambaPath = "C:\\Users\\angel\\OneDrive\\Documentos\\pasteur\\git\\mamba";
        MambaInstallerUtils.unBZip2(new File("C:\\Users\\angel\\OneDrive\\Documentos\\pasteur\\git\\micromamba-1.5.1-1.tar.bz2"), new File(tarPath));
        MambaInstallerUtils.unTar(new File(tarPath), new File(mambaPath));
    }

    public static URL redirectedURL(URL url) throws MalformedURLException, URISyntaxException {
        int statusCode;
        HttpURLConnection conn;
        try {
            conn = (HttpURLConnection)url.openConnection();
            statusCode = conn.getResponseCode();
        }
        catch (IOException ex) {
            return url;
        }
        if (statusCode < 300 || statusCode > 308) {
            return url;
        }
        String newURL = conn.getHeaderField("Location");
        try {
            return MambaInstallerUtils.redirectedURL(new URL(newURL));
        }
        catch (MalformedURLException malformedURLException) {
            try {
                if (newURL.startsWith("//")) {
                    return MambaInstallerUtils.redirectedURL(new URL("http:" + newURL));
                }
                throw new MalformedURLException();
            }
            catch (MalformedURLException malformedURLException2) {
                URI uri = url.toURI();
                String scheme = uri.getScheme();
                String host = uri.getHost();
                String mainDomain = scheme + "://" + host;
                return MambaInstallerUtils.redirectedURL(new URL(mainDomain + newURL));
            }
        }
    }

    public static long getFileSize(URL url) {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("User-Agent", "Appose/0.1.0(" + System.getProperty("os.name") + "; Java " + System.getProperty("java.version"));
            if (conn.getResponseCode() >= 300 && conn.getResponseCode() <= 308) {
                return MambaInstallerUtils.getFileSize(MambaInstallerUtils.redirectedURL(url));
            }
            if (conn.getResponseCode() != 200) {
                throw new Exception("Unable to connect to: " + url.toString());
            }
            long size = conn.getContentLengthLong();
            conn.disconnect();
            return size;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String msg = "Unable to connect to " + url.toString();
            System.out.println(msg);
            return 1L;
        }
    }
}

