/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.shm;

import java.util.Random;

class ShmUtils {
    static int O_RDONLY = 0;
    static int O_RDWR = 2;
    static int O_CREAT = 64;
    static int PROT_READ = 1;
    static int PROT_WRITE = 2;
    static int MAP_SHARED = 1;
    public static final OS os = ShmUtils.detect_os();
    static final int SHM_SAFE_NAME_LENGTH = 14;
    static final String SHM_NAME_PREFIX_POSIX = "/psm_";
    static final String SHM_NAME_PREFIX_WIN = "wnsm_";

    ShmUtils() {
    }

    private static OS detect_os() {
        String os_name = System.getProperty("os.name").toLowerCase();
        if (os_name.startsWith("windows")) {
            return OS.WINDOWS;
        }
        if (os_name.startsWith("mac")) {
            return OS.OSX;
        }
        if (os_name.contains("linux") || os_name.endsWith("ix")) {
            return OS.LINUX;
        }
        throw new RuntimeException("OS detection failed. System.getProperty(\"os.name\") = " + System.getProperty("os.name"));
    }

    static String withLeadingSlash(String name) {
        return name.startsWith("/") ? name : "/" + name;
    }

    static String withoutLeadingSlash(String name) {
        return name.startsWith("/") ? name.substring(1) : name;
    }

    static String make_filename(int maxLength, String prefix) {
        int nbytes = (maxLength - prefix.length()) / 2;
        if (nbytes < 2) {
            throw new IllegalArgumentException("prefix too long");
        }
        String name = prefix + ShmUtils.token_hex(nbytes);
        assert (name.length() <= maxLength);
        return name;
    }

    static void checkSize(String shmName, long prevSize, int size) {
        boolean alreadyExists;
        boolean bl = alreadyExists = prevSize >= 0L;
        if (alreadyExists && prevSize < (long)size) {
            throw new RuntimeException("Shared memory segment '" + shmName + "' already exists with smaller size. Size of the existing shared memory segment cannot be smaller than the size of the proposed object. Size of existing shared memory segment: " + prevSize + ", size of proposed object: " + size);
        }
    }

    private static String token_hex(int nbytes) {
        byte[] bytes = new byte[nbytes];
        new Random().nextBytes(bytes);
        StringBuilder sb = new StringBuilder(nbytes * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    static enum OS {
        WINDOWS,
        OSX,
        LINUX;

    }
}

