/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.pde;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.pde.ExplicitDiffusionScheme3D;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;

public class NonNegativityDiffusionScheme3D<T extends RealType<T>>
extends ExplicitDiffusionScheme3D<T> {
    private static final float DEFAULT_DT = 0.15f;
    private float dt;

    public NonNegativityDiffusionScheme3D(Img<T> input, Img<FloatType> D) {
        this(input, D, 0.15f);
    }

    public NonNegativityDiffusionScheme3D(Img<T> input, Img<FloatType> D, float dt) {
        super(input, D);
        this.dt = dt;
    }

    public NonNegativityDiffusionScheme3D(RandomAccessibleInterval<T> input, RandomAccessibleInterval<FloatType> D, ImgFactory<FloatType> imgFactory) {
        this(input, D, imgFactory, 0.15f);
    }

    public NonNegativityDiffusionScheme3D(RandomAccessibleInterval<T> input, RandomAccessibleInterval<FloatType> D, ImgFactory<FloatType> imgFactory, float dt) {
        super(input, D);
        this.dt = dt;
    }

    @Override
    protected float diffusionScheme(float[] U, float[][] D) {
        float Uccc = U[0];
        float Uccm = U[1];
        float Ucmm = U[2];
        float Umcm = U[3];
        float Ucpm = U[4];
        float Upcm = U[5];
        float Upmc = U[6];
        float Ucmc = U[7];
        float Ummc = U[8];
        float Umcc = U[9];
        float Umpc = U[10];
        float Ucpc = U[11];
        float Uppc = U[12];
        float Upcc = U[13];
        float Upcp = U[14];
        float Ucmp = U[15];
        float Umcp = U[16];
        float Ucpp = U[17];
        float Uccp = U[18];
        float Accc = D[0][0];
        float Amcc = D[0][1];
        float Apcc = D[0][2];
        float Bccc = D[1][0];
        float Bcmc = D[1][1];
        float Bcpc = D[1][2];
        float Cccc = D[2][0];
        float Cccm = D[2][1];
        float Cccp = D[2][2];
        float Dccc = D[3][0];
        float Dpmc = D[3][1];
        float Dcmc = D[3][2];
        float Dmmc = D[3][3];
        float Dmcc = D[3][4];
        float Dmpc = D[3][5];
        float Dcpc = D[3][6];
        float Dppc = D[3][7];
        float Dpcc = D[3][8];
        float Eccc = D[4][0];
        float Eccm = D[4][1];
        float Emcm = D[4][2];
        float Epcm = D[4][3];
        float Emcc = D[4][4];
        float Epcc = D[4][5];
        float Epcp = D[4][6];
        float Emcp = D[4][7];
        float Eccp = D[4][8];
        float Fccc = D[5][0];
        float Fccm = D[5][1];
        float Fcmm = D[5][2];
        float Fcpm = D[5][3];
        float Fcmc = D[5][4];
        float Fcpc = D[5][5];
        float Fcmp = D[5][6];
        float Fcpp = D[5][7];
        float Fccp = D[5][8];
        float Ipcc = 0.5f * (Apcc + Accc - (Math.abs(Dpcc) + Math.abs(Dccc)) - (Math.abs(Epcc) + Math.abs(Eccc)));
        float Imcc = 0.5f * (Amcc + Accc - (Math.abs(Dmcc) + Math.abs(Dccc)) - (Math.abs(Emcc) + Math.abs(Eccc)));
        float Icpc = 0.5f * (Bcpc + Bccc - (Math.abs(Dcpc) + Math.abs(Dccc)) - (Math.abs(Fcpc) + Math.abs(Fccc)));
        float Icmc = 0.5f * (Bcmc + Bccc - (Math.abs(Dcmc) + Math.abs(Dccc)) - (Math.abs(Fcmc) + Math.abs(Fccc)));
        float Iccm = 0.5f * (Cccm + Cccc - (Math.abs(Fccm) + Math.abs(Fccc)) - (Math.abs(Eccm) + Math.abs(Eccc)));
        float Iccp = 0.5f * (Cccp + Cccc - (Math.abs(Fccp) + Math.abs(Fccc)) - (Math.abs(Eccp) + Math.abs(Eccc)));
        float Ippc = 0.25f * (Dppc + Dccc + Math.abs(Dppc) + Math.abs(Dccc));
        float Immc = 0.25f * (Dmmc + Dccc + Math.abs(Dmmc) + Math.abs(Dccc));
        float Ipmc = 0.25f * (-Dpmc - Dccc + Math.abs(Dpmc) + Math.abs(Dccc));
        float Impc = 0.25f * (-Dmpc - Dccc + Math.abs(Dmpc) + Math.abs(Dccc));
        float Icpp = 0.25f * (Fcpp + Fccc + Math.abs(Fcpp) + Math.abs(Fccc));
        float Icmp = 0.25f * (-Fcmp - Fccc + Math.abs(Fcmp) + Math.abs(Fccc));
        float Ipcp = 0.25f * (Epcp + Eccc + Math.abs(Epcp) + Math.abs(Eccc));
        float Imcp = 0.25f * (-Emcp - Eccc + Math.abs(Emcp) + Math.abs(Eccc));
        float Icpm = 0.25f * (-Fcpm - Fccc + Math.abs(Fcpm) + Math.abs(Fccc));
        float Icmm = 0.25f * (Fcmm + Fccc + Math.abs(Fcmm) + Math.abs(Fccc));
        float Ipcm = 0.25f * (-Epcm - Eccc + Math.abs(Epcm) + Math.abs(Eccc));
        float Imcm = 0.25f * (Emcm + Eccc + Math.abs(Emcm) + Math.abs(Eccc));
        return this.dt * (Ipcc * (Upcc - Uccc) + Imcc * (Umcc - Uccc) + Icpc * (Ucpc - Uccc) + Icmc * (Ucmc - Uccc) + Iccm * (Uccm - Uccc) + Iccp * (Uccp - Uccc) + Ippc * (Uppc - Uccc) + Immc * (Ummc - Uccc) + Ipmc * (Upmc - Uccc) + Impc * (Umpc - Uccc) + Icpp * (Ucpp - Uccc) + Icmp * (Ucmp - Uccc) + Ipcp * (Upcp - Uccc) + Imcp * (Umcp - Uccc) + Icpm * (Ucpm - Uccc) + Icmm * (Ucmm - Uccc) + Ipcm * (Upcm - Uccc) + Imcm * (Umcm - Uccc));
    }
}

