/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.panorama;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.gui.ImageWindow;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.GeneralPath;
import java.util.EventListener;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.panorama.EquirectangularProjection;

public abstract class AbstractPanorama_View
implements PlugIn,
KeyListener,
MouseWheelListener,
MouseListener,
MouseMotionListener {
    private static final String NL = System.getProperty("line.separator");
    protected ImagePlus imp;
    protected ImageProcessor ip;
    protected ImageProcessor ipSource;
    private GUI gui;
    protected static int width = 400;
    protected static int height = 300;
    protected static double minLambda = 0.0;
    protected static double minPhi = 0.0;
    protected static double hfov = Math.PI * 2;
    protected static double vfov = Math.PI;
    protected final EquirectangularProjection p = new EquirectangularProjection();
    private static final double step = Math.PI / 180;
    protected double lambda;
    protected double phi;
    protected double rho;
    protected double dLambda = 0.0;
    protected double dPhi = 0.0;
    protected int oX;
    protected int oY;
    protected int dX;
    protected int dY;
    protected double oRho;
    private NaviMode naviMode = NaviMode.PAN_TILT;
    private AbstractMappingThread painter;

    protected abstract boolean setup(ImagePlus var1);

    public void run(String arg) {
        this.imp = IJ.getImage();
        if (this.imp == null) {
            IJ.error((String)"No image open.");
            return;
        }
        if (!this.setup(this.imp)) {
            return;
        }
        this.run(this.imp, width, height, minLambda, minPhi, hfov, vfov);
    }

    protected abstract AbstractMappingThread createPainter(ImagePlus var1);

    protected GUI createGUI(ImagePlus impViewer) {
        return new GUI(impViewer);
    }

    public final void run(ImagePlus imp, int width, int height, double minLambda, double minPhi, double hfov, double vfov) {
        this.ip = imp.getProcessor().createProcessor(width, height);
        ImagePlus impViewer = new ImagePlus("Panorama View", this.ip);
        this.p.setMinLambda(minLambda);
        this.p.setMinPhi(minPhi);
        this.p.setLambdaPiScale(Math.PI / hfov * (double)imp.getWidth());
        this.p.setPhiPiScale(Math.PI / vfov * (double)(imp.getHeight() - 1));
        this.p.setTargetWidth(this.ip.getWidth());
        this.p.setTargetHeight(this.ip.getHeight());
        this.p.setF(0.5);
        System.out.println(this.p.getLambdaPiScale() + " " + this.p.getPhiPiScale());
        this.painter = this.createPainter(impViewer);
        impViewer.show();
        this.gui = this.createGUI(impViewer);
        this.gui.backupGui();
        this.gui.takeOverGui();
        this.painter.start();
        this.update(false);
    }

    protected static final void prepareExtendedImage(ImageProcessor source, ImageProcessor target) {
        if (target.getWidth() > source.getWidth()) {
            target.copyBits(source, source.getWidth(), 0, 0);
            if (target.getHeight() > source.getHeight()) {
                target.copyBits(source, source.getWidth(), 0, 0);
            }
        }
        if (target.getHeight() > source.getHeight()) {
            target.copyBits(source, 0, 1, 0);
        }
        target.copyBits(source, 0, 0, 0);
    }

    private final void update(boolean keepPainting) {
        this.painter.repaint(keepPainting);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 || e.getKeyCode() == 10) {
            this.painter.interrupt();
            this.imp.getCanvas().setDisplayList(null);
            this.gui.restoreGui();
            if (e.getKeyCode() == 27) {
                this.gui.close();
            }
        } else if (e.getKeyCode() == 16) {
            this.dLambda *= 10.0;
            this.dPhi *= 10.0;
        } else if (e.getKeyCode() == 17) {
            this.dLambda /= 10.0;
            this.dPhi /= 10.0;
        } else {
            double v = this.keyModfiedSpeed(e.getModifiersEx());
            if (e.getKeyCode() == 37) {
                this.lambda -= v * (Math.PI / 180);
                this.update(false);
            } else if (e.getKeyCode() == 39) {
                this.lambda += v * (Math.PI / 180);
                this.update(false);
            } else if (e.getKeyCode() == 38) {
                this.phi -= v * (Math.PI / 180);
                this.update(false);
            } else if (e.getKeyCode() == 40) {
                this.phi += v * (Math.PI / 180);
                this.update(false);
            } else if (e.getKeyCode() == 521 || e.getKeyCode() == 61) {
                this.p.setF(this.p.getF() * (1.0 + (double)0.1f * v));
                this.update(false);
            } else if (e.getKeyCode() == 45) {
                this.p.setF(this.p.getF() / (1.0 + (double)0.1f * v));
                this.update(false);
            } else if (e.getKeyCode() == 73) {
                this.painter.toggleInterpolation();
                this.update(false);
            } else if (e.getKeyCode() == 86) {
                this.painter.toggleVisualization();
                this.imp.getCanvas().setDisplayList(null);
                this.update(false);
            } else if (e.getKeyCode() == 65) {
                this.naviMode = NaviMode.PAN_TILT;
                this.dPhi = 0.0;
                this.dLambda = 0.0;
                this.update(false);
            } else if (e.getKeyCode() == 80) {
                this.naviMode = NaviMode.PAN_ONLY;
                this.dPhi = 0.0;
                this.dLambda = 0.0;
                this.update(false);
            } else if (e.getKeyCode() == 84) {
                this.naviMode = NaviMode.TILT_ONLY;
                this.dPhi = 0.0;
                this.dLambda = 0.0;
                this.update(false);
            } else if (e.getKeyCode() == 82) {
                this.naviMode = NaviMode.ROLL_ONLY;
                this.dPhi = 0.0;
                this.dLambda = 0.0;
                this.update(false);
            } else if (e.getKeyCode() == 112) {
                IJ.showMessage((String)"Interactive Panorama Viewer", (String)("Mouse control:" + NL + " " + NL + "Pan and tilt the panorama by dragging the image in the canvas and" + NL + "zoom in and out using the mouse-wheel." + NL + " " + NL + "Key control:" + NL + " " + NL + "CURSOR LEFT - Pan left." + NL + "CURSOR RIGHT - Pan right." + NL + "CURSOR UP - Tilt up." + NL + "CURSOR DOWN - Tilt down." + NL + "SHIFT - Move 10x faster." + NL + "CTRL - Move browse 10x slower." + NL + "ENTER/ESC - Leave interactive mode." + NL + "I - Toggle interpolation." + NL + "V - Toggle FOV visualization." + NL + "R - Roll-mode (roll via mouse drag)." + NL + "P - Pan/Tilt-mode (pan/tilt via mouse drag)."));
            }
        }
    }

    private final double keyModfiedSpeed(int modifiers) {
        if ((modifiers & 0x40) != 0) {
            return 10.0;
        }
        if ((modifiers & 0x80) != 0) {
            return 0.1f;
        }
        return 1.0;
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 16) {
            this.dLambda /= 10.0;
            this.dPhi /= 10.0;
        } else if (e.getKeyCode() == 17) {
            this.dLambda *= 10.0;
            this.dPhi *= 10.0;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double v = this.keyModfiedSpeed(e.getModifiersEx());
        int s = e.getWheelRotation();
        this.p.setF(this.p.getF() * (1.0 - (double)(0.05f * (float)s) * v));
        this.update(false);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.dX = this.oX - e.getX();
        this.dY = this.oY - e.getY();
        if (this.naviMode == NaviMode.ROLL_ONLY) {
            double d = Math.sqrt(this.dX * this.dX + this.dY * this.dY);
            this.rho = this.oRho + Math.atan2((double)this.dY / d, (double)this.dX / d);
        } else {
            double v = 0.0017453292519943296 * this.keyModfiedSpeed(e.getModifiersEx());
            this.dLambda = v * (double)this.dX;
            this.dPhi = -v * (double)this.dY;
        }
        this.update(true);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dPhi = 0.0;
        this.dLambda = 0.0;
        this.oRho = this.rho;
        this.update(false);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.naviMode == NaviMode.ROLL_ONLY) {
            this.oX = width / 2;
            this.oY = height / 2;
            this.dX = this.oX - e.getX();
            this.dY = this.oY - e.getY();
            double d = Math.sqrt(this.dX * this.dX + this.dY * this.dY);
            this.oRho -= Math.atan2((double)this.dY / d, (double)this.dX / d);
        } else {
            this.oX = e.getX();
            this.oY = e.getY();
        }
    }

    protected static final void visualize(ImagePlus imp, int w, int h, EquirectangularProjection p) {
        try {
            int y;
            double dx;
            int x;
            double maxD = imp.getWidth() / 2;
            GeneralPath gp = new GeneralPath();
            double[] l = new double[]{0.0, 0.0};
            p.applyInverseInPlace(l);
            double x0 = l[0];
            gp.moveTo(l[0], l[1]);
            for (x = 1; x < w; ++x) {
                l[0] = x;
                l[1] = 0.0;
                p.applyInverseInPlace(l);
                dx = l[0] - x0;
                if (dx > maxD) {
                    gp.lineTo(l[0] - (double)imp.getWidth(), l[1]);
                    gp.moveTo(l[0], l[1]);
                } else if (dx < -maxD) {
                    gp.lineTo(l[0] + (double)imp.getWidth(), l[1]);
                    gp.moveTo(l[0], l[1]);
                } else {
                    gp.lineTo(l[0], l[1]);
                }
                x0 = l[0];
            }
            for (y = 1; y < h; ++y) {
                l[0] = w - 1;
                l[1] = y;
                p.applyInverseInPlace(l);
                dx = l[0] - x0;
                if (dx > maxD) {
                    gp.lineTo(l[0] - (double)imp.getWidth(), l[1]);
                    gp.moveTo(l[0], l[1]);
                } else if (dx < -maxD) {
                    gp.lineTo(l[0] + (double)imp.getWidth(), l[1]);
                    gp.moveTo(l[0], l[1]);
                } else {
                    gp.lineTo(l[0], l[1]);
                }
                x0 = l[0];
            }
            for (x = w - 2; x >= 0; --x) {
                l[0] = x;
                l[1] = h - 1;
                p.applyInverseInPlace(l);
                dx = l[0] - x0;
                if (dx > maxD) {
                    gp.lineTo(l[0] - (double)imp.getWidth(), l[1]);
                    gp.moveTo(l[0], l[1]);
                } else if (dx < -maxD) {
                    gp.lineTo(l[0] + (double)imp.getWidth(), l[1]);
                    gp.moveTo(l[0], l[1]);
                } else {
                    gp.lineTo(l[0], l[1]);
                }
                x0 = l[0];
            }
            for (y = h - 2; y >= 0; --y) {
                l[0] = 0.0;
                l[1] = y;
                p.applyInverseInPlace(l);
                dx = l[0] - x0;
                if (dx > maxD) {
                    gp.lineTo(l[0] - (double)imp.getWidth(), l[1]);
                    gp.moveTo(l[0], l[1]);
                } else if (dx < -maxD) {
                    gp.lineTo(l[0] + (double)imp.getWidth(), l[1]);
                    gp.moveTo(l[0], l[1]);
                } else {
                    gp.lineTo(l[0], l[1]);
                }
                x0 = l[0];
            }
            imp.getCanvas().setDisplayList((Shape)gp, Color.YELLOW, null);
            imp.updateAndDraw();
        }
        catch (NoninvertibleModelException noninvertibleModelException) {
            // empty catch block
        }
    }

    protected abstract class AbstractMappingThread
    extends Thread {
        protected final ImagePlus impSource;
        protected final ImagePlus impTarget;
        protected final ImageProcessor target;
        protected final ImageProcessor temp;
        protected boolean visualize = true;
        protected boolean pleaseRepaint;
        protected boolean keepPainting;
        protected double dt = 1.0;

        public AbstractMappingThread(ImagePlus impSource, ImagePlus impTarget, ImageProcessor target) {
            this.impSource = impSource;
            this.impTarget = impTarget;
            this.target = target;
            this.temp = target.createProcessor(target.getWidth(), target.getHeight());
            this.temp.snapshot();
            this.setName("MappingThread");
        }

        protected abstract void map();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            while (!this.isInterrupted()) {
                boolean b;
                AbstractMappingThread abstractMappingThread = this;
                synchronized (abstractMappingThread) {
                    b = this.pleaseRepaint;
                    this.pleaseRepaint = this.keepPainting;
                }
                if (b) {
                    long t = System.currentTimeMillis();
                    this.map();
                    Object targetPixels = this.target.getPixels();
                    this.target.setPixels(this.temp.getPixels());
                    this.temp.setPixels(targetPixels);
                    this.impTarget.updateAndDraw();
                    if (this.visualize) {
                        AbstractPanorama_View.visualize(this.impSource, this.temp.getWidth(), this.temp.getHeight(), AbstractPanorama_View.this.p);
                    }
                    this.dt = (float)(System.currentTimeMillis() - t) / 1000.0f;
                }
                abstractMappingThread = this;
                synchronized (abstractMappingThread) {
                    try {
                        if (!this.pleaseRepaint) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void repaint(boolean keepPainting) {
            AbstractMappingThread abstractMappingThread = this;
            synchronized (abstractMappingThread) {
                this.keepPainting = keepPainting;
                this.pleaseRepaint = true;
                this.notify();
            }
        }

        public abstract void toggleInterpolation();

        public final void toggleVisualization() {
            this.visualize = !this.visualize;
        }
    }

    protected abstract class Mapper {
        protected boolean interpolate = true;

        protected Mapper() {
        }

        public abstract void map(ImageProcessor var1);

        public final void toggleInterpolation() {
            this.interpolate = !this.interpolate;
        }
    }

    protected class GUI {
        private final ImageWindow window;
        private final Canvas canvas;
        private final ImageJ ij;
        private KeyListener[] windowKeyListeners;
        private KeyListener[] canvasKeyListeners;
        private KeyListener[] ijKeyListeners;
        private MouseListener[] canvasMouseListeners;
        private MouseMotionListener[] canvasMouseMotionListeners;
        private MouseWheelListener[] windowMouseWheelListeners;

        GUI(ImagePlus imp) {
            this.window = imp.getWindow();
            this.canvas = imp.getCanvas();
            this.ij = IJ.getInstance();
        }

        public final void close() {
            this.window.close();
        }

        protected void takeOverGui() {
            this.canvas.addKeyListener(AbstractPanorama_View.this);
            this.window.addKeyListener((KeyListener)AbstractPanorama_View.this);
            this.canvas.addMouseMotionListener(AbstractPanorama_View.this);
            this.canvas.addMouseListener(AbstractPanorama_View.this);
            this.ij.addKeyListener((KeyListener)AbstractPanorama_View.this);
            this.window.addMouseWheelListener((MouseWheelListener)AbstractPanorama_View.this);
        }

        final void backupGui() {
            this.canvasKeyListeners = this.canvas.getKeyListeners();
            this.windowKeyListeners = this.window.getKeyListeners();
            this.ijKeyListeners = IJ.getInstance().getKeyListeners();
            this.canvasMouseListeners = this.canvas.getMouseListeners();
            this.canvasMouseMotionListeners = this.canvas.getMouseMotionListeners();
            this.windowMouseWheelListeners = this.window.getMouseWheelListeners();
            this.clearGui();
        }

        final void restoreGui() {
            this.clearGui();
            for (KeyListener keyListener : this.canvasKeyListeners) {
                this.canvas.addKeyListener(keyListener);
            }
            for (KeyListener keyListener : this.windowKeyListeners) {
                this.window.addKeyListener(keyListener);
            }
            for (KeyListener keyListener : this.ijKeyListeners) {
                this.ij.addKeyListener(keyListener);
            }
            for (EventListener eventListener : this.canvasMouseListeners) {
                this.canvas.addMouseListener((MouseListener)eventListener);
            }
            for (EventListener eventListener : this.canvasMouseMotionListeners) {
                this.canvas.addMouseMotionListener((MouseMotionListener)eventListener);
            }
            for (EventListener eventListener : this.windowMouseWheelListeners) {
                this.window.addMouseWheelListener((MouseWheelListener)eventListener);
            }
        }

        final void clearGui() {
            for (KeyListener keyListener : this.canvasKeyListeners) {
                this.canvas.removeKeyListener(keyListener);
            }
            for (KeyListener keyListener : this.windowKeyListeners) {
                this.window.removeKeyListener(keyListener);
            }
            for (KeyListener keyListener : this.ijKeyListeners) {
                this.ij.removeKeyListener(keyListener);
            }
            for (EventListener eventListener : this.canvasMouseListeners) {
                this.canvas.removeMouseListener((MouseListener)eventListener);
            }
            for (EventListener eventListener : this.canvasMouseMotionListeners) {
                this.canvas.removeMouseMotionListener((MouseMotionListener)eventListener);
            }
            for (EventListener eventListener : this.windowMouseWheelListeners) {
                this.window.removeMouseWheelListener((MouseWheelListener)eventListener);
            }
            this.canvas.removeKeyListener(AbstractPanorama_View.this);
            this.window.removeKeyListener((KeyListener)AbstractPanorama_View.this);
            this.ij.removeKeyListener((KeyListener)AbstractPanorama_View.this);
            this.canvas.removeMouseListener(AbstractPanorama_View.this);
            this.canvas.removeMouseMotionListener(AbstractPanorama_View.this);
            this.window.removeMouseWheelListener((MouseWheelListener)AbstractPanorama_View.this);
        }
    }

    private static enum NaviMode {
        PAN_TILT,
        PAN_ONLY,
        TILT_ONLY,
        ROLL_ONLY;

    }
}

