/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.panorama;

import ij.process.ImageProcessor;
import mpicbg.ij.InverseTransformMapping;
import mpicbg.models.InverseCoordinateTransform;
import mpicbg.models.NoninvertibleModelException;

public class HomogeneousMapping<T extends InverseCoordinateTransform>
extends InverseTransformMapping<T> {
    public HomogeneousMapping(T t) {
        super(t);
    }

    public void map(ImageProcessor source, ImageProcessor target) {
        double[] t = new double[3];
        int sw = source.getWidth() - 1;
        int sh = source.getHeight() - 1;
        int tw = target.getWidth();
        int th = target.getHeight();
        for (int y = 0; y < th; ++y) {
            int row = tw * y;
            for (int x = 0; x < tw; ++x) {
                t[0] = x;
                t[1] = y;
                t[2] = 1.0;
                try {
                    this.transform.applyInverseInPlace(t);
                    double h = t[2];
                    int tx = (int)(t[0] + 0.5);
                    int ty = (int)(t[1] + 0.5);
                    if (!(h >= 0.0) || tx < 0 || tx > sw || ty < 0 || ty > sh) continue;
                    target.set(row + x, source.getPixel(tx, ty));
                    continue;
                }
                catch (NoninvertibleModelException noninvertibleModelException) {
                    // empty catch block
                }
            }
        }
    }

    public void mapInterpolated(ImageProcessor source, ImageProcessor target) {
        double[] t = new double[3];
        int sw = source.getWidth() - 1;
        int sh = source.getHeight() - 1;
        int tw = target.getWidth();
        int th = target.getHeight();
        for (int y = 0; y < th; ++y) {
            for (int x = 0; x < tw; ++x) {
                t[0] = x;
                t[1] = y;
                t[2] = 1.0;
                try {
                    this.transform.applyInverseInPlace(t);
                    double h = t[2];
                    double tx = t[0];
                    double ty = t[1];
                    if (!(h >= 0.0) || !(tx >= 0.0) || !(tx <= (double)sw) || !(ty >= 0.0) || !(ty <= (double)sh)) continue;
                    target.putPixel(x, y, source.getPixelInterpolated(tx, ty));
                    continue;
                }
                catch (NoninvertibleModelException noninvertibleModelException) {
                    // empty catch block
                }
            }
        }
    }
}

