/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging;

import ij.process.ImageStatistics;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class ContrastPlot
extends Canvas {
    private static final long serialVersionUID = 1L;
    static final int WIDTH = 128;
    static final int HEIGHT = 64;
    double defaultMin = 0.0;
    double defaultMax = 255.0;
    double min = 0.0;
    double max = 255.0;
    int[] histogram;
    int hmax;
    Image os;
    Color color = Color.gray;

    public ContrastPlot(double defaultMin, double defaultMax, double firstMin, double firstMax) {
        this.setSize(129, 65);
        this.defaultMin = defaultMin;
        this.defaultMax = defaultMax;
        this.min = firstMin;
        this.max = firstMax;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(129, 65);
    }

    public void setHistogram(ImageStatistics stats, Color color) {
        this.color = color;
        this.histogram = stats.histogram;
        if (this.histogram.length != 256) {
            this.histogram = null;
            return;
        }
        for (int i = 0; i < 128; ++i) {
            this.histogram[i] = (this.histogram[2 * i] + this.histogram[2 * i + 1]) / 2;
        }
        int maxCount = 0;
        int mode = 0;
        for (int i = 0; i < 128; ++i) {
            if (this.histogram[i] <= maxCount) continue;
            maxCount = this.histogram[i];
            mode = i;
        }
        int maxCount2 = 0;
        for (int i = 0; i < 128; ++i) {
            if (this.histogram[i] <= maxCount2 || i == mode) continue;
            maxCount2 = this.histogram[i];
        }
        this.hmax = stats.maxCount;
        if (this.hmax > maxCount2 * 2 && maxCount2 != 0) {
            this.histogram[mode] = this.hmax = (int)((double)maxCount2 * 1.5);
        }
        this.os = null;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        int y2;
        int x2;
        int y1;
        int x1;
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        double scale = 128.0 / (this.defaultMax - this.defaultMin);
        double slope = 0.0;
        if (this.max != this.min) {
            slope = 64.0 / (this.max - this.min);
        }
        if (this.min >= this.defaultMin) {
            x1 = (int)(scale * (this.min - this.defaultMin));
            y1 = 64;
        } else {
            x1 = 0;
            y1 = this.max > this.min ? 64 - (int)((this.defaultMin - this.min) * slope) : 64;
        }
        if (this.max <= this.defaultMax) {
            x2 = (int)(scale * (this.max - this.defaultMin));
            y2 = 0;
        } else {
            x2 = 128;
            y2 = this.max > this.min ? 64 - (int)((this.defaultMax - this.min) * slope) : 0;
        }
        if (this.histogram != null) {
            if (this.os == null && this.hmax != 0) {
                this.os = this.createImage(128, 64);
                Graphics osg = this.os.getGraphics();
                osg.setColor(Color.white);
                osg.fillRect(0, 0, 128, 64);
                osg.setColor(this.color);
                for (int i = 0; i < 128; ++i) {
                    osg.drawLine(i, 64, i, 64 - 64 * this.histogram[i] / this.hmax);
                }
                osg.dispose();
            }
            if (this.os != null) {
                g.drawImage(this.os, 0, 0, this);
            }
        } else {
            g.setColor(Color.white);
            g.fillRect(0, 0, 128, 64);
        }
        g.setColor(Color.black);
        g.drawLine(x1, y1, x2, y2);
        g.drawLine(x2, 59, x2, 64);
        g.drawRect(0, 0, 128, 64);
    }

    public void update(double min, double max) {
        this.min = min;
        this.max = max;
        this.repaint();
    }

    public void setDefaultMinAndMax(double min, double max) {
        this.defaultMin = min;
        this.defaultMax = max;
        System.out.println("default min/max are " + min + ", " + max);
    }
}

