/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.parallel;

import ini.trakem2.parallel.Process;
import ini.trakem2.parallel.TaskFactory;
import ini.trakem2.utils.Utils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;

public final class ParallelMapping<I, O>
implements Iterable<O> {
    private final Iterator<I> in;
    private final int n_proc;
    private final TaskFactory<I, O> generator;

    public ParallelMapping(Iterable<I> inputs, TaskFactory<I, O> generator) {
        this(Runtime.getRuntime().availableProcessors(), inputs.iterator(), generator);
    }

    public ParallelMapping(Iterator<I> inputs, TaskFactory<I, O> generator) {
        this(Runtime.getRuntime().availableProcessors(), inputs, generator);
    }

    public ParallelMapping(int n_proc, Iterable<I> inputs, TaskFactory<I, O> generator) {
        this(n_proc, inputs.iterator(), generator);
    }

    public ParallelMapping(int n_proc, Iterator<I> inputs, TaskFactory<I, O> generator) {
        this.in = inputs;
        this.n_proc = Process.sensible(n_proc);
        this.generator = generator;
    }

    @Override
    public Iterator<O> iterator() {
        if (!this.in.hasNext()) {
            return null;
        }
        final ThreadPoolExecutor exec = Utils.newFixedThreadPool(this.n_proc, ParallelMapping.class.getSimpleName());
        final LinkedList futures = new LinkedList();
        return new Iterator<O>(){

            @Override
            public boolean hasNext() {
                boolean b;
                boolean bl = b = !futures.isEmpty() || ParallelMapping.this.in.hasNext();
                if (!b) {
                    exec.shutdown();
                }
                return b;
            }

            @Override
            public O next() {
                if (futures.size() < ParallelMapping.this.n_proc / 2) {
                    for (int i = 0; i < ParallelMapping.this.n_proc; ++i) {
                        if (!ParallelMapping.this.in.hasNext()) {
                            exec.shutdown();
                            break;
                        }
                        futures.add(exec.submit(ParallelMapping.this.generator.create(ParallelMapping.this.in.next())));
                    }
                }
                try {
                    return ((Future)futures.removeFirst()).get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

