/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.util;

import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import mpicbg.ij.integral.BlockStatistics;
import mpicbg.ij.plugin.RemoveOutliers;
import mpicbg.trakem2.util.Downsampler;
import mpicbg.util.Util;

public class RobustNormalizeLocalContrast {
    /*
     * WARNING - void declaration
     */
    public static final void run(final ImageProcessor ip, int scaleLevel, int brx1, int bry1, float stds1, int brx2, int bry2, final float stds2) {
        int i;
        int ys;
        void var31_36;
        int i2;
        double stdCD;
        double meanCD;
        int ys2;
        double min;
        double d;
        double stdAB;
        double meanAB;
        final PixelSetter setter = ByteProcessor.class.isInstance(ip) ? new ByteSetter((ByteProcessor)ip) : (ShortProcessor.class.isInstance(ip) ? new ShortSetter((ShortProcessor)ip) : new FloatSetter(ip));
        final int scale = (int)Util.pow((int)2, (int)scaleLevel);
        final int scale2 = scale / 2;
        final double[] f = new double[scale];
        for (int i3 = 0; i3 < scale; ++i3) {
            f[i3] = ((double)i3 + 0.5) / (double)scale;
        }
        int sbrx1 = brx1 / scale;
        int sbry1 = bry1 / scale;
        int sbrx2 = brx2 / scale;
        int sbry2 = bry2 / scale;
        final int ipWidth = ip.getWidth();
        int ipHeight = ip.getHeight();
        final double ipMin = ip.getMin();
        final double ipLength = ip.getMax() - ipMin;
        FloatProcessor ipScaled = (FloatProcessor)ip.convertToFloat();
        for (int i4 = 0; i4 < scaleLevel; ++i4) {
            ipScaled = Downsampler.downsampleFloatProcessor((FloatProcessor)ipScaled);
        }
        final FloatProcessor std = ipScaled;
        RemoveOutliers.run((ImageProcessor)std, (int)sbrx1, (int)sbry1, (float)stds1);
        BlockStatistics bs = new BlockStatistics(std);
        bs.mean(sbrx2, sbry2);
        final FloatProcessor mean = (FloatProcessor)std.duplicate();
        bs.std(sbrx2, sbry2);
        final int w = mean.getWidth();
        int h = mean.getHeight();
        ExecutorService exec = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ArrayList tasks = new ArrayList();
        int y = 1;
        while (y < h) {
            final int n = y - 1;
            final int yb = y++;
            tasks.add(exec.submit(new Runnable(){

                @Override
                public final void run() {
                    for (int x = 1; x < w; ++x) {
                        int xa = x - 1;
                        float meanA = mean.getf(xa, n);
                        float meanB = mean.getf(x, n);
                        float meanC = mean.getf(xa, yb);
                        float meanD = mean.getf(x, yb);
                        float stdA = std.getf(xa, n);
                        float stdB = std.getf(x, n);
                        float stdC = std.getf(xa, yb);
                        float stdD = std.getf(x, yb);
                        int ys = yb * scale - scale2;
                        int xss = x * scale - scale2;
                        for (int yi = 0; yi < scale; ++yi) {
                            int xs = xss;
                            for (int xi = 0; xi < scale; ++xi) {
                                double meanAB = (double)meanA * f[xi] + (double)meanB * (1.0 - f[xi]);
                                double meanCD = (double)meanC * f[xi] + (double)meanD * (1.0 - f[xi]);
                                double meanABCD = meanAB * f[yi] + meanCD * (1.0 - f[yi]);
                                double stdAB = (double)stdA * f[xi] + (double)stdB * (1.0 - f[xi]);
                                double stdCD = (double)stdC * f[xi] + (double)stdD * (1.0 - f[xi]);
                                double stdABCD = stdAB * f[yi] + stdCD * (1.0 - f[yi]);
                                double d = (double)stds2 * stdABCD;
                                double min = meanABCD - d;
                                int i = ys * ipWidth + xs;
                                setter.setf(i, (float)(((double)ip.getf(i) - min) / 2.0 / d * ipLength + ipMin));
                                ++xs;
                            }
                            ++ys;
                        }
                    }
                }
            }));
        }
        for (Future future : tasks) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                exec.shutdownNow();
                return;
            }
            catch (ExecutionException e) {
                exec.shutdownNow();
                return;
            }
        }
        tasks.clear();
        exec.shutdown();
        for (int x = 1; x < w; ++x) {
            int xi;
            int xs;
            int n = x - 1;
            float meanA = mean.getf(n, 0);
            float meanB = mean.getf(x, 0);
            float meanC = mean.getf(n, h - 1);
            float meanD = mean.getf(x, h - 1);
            float stdA = std.getf(n, 0);
            float stdB = std.getf(x, 0);
            float stdC = std.getf(n, h - 1);
            float stdD = std.getf(x, h - 1);
            int xss = x * scale - scale2;
            for (int ys22 = 0; ys22 < scale2; ++ys22) {
                xs = xss;
                for (xi = 0; xi < scale; ++xi) {
                    meanAB = (double)meanA * f[xi] + (double)meanB * (1.0 - f[xi]);
                    stdAB = (double)stdA * f[xi] + (double)stdB * (1.0 - f[xi]);
                    d = (double)stds2 * stdAB;
                    min = meanAB - d;
                    int i22 = ys22 * ipWidth + xs;
                    setter.setf(i22, (float)(((double)ip.getf(i22) - min) / 2.0 / d * ipLength + ipMin));
                    ++xs;
                }
            }
            for (ys2 = h * scale - scale2; ys2 < ipHeight; ++ys2) {
                xs = xss;
                for (xi = 0; xi < scale; ++xi) {
                    meanCD = (double)meanC * f[xi] + (double)meanD * (1.0 - f[xi]);
                    stdCD = (double)stdC * f[xi] + (double)stdD * (1.0 - f[xi]);
                    d = (double)stds2 * stdCD;
                    min = meanCD - d;
                    i2 = ys2 * ipWidth + xs;
                    setter.setf(i2, (float)(((double)ip.getf(i2) - min) / 2.0 / d * ipLength + ipMin));
                    ++xs;
                }
            }
        }
        int xss = w * scale - scale2;
        boolean bl = true;
        while (var31_36 < h) {
            void ya = var31_36 - true;
            float meanA = mean.getf(0, (int)ya);
            float meanB = mean.getf(0, (int)var31_36);
            float meanC = mean.getf(w - 1, (int)ya);
            float meanD = mean.getf(w - 1, (int)var31_36);
            float stdA = std.getf(0, (int)ya);
            float stdB = std.getf(0, (int)var31_36);
            float stdC = std.getf(w - 1, (int)ya);
            float stdD = std.getf(w - 1, (int)var31_36);
            ys2 = var31_36 * scale - scale2;
            for (int yi = 0; yi < scale; ++yi) {
                int xs;
                for (xs = 0; xs < scale2; ++xs) {
                    meanAB = (double)meanA * f[yi] + (double)meanB * (1.0 - f[yi]);
                    stdAB = (double)stdA * f[yi] + (double)stdB * (1.0 - f[yi]);
                    d = (double)stds2 * stdAB;
                    min = meanAB - d;
                    i2 = ys2 * ipWidth + xs;
                    setter.setf(i2, (float)(((double)ip.getf(i2) - min) / 2.0 / d * ipLength + ipMin));
                }
                for (xs = xss; xs < ipWidth; ++xs) {
                    meanCD = (double)meanC * f[yi] + (double)meanD * (1.0 - f[yi]);
                    stdCD = (double)stdC * f[yi] + (double)stdD * (1.0 - f[yi]);
                    d = (double)stds2 * stdCD;
                    min = meanCD - d;
                    i2 = ys2 * ipWidth + xs;
                    setter.setf(i2, (float)(((double)ip.getf(i2) - min) / 2.0 / d * ipLength + ipMin));
                }
                ++ys2;
            }
            ++var31_36;
        }
        float f2 = mean.getf(0, 0);
        float meanB = mean.getf(w - 1, 0);
        float meanC = mean.getf(0, h - 1);
        float meanD = mean.getf(w - 1, h - 1);
        float stdA = std.getf(0, 0);
        float stdB = std.getf(w - 1, 0);
        float stdC = std.getf(0, h - 1);
        float stdD = std.getf(w - 1, h - 1);
        for (ys = 0; ys < scale2; ++ys) {
            int xs;
            for (xs = 0; xs < scale2; ++xs) {
                double d2 = stds2 * stdA;
                double min2 = (double)f2 - d2;
                i = ys * ipWidth + xs;
                setter.setf(i, (float)(((double)ip.getf(i) - min2) / 2.0 / d2 * ipLength + ipMin));
            }
            for (xs = xss; xs < ipWidth; ++xs) {
                double d2 = stds2 * stdB;
                double min2 = (double)meanB - d2;
                i = ys * ipWidth + xs;
                setter.setf(i, (float)(((double)ip.getf(i) - min2) / 2.0 / d2 * ipLength + ipMin));
            }
        }
        for (ys = h * scale - scale2; ys < ipHeight; ++ys) {
            int xs;
            for (xs = 0; xs < scale2; ++xs) {
                double d3 = stds2 * stdC;
                double min3 = (double)meanC - d3;
                i = ys * ipWidth + xs;
                setter.setf(i, (float)(((double)ip.getf(i) - min3) / 2.0 / d3 * ipLength + ipMin));
            }
            for (xs = xss; xs < ipWidth; ++xs) {
                double d3 = stds2 * stdD;
                double min3 = (double)meanD - d3;
                i = ys * ipWidth + xs;
                setter.setf(i, (float)(((double)ip.getf(i) - min3) / 2.0 / d3 * ipLength + ipMin));
            }
        }
    }

    protected static final class ShortSetter
    implements PixelSetter {
        protected final ShortProcessor ip;

        public ShortSetter(ShortProcessor ip) {
            this.ip = ip;
        }

        @Override
        public void setf(int i, float value) {
            this.ip.set(i, Math.max(0, Math.min(65535, Util.roundPos((float)value))));
        }
    }

    protected static final class ByteSetter
    implements PixelSetter {
        protected final ByteProcessor ip;

        public ByteSetter(ByteProcessor ip) {
            this.ip = ip;
        }

        @Override
        public void setf(int i, float value) {
            this.ip.set(i, Math.max(0, Math.min(255, Util.roundPos((float)value))));
        }
    }

    protected static final class FloatSetter
    implements PixelSetter {
        protected final ImageProcessor ip;

        public FloatSetter(ImageProcessor ip) {
            this.ip = ip;
        }

        @Override
        public void setf(int i, float value) {
            this.ip.setf(i, value);
        }
    }

    protected static interface PixelSetter {
        public void setf(int var1, float var2);
    }
}

