/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.randomaccessibleinterval.unary;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.ops.operation.randomaccessibleinterval.unary.regiongrowing.AbstractRegionGrowing;
import net.imglib2.ops.types.ConnectedType;
import net.imglib2.outofbounds.OutOfBoundsConstantValue;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.type.Type;

@Deprecated
public abstract class AbstractGrayscaleReconstruction<T extends Type<T>, V extends Type<V>>
implements UnaryOperation<RandomAccessibleInterval<T>, RandomAccessibleInterval<V>> {
    private final ConnectedType m_connection;
    private long[][] m_neighboursPlus;
    private long[][] m_neighboursMinus;
    private long[][] m_neighbours;
    private final Queue<int[]> m_queue = new LinkedList<int[]>();

    public AbstractGrayscaleReconstruction(ConnectedType connection) {
        this.m_connection = connection;
    }

    protected AbstractGrayscaleReconstruction(AbstractGrayscaleReconstruction<T, V> copy) {
        this.m_connection = copy.m_connection;
    }

    private void setUpNeighbours(int dims) {
        switch (this.m_connection) {
            case FOUR_CONNECTED: {
                this.m_neighboursPlus = this.get4ConNeighbourhoodPlus(dims);
                this.m_neighboursMinus = this.get4ConNeighbourhoodMinus(dims);
                this.m_neighbours = AbstractRegionGrowing.get4ConStructuringElement(dims);
                break;
            }
            case EIGHT_CONNECTED: {
                this.m_neighboursPlus = this.get8ConNeighbourhoodPlus(dims);
                this.m_neighboursMinus = this.get8ConNeighbourhoodMinus(dims);
                this.m_neighbours = AbstractRegionGrowing.get8ConStructuringElement(dims);
            }
        }
    }

    @Override
    public RandomAccessibleInterval<V> compute(RandomAccessibleInterval<T> input, RandomAccessibleInterval<V> output) {
        this.setUpNeighbours(input.numDimensions());
        Type zeroV = ((Type)output.randomAccess().get()).createVariable();
        zeroV.set(this.getVMinValue(zeroV));
        OutOfBoundsConstantValue marker = new OutOfBoundsConstantValueFactory((Object)zeroV).create(output);
        Cursor<V> cur = new Cursor<V>(output);
        Type zeroT = ((Type)input.randomAccess().get()).createVariable();
        zeroT.set(this.getTMinValue(zeroT));
        OutOfBoundsConstantValue mask = new OutOfBoundsConstantValueFactory((Object)zeroT).create(input);
        this.scanInRasterOrder(cur, (RandomAccess<V>)marker, (RandomAccess<T>)mask);
        this.scanInAntiRasterOrder(cur, (RandomAccess<V>)marker, (RandomAccess<T>)mask);
        this.propagate((RandomAccess<V>)marker, (RandomAccess<T>)mask, this.m_neighbours);
        return output;
    }

    private void scanInAntiRasterOrder(Cursor<V> cur, RandomAccess<V> marker, RandomAccess<T> mask) {
        assert (cur != null);
        assert (marker != null);
        assert (mask != null);
        cur.setLastPos();
        while (cur.hasNextBwd()) {
            cur.get().set(this.checkAroundCursor(cur, marker, mask, this.m_neighboursMinus));
            this.checkPixels(cur, marker, mask, this.m_neighboursMinus);
            cur.bwd();
        }
    }

    private void scanInRasterOrder(Cursor<V> cur, RandomAccess<V> marker, RandomAccess<T> mask) {
        assert (cur != null);
        assert (marker != null);
        assert (mask != null);
        cur.setToOrigin();
        while (cur.hasNextFwd()) {
            cur.get().set(this.checkAroundCursor(cur, marker, mask, this.m_neighboursPlus));
            cur.fwd();
        }
    }

    private V checkAroundCursor(Cursor<V> cur, RandomAccess<V> marker, RandomAccess<T> mask, long[][] strucElement) {
        Type val = cur.get().copy();
        for (long[] e : strucElement) {
            for (int i = 0; i < e.length; ++i) {
                marker.setPosition((long)cur.getIntPosition(i) + e[i], i);
            }
            val = this.morphOp(val.copy(), ((Type)marker.get()).copy());
        }
        mask.setPosition(cur.getRandomAccess());
        val = this.pointwiseOp(val, (Type)mask.get());
        return (V)val;
    }

    private void checkPixels(Cursor<V> cur, RandomAccess<V> marker, RandomAccess<T> mask, long[][] strucElement) {
        Type p = cur.get().copy();
        for (long[] e : strucElement) {
            Type i;
            for (int i2 = 0; i2 < e.length; ++i2) {
                marker.setPosition((long)cur.getIntPosition(i2) + e[i2], i2);
                mask.setPosition((long)cur.getIntPosition(i2) + e[i2], i2);
            }
            Type q = ((Type)marker.get()).copy();
            if (!this.checkPixelAddToQueue(p, q, i = ((Type)mask.get()).copy())) continue;
            this.addToQueue(cur.getRandomAccess());
            return;
        }
    }

    protected void propagate(RandomAccess<V> marker, RandomAccess<T> mask, long[][] strucElement) {
        while (!this.m_queue.isEmpty()) {
            int[] p = this.m_queue.poll();
            marker.setPosition(p);
            Type val = ((Type)marker.get()).copy();
            for (long[] e : strucElement) {
                Type i;
                for (int i2 = 0; i2 < e.length; ++i2) {
                    marker.setPosition((long)p[i2] + e[i2], i2);
                    mask.setPosition((long)p[i2] + e[i2], i2);
                }
                Type q = ((Type)marker.get()).copy();
                if (!this.checkPixelFromQueue(val, q, i = ((Type)mask.get()).copy())) continue;
                ((Type)marker.get()).set(this.pointwiseOp(val, i));
                this.addToQueue(marker);
            }
        }
    }

    protected abstract boolean checkPixelFromQueue(V var1, V var2, T var3);

    protected abstract boolean checkPixelAddToQueue(V var1, V var2, T var3);

    protected abstract V morphOp(V var1, V var2);

    protected abstract V pointwiseOp(V var1, T var2);

    protected abstract V getVMinValue(V var1);

    protected abstract T getTMinValue(T var1);

    protected final void addToQueue(RandomAccess<V> ra) {
        int[] pos = new int[ra.numDimensions()];
        ra.localize(pos);
        this.m_queue.add(pos);
    }

    private long[][] get4ConNeighbourhoodPlus(int dimensions) {
        assert (dimensions > 1);
        return this.get4ConNeighbourhood(dimensions, -1);
    }

    private long[][] get4ConNeighbourhoodMinus(int dimensions) {
        assert (dimensions > 1);
        return this.get4ConNeighbourhood(dimensions, 1);
    }

    private long[][] get4ConNeighbourhood(int dimensions, int step) {
        assert (dimensions > 1);
        assert (step == 1 || step == -1);
        int nElements = dimensions;
        long[][] result = new long[nElements][dimensions];
        for (int d = 0; d < dimensions; ++d) {
            result[d] = new long[dimensions];
            result[d][d] = step;
        }
        return result;
    }

    private long[][] get8ConNeighbourhoodPlus(int dimensions) {
        assert (dimensions > 1);
        long[][] result = this.prepareStructElement(dimensions);
        long[] position = new long[dimensions];
        Arrays.fill(position, -1L);
        for (int i = 0; i < result.length; ++i) {
            System.arraycopy(position, 0, result[i], 0, dimensions);
            if (i == result.length / 2 - 1) {
                position[0] = position[0] + 2L;
                continue;
            }
            position = this.nextPosition(position);
        }
        return result;
    }

    private long[][] get8ConNeighbourhoodMinus(int dimensions) {
        assert (dimensions > 1);
        long[][] result = this.prepareStructElement(dimensions);
        long[] position = new long[dimensions];
        Arrays.fill(position, 0L);
        position[0] = 1L;
        for (int i = 0; i < result.length; ++i) {
            System.arraycopy(position, 0, result[i], 0, dimensions);
            position = this.nextPosition(position);
        }
        return result;
    }

    private long[][] prepareStructElement(int dims) {
        assert (dims > 1);
        int nElements = 1;
        for (int i = 0; i < dims; ++i) {
            nElements *= 3;
        }
        nElements = (nElements - 1) / 2;
        return new long[nElements][dims];
    }

    private long[] nextPosition(long[] pos) {
        assert (pos != null);
        for (int j = 0; j < pos.length; ++j) {
            if (pos[j] != 1L) {
                int n = j;
                pos[n] = pos[n] + 1L;
                break;
            }
            pos[j] = -1L;
        }
        return pos;
    }

    private long numPixels(Interval i) {
        assert (i != null);
        long[] dims = new long[i.numDimensions()];
        i.dimensions(dims);
        long acc = 1L;
        for (long l : dims) {
            acc *= l;
        }
        return acc;
    }

    protected final class Cursor<U extends Type<U>> {
        private final RandomAccess<U> m_ra;
        private final long[] m_breaks;
        private final long[] m_lastPos;
        private final long m_numPixel;
        private long m_count = 0L;

        public Cursor(RandomAccessibleInterval<U> ra) {
            int i;
            this.m_ra = ra.randomAccess();
            this.m_numPixel = AbstractGrayscaleReconstruction.this.numPixels(ra);
            this.m_lastPos = new long[ra.numDimensions()];
            for (i = 0; i < this.m_lastPos.length; ++i) {
                this.m_lastPos[i] = ra.dimension(i) - 1L;
            }
            this.m_breaks = new long[ra.numDimensions()];
            ra.dimensions(this.m_breaks);
            for (i = 1; i < this.m_breaks.length; ++i) {
                int n = i;
                this.m_breaks[n] = this.m_breaks[n] * this.m_breaks[i - 1];
            }
            this.setToOrigin();
        }

        public void fwd() {
            ++this.m_count;
            if (this.m_count % this.m_breaks[0] == 0L) {
                this.m_ra.setPosition(0, 0);
                this.m_ra.fwd(1);
                for (int i = 1; i < this.m_breaks.length - 1; ++i) {
                    if (this.m_count % this.m_breaks[i] != 0L) continue;
                    this.m_ra.setPosition(0, i);
                    this.m_ra.fwd(i + 1);
                }
            } else {
                this.m_ra.fwd(0);
            }
        }

        public void bwd() {
            if (this.m_count % this.m_breaks[0] == 0L) {
                this.m_ra.setPosition(this.m_lastPos[0], 0);
                this.m_ra.bck(1);
                for (int i = 1; i < this.m_breaks.length - 1; ++i) {
                    if (this.m_count % this.m_breaks[i] != 0L) continue;
                    this.m_ra.setPosition(this.m_lastPos[i], i);
                    this.m_ra.bck(i + 1);
                }
            } else {
                this.m_ra.bck(0);
            }
            --this.m_count;
        }

        public void setLastPos() {
            this.m_ra.setPosition(this.m_lastPos);
            this.m_count = this.m_numPixel - 1L;
        }

        public void setToOrigin() {
            long[] pos = new long[this.m_ra.numDimensions()];
            Arrays.fill(pos, 0L);
            this.m_ra.setPosition(pos);
            this.m_count = 0L;
        }

        public boolean hasNextFwd() {
            return this.m_count < this.m_numPixel;
        }

        public boolean hasNextBwd() {
            return this.m_count > 0L;
        }

        public RandomAccess<U> getRandomAccess() {
            return this.m_ra;
        }

        public U get() {
            return (U)((Type)this.m_ra.get());
        }

        public int getIntPosition(int d) {
            return this.m_ra.getIntPosition(d);
        }
    }
}

