/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.pointset;

import net.imglib2.AbstractCursor;
import net.imglib2.ops.pointset.AbstractPointSet;
import net.imglib2.ops.pointset.BoundsCalculator;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.ops.pointset.PointSetIterator;

@Deprecated
public class PointSetDifference
extends AbstractPointSet {
    private final PointSet a;
    private final PointSet b;
    private final BoundsCalculator calculator;
    private boolean needsCalc;

    public PointSetDifference(PointSet a, PointSet b) {
        if (a.numDimensions() != b.numDimensions()) {
            throw new IllegalArgumentException();
        }
        this.a = a;
        this.b = b;
        this.calculator = new BoundsCalculator();
        this.needsCalc = true;
    }

    @Override
    public long[] getOrigin() {
        return this.a.getOrigin();
    }

    @Override
    public void translate(long[] deltas) {
        this.a.translate(deltas);
        this.b.translate(deltas);
        this.needsCalc = true;
        this.invalidateBounds();
    }

    @Override
    public PointSetIterator iterator() {
        return new PointSetDifferenceIterator();
    }

    @Override
    public int numDimensions() {
        return this.a.numDimensions();
    }

    @Override
    public boolean includes(long[] point) {
        return this.a.includes(point) && !this.b.includes(point);
    }

    @Override
    protected long[] findBoundMin() {
        if (this.needsCalc) {
            this.calculator.calc(this);
            this.needsCalc = false;
        }
        return this.calculator.getMin();
    }

    @Override
    protected long[] findBoundMax() {
        if (this.needsCalc) {
            this.calculator.calc(this);
            this.needsCalc = false;
        }
        return this.calculator.getMax();
    }

    @Override
    public long size() {
        long numElements = 0L;
        PointSetIterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            ++numElements;
        }
        return numElements;
    }

    @Override
    public PointSetDifference copy() {
        return new PointSetDifference(this.a.copy(), this.b.copy());
    }

    private class PointSetDifferenceIterator
    extends AbstractCursor<long[]>
    implements PointSetIterator {
        private final PointSetIterator aIter;
        private long[] curr;
        private long[] nextCache;

        public PointSetDifferenceIterator() {
            super(PointSetDifference.this.a.numDimensions());
            this.aIter = PointSetDifference.this.a.iterator();
            this.reset();
        }

        public boolean hasNext() {
            if (this.nextCache != null) {
                return true;
            }
            return this.positionToNext();
        }

        public void reset() {
            this.aIter.reset();
            this.curr = null;
            this.nextCache = null;
        }

        public long[] get() {
            return this.curr;
        }

        public void fwd() {
            if (this.nextCache != null || this.positionToNext()) {
                if (this.curr == null) {
                    this.curr = new long[this.n];
                }
                for (int i = 0; i < this.n; ++i) {
                    this.curr[i] = this.nextCache[i];
                }
                this.nextCache = null;
                return;
            }
            throw new IllegalArgumentException("fwd() cannot go beyond end");
        }

        public void localize(long[] position) {
            for (int i = 0; i < this.n; ++i) {
                position[i] = this.curr[i];
            }
        }

        public long getLongPosition(int d) {
            return this.curr[d];
        }

        public AbstractCursor<long[]> copy() {
            return new PointSetDifferenceIterator();
        }

        public AbstractCursor<long[]> copyCursor() {
            return this.copy();
        }

        private boolean positionToNext() {
            this.nextCache = null;
            while (this.aIter.hasNext()) {
                long[] pos = (long[])this.aIter.next();
                if (PointSetDifference.this.b.includes(pos)) continue;
                this.nextCache = pos;
                return true;
            }
            return false;
        }
    }
}

