/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.analyzeSkeleton;

import java.util.ArrayList;
import java.util.stream.Collectors;
import sc.fiji.analyzeSkeleton.Point;
import sc.fiji.analyzeSkeleton.Vertex;

public class Edge {
    public static final int TREE = 0;
    public static final int BACK = 1;
    public static final int UNDEFINED = -1;
    private int type = -1;
    private Vertex v1 = null;
    private Vertex v2 = null;
    private ArrayList<Point> slabs = null;
    private double length = 0.0;
    private double color = 0.0;
    private double color3rd = 0.0;
    private double length_ra = 0.0;

    public Edge(Vertex v1, Vertex v2, ArrayList<Point> slabs, double length) {
        this.v1 = v1;
        this.v2 = v2;
        this.slabs = slabs;
        this.length = length;
    }

    public Edge(Vertex v1, Vertex v2, ArrayList<Point> slabs, double length, double color3rd, double color, double length_ra) {
        this.v1 = v1;
        this.v2 = v2;
        this.slabs = slabs;
        this.length = length;
        this.color = color;
        this.color3rd = color3rd;
        this.length_ra = length_ra;
    }

    public Vertex getV1() {
        return this.v1;
    }

    public Vertex getV2() {
        return this.v2;
    }

    public ArrayList<Point> getSlabs() {
        return this.slabs;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public Vertex getOppositeVertex(Vertex v) {
        if (this.v1.equals(v)) {
            return this.v2;
        }
        if (this.v2.equals(v)) {
            return this.v1;
        }
        return null;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public double getLength() {
        return this.length;
    }

    public double getLength_ra() {
        return this.length_ra;
    }

    public void setColor(double color) {
        this.color = color;
    }

    public double getColor() {
        return this.color;
    }

    public void setColor3rd(double color) {
        this.color3rd = color;
    }

    public double getColor3rd() {
        return this.color3rd;
    }

    public Edge clone(Vertex v1, Vertex v2) {
        ArrayList clonedSlabs = this.slabs != null ? this.slabs.stream().map(Point::clone).collect(Collectors.toCollection(ArrayList::new)) : null;
        Edge clonedEdge = new Edge(v1, v2, clonedSlabs, this.length, this.color3rd, this.color, this.length_ra);
        clonedEdge.setType(this.type);
        return clonedEdge;
    }
}

