/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.loaders.lw3d;

import java.io.IOException;
import java.io.StreamTokenizer;
import org.scijava.java3d.Background;
import org.scijava.java3d.BoundingSphere;
import org.scijava.java3d.loaders.ParsingErrorException;
import org.scijava.java3d.loaders.lw3d.TextfileParser;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Point3d;

class LwsBackground
extends TextfileParser {
    int solidBackdrop;
    Color3f color;
    Color3f zenithColor;
    Color3f skyColor;
    Color3f groundColor;
    Color3f nadirColor;
    Background backgroundObject = null;

    LwsBackground(StreamTokenizer st, int debugVals) throws ParsingErrorException {
        this.debugPrinter.setValidOutput(debugVals);
        this.debugOutput(1, "LwsBackground()");
        this.color = new Color3f(0.0f, 0.0f, 0.0f);
        this.zenithColor = new Color3f(0.0f, 0.0f, 0.0f);
        this.skyColor = new Color3f(0.0f, 0.0f, 0.0f);
        this.groundColor = new Color3f(0.0f, 0.0f, 0.0f);
        this.nadirColor = new Color3f(0.0f, 0.0f, 0.0f);
        this.solidBackdrop = (int)this.getNumber(st);
        while (!this.isCurrentToken(st, "FogType")) {
            this.debugOutputLn(8, "currentToken = " + st.sval);
            if (this.isCurrentToken(st, "BackdropColor")) {
                this.color.x = (float)this.getNumber(st) / 255.0f;
                this.color.y = (float)this.getNumber(st) / 255.0f;
                this.color.z = (float)this.getNumber(st) / 255.0f;
            } else if (this.isCurrentToken(st, "NadirColor")) {
                this.nadirColor.x = (float)this.getNumber(st) / 255.0f;
                this.nadirColor.y = (float)this.getNumber(st) / 255.0f;
                this.nadirColor.z = (float)this.getNumber(st) / 255.0f;
            } else if (this.isCurrentToken(st, "SkyColor")) {
                this.skyColor.x = (float)this.getNumber(st) / 255.0f;
                this.skyColor.y = (float)this.getNumber(st) / 255.0f;
                this.skyColor.z = (float)this.getNumber(st) / 255.0f;
            } else if (this.isCurrentToken(st, "GroundColor")) {
                this.groundColor.x = (float)this.getNumber(st) / 255.0f;
                this.groundColor.y = (float)this.getNumber(st) / 255.0f;
                this.groundColor.z = (float)this.getNumber(st) / 255.0f;
            } else if (this.isCurrentToken(st, "NadirColor")) {
                this.nadirColor.x = (float)this.getNumber(st) / 255.0f;
                this.nadirColor.y = (float)this.getNumber(st) / 255.0f;
                this.nadirColor.z = (float)this.getNumber(st) / 255.0f;
            }
            try {
                st.nextToken();
            }
            catch (IOException e) {
                throw new ParsingErrorException(e.getMessage());
            }
        }
        st.pushBack();
    }

    void createJava3dObject() {
        if (this.solidBackdrop != 0) {
            this.backgroundObject = new Background(this.color);
            this.debugOutput(2, "Background color = " + this.color);
        } else {
            this.backgroundObject = new Background(this.skyColor);
            this.debugOutput(2, "Background color = " + this.skyColor);
        }
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100000.0);
        this.backgroundObject.setApplicationBounds(bounds);
    }

    Background getObjectNode() {
        return this.backgroundObject;
    }

    void printVals() {
        this.debugOutputLn(2, "  BACKGROUND vals: ");
    }
}

