/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.scijava.java3d.Font3D;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.java3d.Text3D;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.GeometryState;
import org.scijava.vecmath.Point3f;

public class Text3DState
extends GeometryState {
    private int font3d;
    private String string;

    public Text3DState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            this.font3d = control.getSymbolTable().addReference(((Text3D)this.node).getFont3D());
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeInt(((Text3D)this.node).getAlignment());
        out.writeFloat(((Text3D)this.node).getCharacterSpacing());
        out.writeInt(this.font3d);
        out.writeInt(((Text3D)this.node).getPath());
        Point3f pos = new Point3f();
        ((Text3D)this.node).getPosition(pos);
        this.control.writePoint3f(out, pos);
        out.writeUTF(((Text3D)this.node).getString());
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        ((Text3D)this.node).setAlignment(in.readInt());
        ((Text3D)this.node).setCharacterSpacing(in.readFloat());
        this.font3d = in.readInt();
        ((Text3D)this.node).setPath(in.readInt());
        ((Text3D)this.node).setPosition(this.control.readPoint3f(in));
        this.string = in.readUTF();
    }

    @Override
    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.font3d);
    }

    @Override
    public void buildGraph() {
        ((Text3D)this.node).setFont3D((Font3D)this.control.getSymbolTable().getJ3dNode(this.font3d));
        ((Text3D)this.node).setString(this.string);
        super.buildGraph();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Text3D();
    }
}

