/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;

abstract class AbstractDecomposition<N extends Number>
implements MatrixDecomposition<N> {
    private boolean myAspectRatioNormal = true;
    private boolean myComputed = false;
    private Boolean mySolvable = null;

    AbstractDecomposition() {
    }

    @Override
    public final boolean isComputed() {
        return this.myComputed;
    }

    public final boolean isSolvable() {
        if (this.myComputed && this.mySolvable == null) {
            this.mySolvable = this instanceof MatrixDecomposition.Solver ? Boolean.valueOf(this.checkSolvability()) : Boolean.FALSE;
        }
        return this.myComputed && this.mySolvable != false;
    }

    @Override
    public void reset() {
        this.myAspectRatioNormal = true;
        this.myComputed = false;
        this.mySolvable = null;
    }

    protected abstract DecompositionStore<N> allocate(long var1, long var3);

    protected final boolean aspectRatioNormal(boolean aspectRatioNormal) {
        this.myAspectRatioNormal = aspectRatioNormal;
        return this.myAspectRatioNormal;
    }

    protected boolean checkSolvability() {
        return false;
    }

    protected final boolean computed(boolean computed) {
        this.myComputed = computed;
        return this.myComputed;
    }

    protected abstract double getDimensionalEpsilon();

    protected final boolean isAspectRatioNormal() {
        return this.myAspectRatioNormal;
    }
}

