/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.algebra.VectorSpace;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.Scalar;

public final class ApplyCholesky
extends MatrixOperation {
    public static final ApplyCholesky SETUP = new ApplyCholesky();
    public static int THRESHOLD = 128;

    public static void invoke(BigDecimal[] data, int structure, int firstColumn, int columnLimit, BigDecimal[] multipliers) {
        for (int j = firstColumn; j < columnLimit; ++j) {
            AXPY.invoke(data, j * structure, multipliers[j].negate(), multipliers, 0, j, structure);
        }
    }

    public static void invoke(double[] data, int structure, int firstColumn, int columnLimit, double[] multipliers) {
        for (int j = firstColumn; j < columnLimit; ++j) {
            AXPY.invoke(data, j * structure, -multipliers[j], multipliers, 0, j, structure);
        }
    }

    public static <N extends Number> void invoke(N[] data, int structure, int firstColumn, int columnLimit, N[] multipliers) {
        for (int j = firstColumn; j < columnLimit; ++j) {
            AXPY.invoke(data, (int)(j * structure), ((Scalar)((Scalar)((VectorSpace)multipliers[j]).conjugate()).negate()).get(), multipliers, (int)0, (int)j, (int)structure);
        }
    }

    private ApplyCholesky() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

